/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.audioprocessing;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Log;

class Native
extends fm.icelink.Native {
    private long _state;

    public Native(int clockRate, int channelCount) {
        this._state = Native.AudioProcessingFMAcousticEchoCancellerCreate(0L, 0L, 0L, 0L, clockRate, channelCount);
    }

    public void destroy() {
        Native.AudioProcessingFMAcousticEchoCancellerDestroy(this._state);
        this._state = 0L;
    }

    public AudioBuffer capture(AudioFrame frame, AudioBuffer inputBuffer, AudioFormat outputFormat, int tailLength) {
        DataBuffer inputDataBuffer = inputBuffer.getDataBuffer();
        byte[] outputData = Native.AudioProcessingFMAcousticEchoCancellerCapture(this._state, inputDataBuffer.getData(), inputDataBuffer.getIndex(), inputDataBuffer.getLength(), tailLength);
        if (outputData != null) {
            DataBuffer outputDataBuffer = DataBuffer.wrap((byte[])outputData);
            outputDataBuffer.setLittleEndian(inputDataBuffer.getLittleEndian());
            return new AudioBuffer(outputDataBuffer, outputFormat);
        }
        return null;
    }

    public void render(AudioFrame frame) {
        AudioBuffer audioBuffer = ((AudioBuffer[])frame.getBuffers())[((AudioBuffer[])frame.getBuffers()).length - 1];
        DataBuffer pcm = audioBuffer.getDataBuffer();
        Native.AudioProcessingFMAcousticEchoCancellerRender(this._state, pcm.getData(), pcm.getIndex(), pcm.getLength());
    }

    private static void DebugCallback(String msg) {
        Log.info((String)("LibAudioProcessingFM: " + msg));
    }

    private static void ErrorCallback(String msg) {
        Log.error((String)("LibAudioProcessingFM: " + msg));
    }

    private static native long AudioProcessingFMAcousticEchoCancellerCreate(long var0, long var2, long var4, long var6, int var8, int var9);

    private static native void AudioProcessingFMAcousticEchoCancellerDestroy(long var0);

    private static native void AudioProcessingFMAcousticEchoCancellerRender(long var0, byte[] var2, int var3, int var4);

    private static native byte[] AudioProcessingFMAcousticEchoCancellerCapture(long var0, byte[] var2, int var3, int var4, int var5);

    static {
        Global.loadLibrary((String)"audioprocessingfmJNI");
    }
}

