/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.opus;

import fm.icelink.ArrayExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioDecoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.Error;
import fm.icelink.Holder;
import fm.icelink.IAudioSource;
import fm.icelink.IMediaSource;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaControlFrame;
import fm.icelink.ParseAssistant;
import fm.icelink.StringExtensions;
import fm.icelink.opus.Format;
import fm.icelink.opus.Native;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.MaxPacketTimeAttribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.PacketTimeAttribute;
import fm.icelink.sdp.rtp.MapAttribute;

public class Decoder
extends AudioDecoder {
    private int __currentChannelCount = -1;
    private int __currentClockRate = -1;
    private double __currentPacketTime = 20.0;
    private long __currentSequenceNumber = -1L;
    private Native __decoder;
    private long __lastSequenceNumber = -1L;

    private AudioBuffer decode(AudioBuffer encodedFrame, AudioFormat outputFormat, boolean fec) {
        AudioBuffer buffer = this.__decoder.decode(encodedFrame, outputFormat, fec);
        if (buffer != null) {
            buffer.getDataBuffer().setLittleEndian(outputFormat.getLittleEndian());
            return buffer;
        }
        return null;
    }

    private AudioBuffer[] decode(AudioBuffer buffer, AudioFormat outputFormat) {
        if (buffer != null) {
            int num5;
            int num3;
            if (this.__decoder == null) {
                this.__currentClockRate = ((AudioFormat)buffer.getFormat()).getClockRate();
                this.__currentChannelCount = ((AudioFormat)buffer.getFormat()).getChannelCount();
                this.__decoder = new Native(false, this.__currentClockRate, this.__currentChannelCount, this.__currentPacketTime);
            }
            if (this.__lastSequenceNumber == -1L) {
                this.__lastSequenceNumber = this.__currentSequenceNumber;
                return new AudioBuffer[]{this.decodeNormal(buffer, outputFormat)};
            }
            int num = (int)(this.__currentSequenceNumber - this.__lastSequenceNumber);
            if (num <= 0) {
                return null;
            }
            this.__lastSequenceNumber = this.__currentSequenceNumber;
            Object[] bufferArray = new AudioBuffer[num];
            int num2 = num - 1;
            int n = num3 = num2 > 1 ? num2 - 1 : 0;
            if (num3 > 0) {
                Log.info((String)StringExtensions.format((String)"Adding {0} frames of loss concealment to incoming audio stream. Packet sequence violated.", (Object)IntegerExtensions.toString((Integer)num3)));
                for (int i = 0; i < num3; ++i) {
                    bufferArray[i] = this.decodePLC(outputFormat);
                }
            }
            int n2 = num5 = num2 > 0 ? 1 : 0;
            if (num5 > 0) {
                AudioBuffer buffer2 = this.decodeFEC(buffer, outputFormat);
                int index = num2 - 1;
                bufferArray[index] = buffer2 == null ? this.decodePLC(outputFormat) : buffer2;
            }
            bufferArray[ArrayExtensions.getLength((Object[])bufferArray) - 1] = this.decodeNormal(buffer, outputFormat);
            return bufferArray;
        }
        return null;
    }

    private AudioBuffer decodeFEC(AudioBuffer encodedFrame, AudioFormat outputFormat) {
        return this.decode(encodedFrame, outputFormat, true);
    }

    private AudioBuffer decodeNormal(AudioBuffer encodedFrame, AudioFormat outputFormat) {
        return this.decode(encodedFrame, outputFormat, false);
    }

    private AudioBuffer decodePLC(AudioFormat outputFormat) {
        return this.decode(null, outputFormat, false);
    }

    public Decoder() {
        this(new Format().getConfig());
    }

    public Decoder(AudioConfig config) {
        super((AudioFormat)new Format(config), (AudioFormat)new fm.icelink.pcm.Format(config));
    }

    public Decoder(IAudioSource source) {
        this(source.getConfig());
        super.addSource((IMediaSource)source);
    }

    protected void doDestroy() {
        if (this.__decoder != null) {
            this.__decoder.destroy();
            this.__decoder = null;
        }
    }

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
    }

    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        for (AudioBuffer buffer : (AudioBuffer[])frame.getBuffers()) {
            if (!((AudioFormat)buffer.getFormat()).isEquivalent(super.getInputFormat(), true) || !((AudioFormat)buffer.getFormat()).getIsPacketized()) continue;
            this.__currentSequenceNumber = buffer.getSequenceNumber();
        }
        AudioBuffer[] buffers = this.decode(inputBuffer, (AudioFormat)super.getOutputFormat());
        if (buffers != null && buffers[0] != null) {
            frame.addBuffers((MediaBuffer[])buffers);
            this.raiseFrame(frame);
            for (AudioBuffer buffer : buffers) {
                buffer.releaseBuffers();
            }
        }
    }

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        MapAttribute rtpMapAttribute = mediaDescription.getRtpMapAttribute(super.getInputFormat());
        if (rtpMapAttribute != null) {
            FormatParametersAttribute relatedFormatParametersAttribute = rtpMapAttribute.getRelatedFormatParametersAttribute();
            if (isLocalDescription) {
                if (relatedFormatParametersAttribute == null) {
                    relatedFormatParametersAttribute = new FormatParametersAttribute(rtpMapAttribute.getPayloadType());
                    rtpMapAttribute.setRelatedFormatParametersAttribute(relatedFormatParametersAttribute);
                }
                relatedFormatParametersAttribute.setFormatSpecificParameter("useinbandfec", "1");
            } else {
                int intResult = 10;
                if (relatedFormatParametersAttribute != null) {
                    String str = null;
                    Holder _var0 = new Holder(str);
                    boolean _var1 = relatedFormatParametersAttribute.tryGetFormatSpecificParameter("minptime", _var0);
                    str = (String)_var0.getValue();
                    IntegerHolder _var2 = new IntegerHolder(intResult);
                    boolean _var3 = ParseAssistant.tryParseIntegerValue((String)str, (IntegerHolder)_var2);
                    intResult = _var2.getValue();
                    if (_var1 && !_var3) {
                        intResult = 10;
                    }
                }
                int packetTime = 20;
                PacketTimeAttribute packetTimeAttribute = mediaDescription.getPacketTimeAttribute();
                if (packetTimeAttribute != null) {
                    packetTime = packetTimeAttribute.getPacketTime();
                }
                int maxPacketTime = 60;
                MaxPacketTimeAttribute maxPacketTimeAttribute = mediaDescription.getMaxPacketTimeAttribute();
                if (maxPacketTimeAttribute != null) {
                    maxPacketTime = maxPacketTimeAttribute.getMaxPacketTime();
                }
                this.__currentPacketTime = packetTime;
            }
        }
        return null;
    }

    public String getLabel() {
        return "Opus Decoder";
    }
}

