/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vp9;

import fm.icelink.DataBuffer;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.RtpPacket;
import fm.icelink.vp9.Assembler;
import fm.icelink.vp9.Fragment;
import fm.icelink.vp9.Packet;
import java.util.ArrayList;
import java.util.HashMap;

class Accumulator {
    private HashMap<String, Assembler> _fragmentedPacketsMap = new HashMap();

    public DataBuffer add(RtpPacket rtpPacket, long sequenceNumber, LongHolder newSequenceNumber) {
        newSequenceNumber.setValue(sequenceNumber);
        Fragment fragment = this.extractFragment(rtpPacket, sequenceNumber);
        if (fragment.getFirst() && fragment.getLast()) {
            return fragment.getBuffer();
        }
        String key = LongExtensions.toString(rtpPacket.getTimestamp());
        Assembler assembler = null;
        Holder<Object> _var0 = new Holder<Object>(assembler);
        boolean _var1 = HashMapExtensions.tryGetValue(this._fragmentedPacketsMap, key, _var0);
        assembler = _var0.getValue();
        if (_var1) {
            assembler.add(fragment);
            if (assembler.getIsComplete()) {
                HashMapExtensions.remove(this._fragmentedPacketsMap, key);
                DataBuffer _var2 = assembler.assemble(newSequenceNumber);
                return _var2;
            }
        } else {
            HashMapExtensions.set(HashMapExtensions.getItem(this._fragmentedPacketsMap), key, new Assembler(fragment));
        }
        return null;
    }

    public int clearAged() {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : HashMapExtensions.getKeys(this._fragmentedPacketsMap)) {
            list.add(str);
        }
        int num = 0;
        for (String str : list) {
            Assembler assembler = HashMapExtensions.getItem(this._fragmentedPacketsMap).get(str);
            assembler.increaseAge();
            if (!assembler.getIsAged()) continue;
            HashMapExtensions.remove(this._fragmentedPacketsMap, str);
            ++num;
        }
        return num;
    }

    public void clearAll() {
        this._fragmentedPacketsMap.clear();
    }

    private Fragment extractFragment(RtpPacket rtpPacket, long sequenceNumber) {
        Packet packet = Packet.wrap(rtpPacket.getPayload());
        Fragment fragment = new Fragment();
        fragment.setFirst(packet.getStartOfLayerFrame());
        fragment.setLast(rtpPacket.getMarker());
        fragment.setSequenceNumber(sequenceNumber);
        fragment.setBuffer(packet.getPayload());
        return fragment;
    }
}

