/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.ClassExtensions;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.stun.AlternateServerAttribute;
import fm.icelink.stun.AttributeCreationArgs;
import fm.icelink.stun.AttributeRegistration;
import fm.icelink.stun.ErrorCodeAttribute;
import fm.icelink.stun.FingerprintAttribute;
import fm.icelink.stun.MappedAddressAttribute;
import fm.icelink.stun.Message;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.NonceAttribute;
import fm.icelink.stun.RealmAttribute;
import fm.icelink.stun.SoftwareAttribute;
import fm.icelink.stun.UnknownAttributesAttribute;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.XorMappedAddressAttribute;
import fm.icelink.stun.ice.ControlledAttribute;
import fm.icelink.stun.ice.ControllingAttribute;
import fm.icelink.stun.ice.PriorityAttribute;
import fm.icelink.stun.ice.UseCandidateAttribute;
import fm.icelink.stun.turn.ChannelNumberAttribute;
import fm.icelink.stun.turn.ConnectionIdAttribute;
import fm.icelink.stun.turn.DataAttribute;
import fm.icelink.stun.turn.DontFragmentAttribute;
import fm.icelink.stun.turn.EvenPortAttribute;
import fm.icelink.stun.turn.LifetimeAttribute;
import fm.icelink.stun.turn.RequestedAddressFamilyAttribute;
import fm.icelink.stun.turn.RequestedTransportAttribute;
import fm.icelink.stun.turn.ReservationTokenAttribute;
import fm.icelink.stun.turn.XorPeerAddressAttribute;
import fm.icelink.stun.turn.XorRelayedAddressAttribute;
import java.util.HashMap;

public abstract class Attribute {
    private static String _blankIPv4Address;
    private static byte[] _blankIPv4AddressBytes;
    private static String _blankIPv6Address;
    private static byte[] _blankIPv6AddressBytes;
    private static HashMap<String, AttributeRegistration> _registeredAttributes;
    private static Object _registeredAttributesLock;

    protected Attribute() {
    }

    private static Attribute createAlternateServerAttribute(AttributeCreationArgs e) {
        return AlternateServerAttribute.fromValueBytes(e.getValueBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attribute createAttribute(byte byte1, byte byte2, byte[] valueBytes, byte[] transactionId, byte[] messageBytes) {
        Object object = _registeredAttributesLock;
        synchronized (object) {
            byte[] buffer = new byte[]{byte1, byte2};
            for (String str : HashMapExtensions.getKeys(_registeredAttributes)) {
                AttributeRegistration registration = HashMapExtensions.getItem(_registeredAttributes).get(str);
                if (!BitAssistant.sequencesAreEqual(registration.getTypeBytes(), buffer)) continue;
                return registration.getCreationDelegate().invoke(new AttributeCreationArgs(valueBytes, transactionId, messageBytes));
            }
        }
        return null;
    }

    private static Attribute createChannelNumberAttribute(AttributeCreationArgs e) {
        return ChannelNumberAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createConnectionIdAttribute(AttributeCreationArgs e) {
        return ConnectionIdAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createDataAttribute(AttributeCreationArgs e) {
        return DataAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createDontFragmentAttribute(AttributeCreationArgs e) {
        return DontFragmentAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createErrorCodeAttribute(AttributeCreationArgs e) {
        return ErrorCodeAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createEvenPortAttribute(AttributeCreationArgs e) {
        return EvenPortAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createFingerprintAttribute(AttributeCreationArgs e) {
        return FingerprintAttribute.fromValueBytes(e.getValueBytes(), e.getMessageBytes());
    }

    private static Attribute createIceControlledAttribute(AttributeCreationArgs e) {
        return ControlledAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createIceControllingAttribute(AttributeCreationArgs e) {
        return ControllingAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createLifetimeAttribute(AttributeCreationArgs e) {
        return LifetimeAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createMappedAddressAttribute(AttributeCreationArgs e) {
        return MappedAddressAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createMessageIntegrityAttribute(AttributeCreationArgs e) {
        return MessageIntegrityAttribute.fromValueBytes(e.getValueBytes(), e.getMessageBytes());
    }

    private static Attribute createNonceAttribute(AttributeCreationArgs e) {
        return NonceAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createPriorityAttribute(AttributeCreationArgs e) {
        return PriorityAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createRealmAttribute(AttributeCreationArgs e) {
        return RealmAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createRequestedAddressFamilyAttribute(AttributeCreationArgs e) {
        return RequestedAddressFamilyAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createRequestedTransportAttribute(AttributeCreationArgs e) {
        return RequestedTransportAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createReservationTokenAttribute(AttributeCreationArgs e) {
        return ReservationTokenAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createSoftwareAttribute(AttributeCreationArgs e) {
        return SoftwareAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createUnknownAttributesAttribute(AttributeCreationArgs e) {
        return UnknownAttributesAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createUseCandidateAttribute(AttributeCreationArgs e) {
        return UseCandidateAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createUsernameAttribute(AttributeCreationArgs e) {
        return UsernameAttribute.fromValueBytes(e.getValueBytes());
    }

    private static Attribute createXorMappedAddressAttribute(AttributeCreationArgs e) {
        return XorMappedAddressAttribute.fromValueBytes(e.getValueBytes(), e.getTransactionId());
    }

    private static Attribute createXorPeerAddressAttribute(AttributeCreationArgs e) {
        return XorPeerAddressAttribute.fromValueBytes(e.getValueBytes(), e.getTransactionId());
    }

    private static Attribute createXorRelayedAddressAttribute(AttributeCreationArgs e) {
        return XorRelayedAddressAttribute.fromValueBytes(e.getValueBytes(), e.getTransactionId());
    }

    protected static String getBlankIPv4Address() {
        return _blankIPv4Address;
    }

    protected static byte[] getBlankIPv4AddressBytes() {
        return _blankIPv4AddressBytes;
    }

    protected static String getBlankIPv6Address() {
        return _blankIPv6Address;
    }

    protected static byte[] getBlankIPv6AddressBytes() {
        return _blankIPv6AddressBytes;
    }

    public byte[] getBytes() {
        ByteCollection bytes = new ByteCollection();
        byte[] valueBytes = this.getValueBytes();
        byte[] typeBytes = Attribute.getTypeBytes(super.getClass());
        if (typeBytes == null) {
            throw new RuntimeException(new Exception("Attribute type unknown. See Attribute.RegisterAttribute to register the attribute type."));
        }
        bytes.addRange(typeBytes);
        int length = 0;
        if (valueBytes != null) {
            length = ArrayExtensions.getLength(valueBytes);
        }
        bytes.addRange(Binary.toBytes16(length, false));
        if (valueBytes != null) {
            bytes.addRange(valueBytes);
            while (bytes.getCount() % 4 > 0) {
                bytes.add((byte)0);
            }
        }
        return bytes.toArray();
    }

    public static int getLength(byte[] bytes) {
        if (ArrayExtensions.getLength(bytes) < 4) {
            return -1;
        }
        return Binary.fromBytes16(bytes, 2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getTypeBytes(Class type) {
        Object object = _registeredAttributesLock;
        synchronized (object) {
            AttributeRegistration registration = null;
            Holder<Object> _var0 = new Holder<Object>(registration);
            boolean _var1 = HashMapExtensions.tryGetValue(_registeredAttributes, ClassExtensions.getFullName(type), _var0);
            registration = _var0.getValue();
            if (_var1) {
                return registration.getTypeBytes();
            }
        }
        Class baseType = type.getSuperclass();
        if (baseType != null) {
            return Attribute.getTypeBytes(baseType);
        }
        return null;
    }

    protected abstract byte[] getValueBytes();

    public static Attribute parseBytes(byte[] bytes, byte[] transactionId, byte[] messageBytes) {
        int count;
        byte[] valueBytes;
        byte[] buffer = BitAssistant.subArray(bytes, 0, 2);
        Attribute attribute = Attribute.createAttribute(buffer[0], buffer[1], valueBytes = BitAssistant.subArray(bytes, 4, count = Binary.fromBytes16(bytes, 2, false)), transactionId, messageBytes);
        if (attribute != null) {
            return attribute;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerAttribute(Class type, boolean comprehensionRequired, byte typeByte, IFunction1<AttributeCreationArgs, Attribute> creationDelegate) {
        Object object = _registeredAttributesLock;
        synchronized (object) {
            byte num = comprehensionRequired ? (byte)0 : -128;
            byte[] typeBytes = new byte[]{num, typeByte};
            HashMapExtensions.set(HashMapExtensions.getItem(_registeredAttributes), ClassExtensions.getFullName(type), new AttributeRegistration(typeBytes, creationDelegate));
        }
    }

    private static void setBlankIPv4Address(String value) {
        _blankIPv4Address = value;
    }

    private static void setBlankIPv4AddressBytes(byte[] value) {
        _blankIPv4AddressBytes = value;
    }

    private static void setBlankIPv6Address(String value) {
        _blankIPv6Address = value;
    }

    private static void setBlankIPv6AddressBytes(byte[] value) {
        _blankIPv6AddressBytes = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unregisterAttribute(Class type) {
        Object object = _registeredAttributesLock;
        synchronized (object) {
            return HashMapExtensions.remove(_registeredAttributes, ClassExtensions.getFullName(type));
        }
    }

    protected static void xorIPAddress(byte[] ipAddressBytes, byte[] transactionId) {
        int num;
        for (num = 0; num < ArrayExtensions.getLength(Message.getMagicCookie()); ++num) {
            ipAddressBytes[num] = (byte)(ipAddressBytes[num] ^ Message.getMagicCookie()[num]);
        }
        if (ArrayExtensions.getLength(ipAddressBytes) > ArrayExtensions.getLength(Message.getMagicCookie())) {
            for (num = 0; num < ArrayExtensions.getLength(transactionId); ++num) {
                ipAddressBytes[num + ArrayExtensions.getLength((byte[])Message.getMagicCookie())] = (byte)(ipAddressBytes[num + ArrayExtensions.getLength(Message.getMagicCookie())] ^ transactionId[num]);
            }
        }
    }

    protected static void xorPort(byte[] portBytes, byte[] transactionId) {
        for (int i = 0; i < ArrayExtensions.getLength(portBytes); ++i) {
            portBytes[i] = (byte)(portBytes[i] ^ Message.getMagicCookie()[i]);
        }
    }

    static {
        _registeredAttributes = new HashMap();
        _registeredAttributesLock = new Object();
        Attribute.setBlankIPv4AddressBytes(new byte[]{0, 0, 0, 0});
        Attribute.setBlankIPv4Address("0.0.0.0");
        Attribute.setBlankIPv6AddressBytes(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        Attribute.setBlankIPv6Address("0:0:0:0:0:0:0:0");
        byte typeByte = 35;
        byte num2 = 9;
        byte num3 = 40;
        byte num4 = 1;
        byte num5 = 8;
        byte num6 = 21;
        byte num7 = 20;
        byte num8 = 34;
        byte num9 = 10;
        byte num10 = 6;
        byte num11 = 32;
        Attribute.registerAttribute(AlternateServerAttribute.class, false, typeByte, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createAlternateServerAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createAlternateServerAttribute(e);
            }
        });
        Attribute.registerAttribute(ErrorCodeAttribute.class, true, num2, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createErrorCodeAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createErrorCodeAttribute(e);
            }
        });
        Attribute.registerAttribute(FingerprintAttribute.class, false, num3, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createFingerprintAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createFingerprintAttribute(e);
            }
        });
        Attribute.registerAttribute(MappedAddressAttribute.class, true, num4, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createMappedAddressAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createMappedAddressAttribute(e);
            }
        });
        Attribute.registerAttribute(MessageIntegrityAttribute.class, true, num5, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createMessageIntegrityAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createMessageIntegrityAttribute(e);
            }
        });
        Attribute.registerAttribute(NonceAttribute.class, true, num6, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createNonceAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createNonceAttribute(e);
            }
        });
        Attribute.registerAttribute(RealmAttribute.class, true, num7, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createRealmAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createRealmAttribute(e);
            }
        });
        Attribute.registerAttribute(SoftwareAttribute.class, false, num8, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createSoftwareAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createSoftwareAttribute(e);
            }
        });
        Attribute.registerAttribute(UnknownAttributesAttribute.class, true, num9, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createUnknownAttributesAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createUnknownAttributesAttribute(e);
            }
        });
        Attribute.registerAttribute(UsernameAttribute.class, true, num10, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createUsernameAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createUsernameAttribute(e);
            }
        });
        Attribute.registerAttribute(XorMappedAddressAttribute.class, true, num11, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createXorMappedAddressAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createXorMappedAddressAttribute(e);
            }
        });
        byte num12 = 41;
        byte num13 = 42;
        byte num14 = 36;
        byte num15 = 37;
        Attribute.registerAttribute(ControlledAttribute.class, false, num12, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createIceControlledAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createIceControlledAttribute(e);
            }
        });
        Attribute.registerAttribute(ControllingAttribute.class, false, num13, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createIceControllingAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createIceControllingAttribute(e);
            }
        });
        Attribute.registerAttribute(PriorityAttribute.class, true, num14, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createPriorityAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createPriorityAttribute(e);
            }
        });
        Attribute.registerAttribute(UseCandidateAttribute.class, true, num15, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createUseCandidateAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createUseCandidateAttribute(e);
            }
        });
        byte num16 = 12;
        byte num17 = 42;
        byte num18 = 19;
        byte num19 = 26;
        byte num20 = 24;
        byte num21 = 13;
        byte num22 = 25;
        byte num23 = 34;
        byte num24 = 18;
        byte num25 = 22;
        Attribute.registerAttribute(ChannelNumberAttribute.class, true, num16, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createChannelNumberAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createChannelNumberAttribute(e);
            }
        });
        Attribute.registerAttribute(ConnectionIdAttribute.class, true, num17, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createConnectionIdAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createConnectionIdAttribute(e);
            }
        });
        Attribute.registerAttribute(DataAttribute.class, true, num18, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createDataAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createDataAttribute(e);
            }
        });
        Attribute.registerAttribute(DontFragmentAttribute.class, true, num19, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createDontFragmentAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createDontFragmentAttribute(e);
            }
        });
        Attribute.registerAttribute(EvenPortAttribute.class, true, num20, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createEvenPortAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createEvenPortAttribute(e);
            }
        });
        Attribute.registerAttribute(LifetimeAttribute.class, true, num21, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createLifetimeAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createLifetimeAttribute(e);
            }
        });
        Attribute.registerAttribute(RequestedTransportAttribute.class, true, num22, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createRequestedTransportAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createRequestedTransportAttribute(e);
            }
        });
        Attribute.registerAttribute(ReservationTokenAttribute.class, true, num23, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createReservationTokenAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createReservationTokenAttribute(e);
            }
        });
        Attribute.registerAttribute(XorPeerAddressAttribute.class, true, num24, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createXorPeerAddressAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createXorPeerAddressAttribute(e);
            }
        });
        Attribute.registerAttribute(XorRelayedAddressAttribute.class, true, num25, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createXorRelayedAddressAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createXorRelayedAddressAttribute(e);
            }
        });
        byte num26 = 23;
        Attribute.registerAttribute(RequestedAddressFamilyAttribute.class, true, num26, (IFunction1<AttributeCreationArgs, Attribute>)new IFunctionDelegate1<AttributeCreationArgs, Attribute>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Attribute.createRequestedAddressFamilyAttribute";
            }

            @Override
            public Attribute invoke(AttributeCreationArgs e) {
                return Attribute.createRequestedAddressFamilyAttribute(e);
            }
        });
    }
}

