/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.ice;

import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringComparison;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;
import java.util.ArrayList;

public class FingerprintAttribute
extends Attribute {
    private String _fingerprint;
    private String _hashFunction;

    public FingerprintAttribute(String hashFunction, String fingerprint) {
        super.setAttributeType(AttributeType.IceFingerprintAttribute);
        this.setHashFunction(hashFunction);
        if (StringExtensions.indexOf(fingerprint, ":", StringComparison.InvariantCulture) < 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < StringExtensions.getLength(fingerprint); i += 2) {
                list.add(StringExtensions.substring(fingerprint, i, 2));
            }
            fingerprint = StringExtensions.join(":", list.toArray(new String[0]));
        }
        this.setFingerprint(StringExtensions.toUpper(fingerprint));
    }

    private FingerprintAttribute() {
        super.setAttributeType(AttributeType.IceFingerprintAttribute);
    }

    public static FingerprintAttribute fromAttributeValue(String value) {
        int index = StringExtensions.indexOf(value, " ", StringComparison.InvariantCulture);
        String str = StringExtensions.substring(value, 0, index);
        String str2 = value = value.substring(index + 1);
        FingerprintAttribute attribute = new FingerprintAttribute();
        attribute.setHashFunction(str);
        attribute.setFingerprint(str2);
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, this.getHashFunction());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getFingerprint());
        return builder.toString();
    }

    public String getFingerprint() {
        return this._fingerprint;
    }

    public String getHashFunction() {
        return this._hashFunction;
    }

    private void setFingerprint(String value) {
        this._fingerprint = value;
    }

    private void setHashFunction(String value) {
        this._hashFunction = value;
    }
}

