/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.pcmu;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioDecoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.DataBuffer;
import fm.icelink.IAudioSource;
import fm.icelink.pcmu.Codec;
import fm.icelink.pcmu.Format;

public class Decoder
extends AudioDecoder {
    private AudioBuffer decode(AudioBuffer inputBuffer) {
        DataBuffer dataBuffer = inputBuffer.getDataBuffer();
        DataBuffer buffer2 = DataBuffer.allocate(dataBuffer.getLength() * 2, ((AudioFormat)super.getOutputFormat()).getLittleEndian());
        int offset = 0;
        int i = 0;
        while (offset < dataBuffer.getLength()) {
            buffer2.write16(Codec.decompress(dataBuffer.read8(offset)), i);
            ++offset;
            i += 2;
        }
        return new AudioBuffer(buffer2, (AudioFormat)super.getOutputFormat());
    }

    public Decoder(IAudioSource source) {
        this(source.getConfig());
        super.addSource(source);
    }

    public Decoder(AudioConfig config) {
        super(new Format(config), new fm.icelink.pcm.Format(config));
    }

    public Decoder() {
        this(new Format().getConfig());
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        AudioBuffer buffer = this.decode(inputBuffer);
        if (buffer != null) {
            frame.addBuffer(buffer);
            this.raiseFrame(frame);
        }
    }

    @Override
    public String getLabel() {
        return "PCMU (G.711u) Decoder";
    }
}

