/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.HashMapExtensions;
import fm.icelink.IFunction1;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.ParseAssistant;
import java.util.HashMap;

class RtpSendBuffer<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>> {
    private TFrame[] __frameBuffer;
    private HashMap<String, String[]> __indexToSequenceMap;
    private Object __ioLock = new Object();
    private int __maxLength = 1;
    private HashMap<String, String> __sequenceToIndexMap;
    private long _highestFrameIndex = 0L;
    private int _highestSequenceNumber = -1;
    private String _name;

    private int getFrameIndex(String rtpSequenceNumberString) {
        return ParseAssistant.parseIntegerValue(HashMapExtensions.getItem(this.__sequenceToIndexMap).get(rtpSequenceNumberString));
    }

    public int getLength() {
        return this.__maxLength;
    }

    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFrame read(int rtpSequenceNumber) {
        Object object = this.__ioLock;
        synchronized (object) {
            String key = IntegerExtensions.toString(rtpSequenceNumber);
            if (this.__sequenceToIndexMap.containsKey(key)) {
                return this.__frameBuffer[this.getFrameIndex(key)];
            }
            return null;
        }
    }

    public RtpSendBuffer(String name, int size, IFunction1<Integer, TFrame[]> createArrayCallback) {
        this.setName(name);
        this.setLength(size);
        this.__frameBuffer = (MediaFrame[])createArrayCallback.invoke(size);
        this.__sequenceToIndexMap = new HashMap();
        this.__indexToSequenceMap = new HashMap();
    }

    private void setLength(int value) {
        this.__maxLength = MathAssistant.max(this.getLength(), value);
    }

    private void setName(String value) {
        this._name = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(TFrame frame) {
        Object object = this.__ioLock;
        synchronized (object) {
            int index = (int)(((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() % (long)this.getLength());
            TFrame local = this.__frameBuffer[index];
            if (local != null && ((MediaBuffer)((MediaFrame)local).getBuffer()).getSequenceNumber() > ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber()) {
                return false;
            }
            this.__frameBuffer[index] = frame;
            String key = IntegerExtensions.toString(index);
            if (this.__indexToSequenceMap.containsKey(key)) {
                for (String str2 : HashMapExtensions.getItem(this.__indexToSequenceMap).get(key)) {
                    HashMapExtensions.remove(this.__sequenceToIndexMap, str2.toString());
                }
                HashMapExtensions.remove(this.__indexToSequenceMap, key);
            }
            String[] strArray = null;
            for (int i = ArrayExtensions.getLength(frame.getBuffers()) - 1; i >= 0; --i) {
                MediaBuffer local2 = frame.getBuffers()[ArrayExtensions.getLength(frame.getBuffers()) - 1];
                if (!((MediaFormat)local2.getFormat()).getIsPacketized()) continue;
                strArray = new String[ArrayExtensions.getLength(local2.getDataBuffers())];
                for (int j = 0; j < ArrayExtensions.getLength(local2.getRtpSequenceNumbers()); ++j) {
                    HashMapExtensions.add(this.__sequenceToIndexMap, IntegerExtensions.toString(local2.getRtpSequenceNumbers()[j]), IntegerExtensions.toString(index));
                    strArray[j] = IntegerExtensions.toString(local2.getRtpSequenceNumbers()[j]);
                }
                break;
            }
            if (strArray == null) {
                Log.error("Cannot write to SendBuffer. No rtp packets found in frame. Are you missing a packetizer?");
                return false;
            }
            HashMapExtensions.add(this.__indexToSequenceMap, key, strArray);
            this._highestSequenceNumber = ParseAssistant.parseIntegerValue((String)strArray[ArrayExtensions.getLength(strArray) - 1]);
            this._highestFrameIndex = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getLastSequenceNumber();
            return true;
        }
    }
}

