/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class RtcpPacket {
    private DataBuffer _buffer;

    public DataBuffer getBuffer() {
        return this._buffer;
    }

    public int getByte1Last5Bits() {
        return this.getBuffer().read5(0, 3);
    }

    public static int getFixedHeaderLength() {
        return 4;
    }

    public int getLength() {
        return RtcpPacket.getFixedHeaderLength() + this.getPayloadLengthWithPadding();
    }

    public boolean getPadding() {
        return this.getBuffer().read1(0, 2);
    }

    public int getPaddingLength() {
        return this.getPadding() ? this.getBuffer().read8(this.getBuffer().getLength() - 1) : 0;
    }

    public DataBuffer getPayload() {
        return this.getBuffer().subset(this.getPayloadOffset(), this.getPayloadLength());
    }

    public int getPayloadLength() {
        return this.getPayloadLengthWithPadding() - this.getPaddingLength();
    }

    public int getPayloadLengthWithPadding() {
        return this.getBuffer().read16(2) * 4;
    }

    public int getPayloadOffset() {
        return RtcpPacket.getFixedHeaderLength();
    }

    public int getPayloadType() {
        return this.getBuffer().read8(1);
    }

    public int getVersion() {
        return this.getBuffer().read2(0, 0);
    }

    public static RtcpPacket[] parse(DataBuffer buffer) {
        RtcpPacket packet;
        ArrayList<RtcpPacket> list = new ArrayList<RtcpPacket>();
        for (int i = 0; i < buffer.getLength(); i += packet.getLength()) {
            packet = new RtcpPacket(buffer.subset(i));
            if (packet.getLength() > buffer.getLength() - i) {
                Log.error(StringExtensions.concat(new Object[]{"Malformed RTCP packet detected. Length indicates ", packet.getLength(), " but the buffer is only ", buffer.getLength() - i}));
                break;
            }
            packet.getBuffer().resize(packet.getLength());
            list.add(packet);
        }
        return list.toArray(new RtcpPacket[0]);
    }

    public RtcpPacket() {
        this(DataBuffer.allocate(RtcpPacket.getFixedHeaderLength()));
    }

    public RtcpPacket(DataBuffer buffer) {
        this.setBuffer(buffer);
        if (buffer.getLength() < RtcpPacket.getFixedHeaderLength()) {
            throw new RuntimeException(new Exception(StringExtensions.concat("Invalid RTCP databuffer. Length must be at least ", IntegerExtensions.toString(RtcpPacket.getFixedHeaderLength()), " bytes.")));
        }
        this.setVersion(2);
    }

    private void setBuffer(DataBuffer value) {
        this._buffer = value;
    }

    public void setByte1Last5Bits(int value) {
        this.getBuffer().write5(value, 0, 3);
    }

    public void setPadding(boolean value) {
        this.getBuffer().write1(value, 0, 2);
    }

    private void setPaddingLength(int value) {
        this.setPadding(value > 0);
        for (int i = 0; i < value; ++i) {
            this.getBuffer().write8(BitAssistant.castByte(i < value - 1 ? 0 : value), this.getBuffer().getLength() - value + i);
        }
    }

    public void setPayload(DataBuffer value) {
        if (value.getLength() > this.getPayloadLength()) {
            throw new RuntimeException(new Exception("Cannot set RTCP Payload as the value length is longer than the payload length"));
        }
        this.getBuffer().write(value, this.getPayloadOffset());
    }

    public void setPayloadLengthWithPadding(int value) {
        this.getBuffer().write16(value / 4, 2);
    }

    public void setPayloadType(int value) {
        this.getBuffer().write8(value, 1);
    }

    public void setVersion(int value) {
        this.getBuffer().write2(value, 0, 0);
    }

    public static void test() {
        RtcpPacket packet = new RtcpPacket();
        if (packet.getLength() != 4) {
            throw new RuntimeException(new Exception("Empty constructor test failed."));
        }
        DataBuffer buffer = DataBuffer.allocate(12);
        buffer.write2(1, 0, 0);
        buffer.write5(2, 0, 3);
        buffer.write8(202, 1);
        buffer.write16(3, 2);
        buffer.write32(0xFFFFFFFFL, 4);
        packet = new RtcpPacket(buffer);
        if (packet.getVersion() != 2) {
            throw new RuntimeException(new Exception("RTCP Version test failed."));
        }
        if (packet.getPadding()) {
            throw new RuntimeException(new Exception("RTCP Padding test failed."));
        }
        if (packet.getByte1Last5Bits() != 2) {
            throw new RuntimeException(new Exception("RTCP Byte1Last5Bits test failed."));
        }
        if (packet.getPayloadType() != 202) {
            throw new RuntimeException(new Exception("RTCP PayloadType test failed."));
        }
        if (packet.getPayloadLengthWithPadding() != 8) {
            throw new RuntimeException(new Exception("RTCP PayloadLengthWithPadding test failed."));
        }
        packet.setPaddingLength(5);
        if (packet.getPaddingLength() != 5 || !packet.getPadding() || packet.getBuffer().read32(4) != 0xFFFFFF00L) {
            throw new RuntimeException(new Exception("RTCP PaddingLength test failed."));
        }
    }
}

