/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.ArrayExtensions;
import fm.icelink.Base64;
import fm.icelink.BitAssistant;
import fm.icelink.BooleanHolder;
import fm.icelink.ByteCollection;
import fm.icelink.ByteExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Holder;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate0;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IActionDelegate3;
import fm.icelink.IceCandidate;
import fm.icelink.IceCandidateType;
import fm.icelink.IceGatherOptions;
import fm.icelink.IceGatheringState;
import fm.icelink.IceLocalRelayedCandidate;
import fm.icelink.IceSendMessageArgs;
import fm.icelink.IceSendRequestFailureArgs;
import fm.icelink.IceSendRequestSuccessArgs;
import fm.icelink.IceServer;
import fm.icelink.IceSocketManager;
import fm.icelink.IceStreamSendMessageArgs;
import fm.icelink.IceTransactionManager;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.LocalNetwork;
import fm.icelink.Log;
import fm.icelink.ProtocolType;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.StreamSocket;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.stun.AddressFamily;
import fm.icelink.stun.BindingRequest;
import fm.icelink.stun.BindingResponse;
import fm.icelink.stun.ErrorCodeAttribute;
import fm.icelink.stun.MappedAddressAttribute;
import fm.icelink.stun.Message;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.MessageType;
import fm.icelink.stun.NonceAttribute;
import fm.icelink.stun.RealmAttribute;
import fm.icelink.stun.StaleNonceError;
import fm.icelink.stun.TryAlternateStunError;
import fm.icelink.stun.UnauthorizedStunError;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.Utility;
import fm.icelink.stun.XorMappedAddressAttribute;
import fm.icelink.stun.turn.AllocateRequest;
import fm.icelink.stun.turn.AllocateResponse;
import fm.icelink.stun.turn.DataAttribute;
import fm.icelink.stun.turn.DataIndication;
import fm.icelink.stun.turn.EvenPortAttribute;
import fm.icelink.stun.turn.LifetimeAttribute;
import fm.icelink.stun.turn.RequestedAddressFamilyAttribute;
import fm.icelink.stun.turn.RequestedTransportAttribute;
import fm.icelink.stun.turn.XorPeerAddressAttribute;
import fm.icelink.stun.turn.XorRelayedAddressAttribute;

class IceStreamSocketManager
extends IceSocketManager {
    private ByteCollection __receiveBuffer;
    private Scheduler __scheduler;
    private int __streamSendTimeout = -1;
    private IceLocalRelayedCandidate _localRelayedCandidate;
    private byte _requestBitmask = BitAssistant.castByte(192);
    private IceServer _server;
    private StreamSocket _socket;

    @Override
    protected void closeSocket() {
        this.getSocket().close();
    }

    private boolean doProcessServerResponse(Message response, TransportAddress remoteAddress, ScheduledItem item) {
        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
        Error error = IceStreamSocketManager.validateResponse(state, response, remoteAddress);
        boolean flag = response instanceof AllocateResponse;
        String str = "STUN";
        if (flag) {
            str = "TURN";
        }
        if (error == null) {
            if (!remoteAddress.equals(state.getAddress())) {
                Log.debug(StringExtensions.format("{2} server response source {0} does not match targeted endpoint {1}.", remoteAddress, state.getAddress().toString(), str));
                super.removeTransaction(item);
                return false;
            }
            String iPAddress = null;
            int port = 0;
            XorMappedAddressAttribute xorMappedAddress = response.getXorMappedAddress();
            if (xorMappedAddress != null) {
                iPAddress = xorMappedAddress.getIPAddress();
                port = xorMappedAddress.getPort();
            } else {
                MappedAddressAttribute mappedAddress = response.getMappedAddress();
                if (mappedAddress != null) {
                    iPAddress = mappedAddress.getIPAddress();
                    port = mappedAddress.getPort();
                }
            }
            if (flag) {
                try {
                    String nonce;
                    AllocateRequest message = (AllocateRequest)state.getMessage();
                    String relayPassword = state.getRelayPassword();
                    String turnUserName = message.getUsername() == null ? StringExtensions.empty : message.getUsername().getValue();
                    XorRelayedAddressAttribute xorRelayedAddress = response.getXorRelayedAddress();
                    LifetimeAttribute lifetime = response.getLifetime();
                    String turnRealm = message.getRealm() == null ? StringExtensions.empty : message.getRealm().getValue();
                    String string = nonce = message.getNonce() == null ? StringExtensions.empty : message.getNonce().getValue();
                    if (TransportAddress.isAny(xorRelayedAddress.getIPAddress())) {
                        xorRelayedAddress.setIPAddress(remoteAddress.getIPAddress());
                    }
                    String foundation = IceCandidate.generateLocalCandidateFoundation(IceCandidateType.Relayed, xorRelayedAddress.getIPAddress(), remoteAddress, ProtocolType.Udp);
                    IceLocalRelayedCandidate candidate2 = new IceLocalRelayedCandidate(super.getLock(), foundation, ProtocolType.Udp, xorRelayedAddress.getIPAddress(), xorRelayedAddress.getPort(), xorMappedAddress.getIPAddress(), xorMappedAddress.getPort(), lifetime.getLifetime(), turnUserName, relayPassword, nonce, turnRealm, state.getAddress(), this._transactionManager, super.getGatherOptions().getStunRequestTimeout());
                    candidate2.setAdapterSpeed(this.getSocket().getAdapterSpeed());
                    candidate2.setDispatchStunMessage((IAction1<IceSendMessageArgs>)new IActionDelegate1<IceSendMessageArgs>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceStreamSocketManager.sendStunMessage";
                        }

                        @Override
                        public void invoke(IceSendMessageArgs context) {
                            IceStreamSocketManager.this.sendStunMessage(context);
                        }
                    });
                    candidate2.setDispatchApplicationData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceSocketManager.sendApplicationData";
                        }

                        @Override
                        public void invoke(DataBuffer data, IceCandidate remote, TransportAddress turnRelay) {
                            IceStreamSocketManager.this.sendApplicationData(data, remote, turnRelay);
                        }
                    });
                    candidate2.setOnRelayStateChanged((IAction1<IceLocalRelayedCandidate>)new IActionDelegate1<IceLocalRelayedCandidate>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceSocketManager.processRelayedCandidateStateChanged";
                        }

                        @Override
                        public void invoke(IceLocalRelayedCandidate candidate) {
                            IceStreamSocketManager.this.processRelayedCandidateStateChanged(candidate);
                        }
                    });
                    candidate2.setDiscoverProtocol(ProtocolType.Tcp);
                    IceLocalRelayedCandidate localCandidate = candidate2;
                    this.setLocalRelayedCandidate(localCandidate);
                    localCandidate.setBase(localCandidate);
                    super.raiseLocalCandidate(localCandidate);
                    localCandidate.startScheduleRefreshTransactions();
                }
                catch (Exception exception) {
                    Error error3 = new Error(ErrorCode.IceLocalRelayedDatagramCandidateError);
                    error3.setException(exception);
                    Error error2 = error3;
                    Log.debug(StringExtensions.format("Datagram Socket Manager: Could not process Turn server response: {0}", error2.getDescription()));
                }
            }
            super.removeTransaction(item);
        } else {
            String str9 = null;
            String str10 = null;
            if (flag && Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunUnauthorized) && state.getMessage().getNonce() == null && state.getMessage().getRealm() == null) {
                UnauthorizedStunError error4 = (UnauthorizedStunError)error;
                if (error4.getNonce() != null) {
                    str9 = error4.getNonce().getValue();
                }
                if (error4.getRealm() != null) {
                    str10 = error4.getRealm().getValue();
                }
            } else if (Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunStaleNonce)) {
                StaleNonceError error5 = (StaleNonceError)error;
                if (error5.getNonce() != null) {
                    str9 = error5.getNonce().getValue();
                }
                if (error5.getRealm() != null) {
                    str10 = error5.getRealm().getValue();
                }
                String str11 = "";
                if (this.__numberOfRequests < super.getGatherOptions().getTurnAllocateRequestLimit()) {
                    str11 = " Further attempts to establish server allocation will be made with an updated nonce.";
                }
                Log.debug(StringExtensions.format("{3} server {0} reports error {1}.{2}", new Object[]{remoteAddress.toString(), error.getDescription(), str11, str}));
            } else if (Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunTryAlternate)) {
                TryAlternateStunError error6 = (TryAlternateStunError)error;
                state.setAddress(new TransportAddress(error6.getAlternateServer().getIPAddress(), error6.getAlternateServer().getPort()));
                String str11 = "";
                if (this.__numberOfRequests < super.getGatherOptions().getTurnAllocateRequestLimit()) {
                    str11 = flag ? " Attempts to establish server allocation with a new server will be made." : " Attempts to establish server binding with a new server will be made.";
                }
                Log.debug(StringExtensions.format("{3} server sent an instruction to try an alternate server {0}.{2}.", state.getAddress().toString(), str11, str));
            } else {
                String str2 = "";
                if (Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunTurnAllocationMismatch)) {
                    str2 = StringExtensions.format("TURN allocate request to {0} from {1}: allocation mismatch detected.", remoteAddress.toString(), this.getSocket().getLocalIPAddress());
                    IAction1<IceSocketManager> onAllocationMismatchException = super.getOnAllocationMismatchException();
                    if (onAllocationMismatchException != null) {
                        onAllocationMismatchException.invoke(this);
                    }
                } else {
                    str2 = StringExtensions.format("{2} server {0} reports error {1}.", remoteAddress.toString(), error.getDescription(), str);
                }
                Log.debug(str2);
                super.removeTransaction(item);
                super.setError(error);
                super.setState(IceGatheringState.Failed);
                return false;
            }
            if (this.__numberOfRequests < super.getGatherOptions().getTurnAllocateRequestLimit()) {
                if (!StringExtensions.isNullOrEmpty(str9)) {
                    state.getMessage().setNonce(new NonceAttribute(str9));
                }
                if (!StringExtensions.isNullOrEmpty(str10)) {
                    state.getMessage().setRealm(new RealmAttribute(str10));
                }
                if (flag) {
                    this.serverAllocate(state.getMessage().getUsername().getValue(), state.getRelayPassword(), state.getAddress().getIPAddress(), state.getAddress().getPort(), str9, str10);
                }
                super.removeTransaction(item);
            } else {
                super.setError(error);
                super.setState(IceGatheringState.Failed);
            }
        }
        return true;
    }

    private void doReceive() {
        StreamSocket socket = this.getSocket();
        if (socket != null && socket.getIsClosed()) {
            this.raiseClose();
        } else {
            this.receive();
        }
    }

    private Scheduler get_Scheduler() {
        return this.__scheduler;
    }

    @Override
    long getAdapterSpeed() {
        if (this.getSocket() != null) {
            return this.getSocket().getAdapterSpeed();
        }
        return 0L;
    }

    @Override
    String getLocalIpAddress() {
        if (this.getSocket() != null) {
            return this.getSocket().getLocalIPAddress();
        }
        return StringExtensions.empty;
    }

    @Override
    int getLocalPort() {
        if (this.getSocket() != null) {
            return this.getSocket().getLocalPort();
        }
        return 0;
    }

    public IceLocalRelayedCandidate getLocalRelayedCandidate() {
        return this._localRelayedCandidate;
    }

    public IceServer getServer() {
        return this._server;
    }

    public StreamSocket getSocket() {
        return this._socket;
    }

    int getStreamSendTimeout() {
        return this.__streamSendTimeout;
    }

    public IceStreamSocketManager(Object lockObject, StreamSocket socket, IceTransactionManager manager, IceServer server, Scheduler scheduler) {
        super(lockObject, manager);
        this.__receiveBuffer = new ByteCollection();
        super.setProtocol(ProtocolType.Tcp);
        if (socket == null) {
            throw new RuntimeException(new Exception("Socket cannot be null."));
        }
        this.setSocket(socket);
        this.getSocket().setOnReceiveSuccess((IAction1<byte[]>)new IActionDelegate1<byte[]>(){

            @Override
            public String getId() {
                return "fm.icelink.IceStreamSocketManager.processReceiveSuccess";
            }

            @Override
            public void invoke(byte[] buffer) {
                IceStreamSocketManager.this.processReceiveSuccess(buffer);
            }
        });
        this.getSocket().setOnReceiveFailure((IAction2<Exception, Boolean>)new IActionDelegate2<Exception, Boolean>(){

            @Override
            public String getId() {
                return "fm.icelink.IceStreamSocketManager.processReceiveFailure";
            }

            @Override
            public void invoke(Exception exception, Boolean timedOut) {
                IceStreamSocketManager.this.processReceiveFailure(exception, timedOut);
            }
        });
        this.setServer(server);
        this.set_Scheduler(scheduler);
    }

    private void onTurnServerConnectedFailure(Exception ex, boolean timedout) {
        String str = timedout ? "timedout" : "failed";
        int port = this.getServer().getPort();
        super.setError(new Error(ErrorCode.IceLocalRelayedStreamCandidateError, new Exception(StringExtensions.format("Tcp Turn Server connect request from {4}:{5} {1}.{0} Is a TCP socket listening on port {3} on server {2}? Is the Turn server reachable from this interface?", new Object[]{ex == null ? "" : StringExtensions.concat(" ", ex.getMessage()), str, this.getServer().getUrl(), IntegerExtensions.toString(port), this.getLocalIpAddress(), IntegerExtensions.toString(this.getLocalPort())}))));
        Log.error(super.getError().getDescription());
        super.setState(IceGatheringState.Failed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTurnServerConnectedSuccess() {
        Object object = super.getLock();
        synchronized (object) {
            if (!Global.equals((Object)super.getState(), (Object)IceGatheringState.Failed)) {
                this.doReceive();
                this.serverAllocate(this.getServer().getUsername(), this.getServer().getPassword(), this.getServer().getIPAddress(), this.getServer().getPort(), null, null);
            }
        }
    }

    private Message postProcess(byte[] data, TransportAddress address, Holder<byte[]> newData, Holder<TransportAddress> newAddress, BooleanHolder relayed, IntegerHolder readLength) {
        Message message = null;
        readLength.setValue(0);
        try {
            Message _var0;
            message = _var0 = Message.parseBytes(data, readLength);
            if (message instanceof DataIndication) {
                DataAttribute attribute = message.getData();
                XorPeerAddressAttribute xorPeerAddress = message.getXorPeerAddress();
                newData.setValue(attribute.getData());
                newAddress.setValue(new TransportAddress(xorPeerAddress.getIPAddress(), xorPeerAddress.getPort()));
                relayed.setValue(true);
                return Message.parseBytes(newData.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        newData.setValue(data);
        newAddress.setValue(address);
        relayed.setValue(false);
        return message;
    }

    private boolean process(byte[] data, IntegerHolder readLength) {
        IAction3<Message, IceCandidate, TransportAddress> onStunRequest;
        boolean flag2;
        readLength.setValue(0);
        boolean relayed = false;
        StreamSocket socket = this.getSocket();
        TransportAddress address = null;
        Message message = null;
        byte[] newData = null;
        if (socket == null || socket.getIsClosed()) {
            return false;
        }
        address = new TransportAddress(socket.getRemoteIPAddress(), socket.getRemotePort());
        Holder<Object> _var0 = new Holder<Object>(newData);
        Holder<TransportAddress> _var1 = new Holder<TransportAddress>(address);
        BooleanHolder _var2 = new BooleanHolder(relayed);
        Message _var3 = this.postProcess(data, address, _var0, _var1, _var2, readLength);
        newData = _var0.getValue();
        address = _var1.getValue();
        relayed = _var2.getValue();
        message = _var3;
        String key = message == null ? null : Base64.encode(message.getTransactionId());
        IceSendRequestSuccessArgs successArgs = new IceSendRequestSuccessArgs();
        successArgs.setRemoteAddress(address);
        successArgs.setResponse(message);
        successArgs.setRelayed(relayed);
        boolean bl = flag2 = key != null && this._transactionManager.tryTriggerOnResponse(key, successArgs);
        if (!flag2 && message != null && message instanceof BindingRequest && (onStunRequest = super.getOnStunRequest()) != null) {
            onStunRequest.invoke(message, this.getLocalRelayedCandidate(), address);
        }
        if (message != null) {
            return true;
        }
        if (newData != data) {
            super.getOnIncomingData().invoke(DataBuffer.wrap(newData), this.getLocalRelayedCandidate(), address);
            return true;
        }
        return false;
    }

    boolean processBuffer(byte[] buffer, IntegerHolder readLength) {
        readLength.setValue(0);
        if (ArrayExtensions.getLength(buffer) > 0) {
            int num = buffer[0] & this._requestBitmask;
            boolean flag = num == 0;
            boolean flag2 = num == 64;
            boolean flag3 = false;
            if (flag) {
                boolean _var0 = this.process(buffer, readLength);
                return flag3 | _var0;
            }
            if (!flag2 || ArrayExtensions.getLength(buffer) >= 4) {
                // empty if block
            }
            return flag3;
        }
        return false;
    }

    private void processBuffer(byte[] buffer) {
        this.__receiveBuffer.addRange(buffer);
        this.processTcpReceive(this.__receiveBuffer);
        if (this.getSocket().getIsClosed()) {
            this.raiseClose();
        }
    }

    void processReceiveFailure(Exception exception, boolean timedOut) {
        if (!Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed) && !Global.equals((Object)super.getState(), (Object)IceGatheringState.Failed)) {
            this.doReceive();
        }
    }

    void processReceiveSuccess(byte[] buffer) {
        try {
            this.processBuffer(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed) && !Global.equals((Object)super.getState(), (Object)IceGatheringState.Failed)) {
            this.doReceive();
        }
    }

    private void processServerResponse(IceSendRequestSuccessArgs e) {
        Message response = e.getResponse();
        TransportAddress remoteAddress = e.getRemoteAddress();
        ScheduledItem item = e.getItem();
        try {
            if (response instanceof BindingResponse || response instanceof AllocateResponse) {
                this.doProcessServerResponse(response, remoteAddress, item);
            } else {
                Log.error("Currently unsupported TCP response received from server.");
            }
        }
        catch (Exception exception) {
            Log.error(exception.toString());
        }
    }

    private void processTcpReceive(ByteCollection receiveBuffer) {
        do {
            int readLength = 0;
            IntegerHolder _var0 = new IntegerHolder(readLength);
            boolean _var1 = this.processBuffer(receiveBuffer.toArray(), _var0);
            readLength = _var0.getValue();
            if (!_var1) {
                return;
            }
            receiveBuffer.removeRange(0, readLength);
        } while (receiveBuffer.getCount() != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseClose() {
        Object object = super.getLock();
        synchronized (object) {
            if (!Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed)) {
                super.setError(new Error(ErrorCode.SocketClosed));
                super.setState(IceGatheringState.Failed);
            }
        }
    }

    private void receive() {
        try {
            this.getSocket().receiveAsync(0);
        }
        catch (Exception exception) {
            if (Log.getIsDebugEnabled()) {
                Log.debug(StringExtensions.format("Could not receive on server TCP socket. {0}", exception.getMessage()));
            }
            this.getSocket().close();
            this.raiseClose();
        }
    }

    private void sendAllocateFailure(IceSendMessageArgs e, Exception exception, boolean timedOut) {
        if (!Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed)) {
            super.setError(exception.getMessage().equals("Socket closed") ? new Error(ErrorCode.SocketClosed, new Exception("Could not send allocate request over TCP connection: socket closed.")) : (timedOut ? new Error(ErrorCode.SocketSendError, new Exception("Could not send allocate request over TCP connection: request timedout.")) : new Error(ErrorCode.SocketSendError, exception)));
            IAction1<IceSendRequestFailureArgs> onFailure = e.getOnFailure();
            IceSendRequestFailureArgs args2 = new IceSendRequestFailureArgs();
            args2.setCandidatePair(e.getCandidatePair());
            args2.setError(super.getError());
            args2.setAddress(e.getAddress());
            args2.setTurnRelay(e.getTurnRelay());
            IceSendRequestFailureArgs p = args2;
            if (onFailure != null) {
                onFailure.invoke(p);
            } else {
                Log.error(StringExtensions.format("Unable to send request: {0}", p.getError().getDescription()));
            }
            super.setState(IceGatheringState.Failed);
        }
    }

    private void sendAllocateMessage(ScheduledItem item) {
        IceStreamSendMessageArgs state = (IceStreamSendMessageArgs)item.getState();
        this.sendStunMessage(state, false, new IActionDelegate0(){

            @Override
            public String getId() {
                return "fm.icelink.IceStreamSocketManager.sendAllocateSuccess";
            }

            @Override
            public void invoke() {
                IceStreamSocketManager.this.sendAllocateSuccess();
            }
        }, (IAction3<IceSendMessageArgs, Exception, Boolean>)new IActionDelegate3<IceSendMessageArgs, Exception, Boolean>(){

            @Override
            public String getId() {
                return "fm.icelink.IceStreamSocketManager.sendAllocateFailure";
            }

            @Override
            public void invoke(IceSendMessageArgs e, Exception exception, Boolean timedOut) {
                IceStreamSocketManager.this.sendAllocateFailure(e, exception, timedOut);
            }
        });
    }

    private void sendAllocateSuccess() {
    }

    private void sendAllocateTimedout(ScheduledItem item) {
        IceStreamSendMessageArgs state = (IceStreamSendMessageArgs)item.getState();
        Log.error(StringExtensions.format("Allocate request to {0}:{1} timed out.", state.getAddress().getIPAddress(), IntegerExtensions.toString(state.getAddress().getPort())));
        Log.error(StringExtensions.format("ID: {0}", item.getId()));
        super.removeTransaction(item);
        this.onTurnServerConnectedFailure(null, true);
    }

    @Override
    protected void sendApplicationData(DataBuffer data, IceCandidate remote, TransportAddress turnRelay) {
        if (!(Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed) || Global.equals((Object)super.getState(), (Object)IceGatheringState.Closing) || Global.equals((Object)super.getState(), (Object)IceGatheringState.Failed) || Global.equals((Object)super.getState(), (Object)IceGatheringState.New) || remote == null || data == null)) {
            StreamSocket socket = this.getSocket();
            if (socket == null) {
                Error error = new Error(ErrorCode.SocketClosed);
                error.setException(new Exception("Could not send application data: socket is closed."));
                super.setError(error);
                super.setState(IceGatheringState.Failed);
            } else {
                try {
                    byte[] buffer = data.toArray();
                    TransportAddress transportAddress = remote.getTransportAddress();
                    Holder<byte[]> _var0 = new Holder<byte[]>(buffer);
                    Holder<TransportAddress> _var1 = new Holder<TransportAddress>(transportAddress);
                    super.turnPreProcess(buffer, transportAddress, turnRelay, _var0, _var1);
                    buffer = _var0.getValue();
                    transportAddress = _var1.getValue();
                    if (!socket.getIsClosed()) {
                        socket.sendAsync(buffer, this.getStreamSendTimeout(), null, null);
                    } else {
                        Error error2 = new Error(ErrorCode.SocketClosed);
                        error2.setException(new Exception("Could not send application data: socket is not open."));
                        super.setError(error2);
                        super.setState(IceGatheringState.Failed);
                    }
                }
                catch (Exception exception) {
                    if (Log.getIsDebugEnabled()) {
                        Log.debug("Could not send on socket.", exception);
                    }
                    Error error3 = new Error(ErrorCode.SocketSendError);
                    error3.setException(exception);
                    super.setError(error3);
                    super.setState(IceGatheringState.Failed);
                }
            }
        }
    }

    private void sendStunMessage(IceStreamSendMessageArgs context, boolean preprocessForRelay, IAction0 onSuccess, IAction3<IceSendMessageArgs, Exception, Boolean> onFailure) {
        this.tryDispatchStunMessage(context, preprocessForRelay, onSuccess, onFailure);
    }

    private void sendStunMessage(IceSendMessageArgs context) {
        IceStreamSendMessageArgs args = new IceStreamSendMessageArgs(context);
        this.sendStunMessage(args, true, null, null);
    }

    private void serverAllocate(String username, String password, String ipAddress, int port, String nonce, String realm) {
        ++this.__numberOfRequests;
        AllocateRequest request = new AllocateRequest();
        request.setRequestedTransport(new RequestedTransportAttribute(RequestedTransportAttribute.getUdpProtocol()));
        request.setEvenPort(new EvenPortAttribute(false));
        request.setUsername(new UsernameAttribute(username));
        boolean flag = false;
        if (!StringExtensions.isNullOrEmpty(realm)) {
            flag = true;
            request.setRealm(new RealmAttribute(realm));
        }
        boolean flag2 = false;
        if (!StringExtensions.isNullOrEmpty(nonce)) {
            flag2 = true;
            request.setNonce(new NonceAttribute(nonce));
        }
        if (flag && flag2) {
            request.setMessageIntegrity(new MessageIntegrityAttribute(Utility.createLongTermKey(username, realm, password)));
        }
        if (Global.equals((Object)LocalNetwork.getAddressType(ipAddress), (Object)AddressType.IPv6)) {
            request.setRequestedAddressFamily(new RequestedAddressFamilyAttribute(AddressFamily.getIPv6()));
        }
        TransportAddress address = new TransportAddress(ipAddress, port);
        IceStreamSendMessageArgs args2 = new IceStreamSendMessageArgs(request, address);
        args2.setRelayPassword(password);
        args2.setRaiseServerReflexiveCandidates(false);
        args2.setOnResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.IceStreamSocketManager.processServerResponse";
            }

            @Override
            public void invoke(IceSendRequestSuccessArgs e) {
                IceStreamSocketManager.this.processServerResponse(e);
            }
        });
        IceStreamSendMessageArgs args = args2;
        ScheduledItem item2 = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceStreamSocketManager.sendAllocateMessage";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceStreamSocketManager.this.sendAllocateMessage(item);
            }
        }, 0, super.getGatherOptions().getStunRequestTimeout() * 2, super.getGatherOptions().getStunRequestTimeout(), ScheduledItem.getUnset());
        item2.setState(args);
        item2.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.IceStreamSocketManager.sendAllocateTimedout";
            }

            @Override
            public void invoke(ScheduledItem item) {
                IceStreamSocketManager.this.sendAllocateTimedout(item);
            }
        });
        ScheduledItem item = item2;
        this._transactionManager.addTransaction(item, this);
    }

    private void set_Scheduler(Scheduler value) {
        this.__scheduler = value;
    }

    private void setLocalRelayedCandidate(IceLocalRelayedCandidate value) {
        this._localRelayedCandidate = value;
    }

    private void setServer(IceServer value) {
        this._server = value;
    }

    private void setSocket(StreamSocket value) {
        this._socket = value;
    }

    void setStreamSendTimeout(int value) {
        if (value >= -1) {
            this.__streamSendTimeout = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(IceGatherOptions options) {
        Object object = super.getLock();
        synchronized (object) {
            if (Global.equals((Object)super.getState(), (Object)IceGatheringState.Gathering) || Global.equals((Object)super.getState(), (Object)IceGatheringState.Complete)) {
                throw new RuntimeException(new Exception(StringExtensions.format("Could not start Stream Socket Manager: it is in {0} state.", super.getState().toString())));
            }
            try {
                String str2;
                super.setGatherOptions(options);
                String ipAddress = this.getSocket() == null ? null : this.getSocket().getLocalIPAddress();
                String string = str2 = this.getServer() == null ? null : this.getServer().getIPAddress();
                if (ipAddress == null || str2 == null || !Global.equals((Object)LocalNetwork.getAddressType(ipAddress), (Object)LocalNetwork.getAddressType(str2))) {
                    if (this.getSocket() != null && !this.getSocket().getIsClosed()) {
                        this.getSocket().close();
                    }
                    String message = ipAddress == null ? "Local socket ip address not set" : (str2 == null ? "Server socket ip address not set." : StringExtensions.format("Local socket ip {0} version does not match remote server ip {1} version.", ipAddress, str2));
                    super.setError(new Error(ErrorCode.SocketIPError, new Exception(message)));
                    super.setState(IceGatheringState.Failed);
                    return false;
                }
                if (Global.equals((Object)super.getState(), (Object)IceGatheringState.New) || Global.equals((Object)super.getState(), (Object)IceGatheringState.Complete)) {
                    super.setState(IceGatheringState.Gathering);
                } else if (Global.equals((Object)super.getState(), (Object)IceGatheringState.Closed)) {
                    Log.error("Stream socket manager in closed state when attempting to gather local candidates");
                    return false;
                }
                if (this.getServer().getIsTurn() && this.getServer().getIPAddress() != null) {
                    this.getSocket().connectAsync(str2, this.getServer().getPort(), options.getTcpConnectTimeout(), new IActionDelegate0(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceStreamSocketManager.onTurnServerConnectedSuccess";
                        }

                        @Override
                        public void invoke() {
                            IceStreamSocketManager.this.onTurnServerConnectedSuccess();
                        }
                    }, (IAction2<Exception, Boolean>)new IActionDelegate2<Exception, Boolean>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceStreamSocketManager.onTurnServerConnectedFailure";
                        }

                        @Override
                        public void invoke(Exception ex, Boolean timedout) {
                            IceStreamSocketManager.this.onTurnServerConnectedFailure(ex, timedout);
                        }
                    });
                } else {
                    Error error = new Error(ErrorCode.IceInvalidServerAssignmentError);
                    error.setException(new Exception("Invalid trun server assigned or server not resolved."));
                    super.setError(error);
                    Log.error(StringExtensions.format("Could not allocate on Turn server: {0}", super.getError().getDescription()));
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return true;
    }

    private void tryDispatchStunMessage(final IceSendMessageArgs e, boolean preprocessForRelay, IAction0 onSuccess, final IAction3<IceSendMessageArgs, Exception, Boolean> onFailure) {
        IAction2<Exception, Boolean> action = null;
        try {
            if (this.getSocket().getIsClosed()) {
                onFailure.invoke(e, new Exception("Socket closed"), false);
            }
            byte[] bytes = e.getMessage().getBytes();
            TransportAddress address = e.getAddress();
            if (preprocessForRelay) {
                Holder<byte[]> _var0 = new Holder<byte[]>(bytes);
                Holder<TransportAddress> _var1 = new Holder<TransportAddress>(address);
                super.turnPreProcess(bytes, address, e.getTurnRelay(), _var0, _var1);
                bytes = _var0.getValue();
                address = _var1.getValue();
            }
            if (!this.getSocket().getIsClosed()) {
                if (onFailure != null) {
                    if (action == null) {
                        action = new IAction2<Exception, Boolean>(){

                            @Override
                            public void invoke(Exception ex, Boolean b) {
                                onFailure.invoke(e, ex, b);
                            }
                        };
                    }
                    this.getSocket().sendAsync(bytes, this.getStreamSendTimeout(), onSuccess, action);
                } else {
                    this.getSocket().sendAsync(bytes, this.getStreamSendTimeout(), onSuccess, null);
                }
            }
        }
        catch (Exception exception) {
            onFailure.invoke(e, exception, false);
        }
    }

    static Error validateResponse(IceSendMessageArgs sendRequestArgs, Message response, TransportAddress remoteAddress) {
        if (sendRequestArgs.getMessage() instanceof BindingRequest && !(response instanceof BindingResponse)) {
            return new Error(ErrorCode.StunInvalidResponseType, new Exception("Client generated a Stun Binding Request but receieved a message of the type other than Binding Response."));
        }
        for (int i = 0; i < ArrayExtensions.getLength(sendRequestArgs.getMessage().getTransactionId()); ++i) {
            if (sendRequestArgs.getMessage().getTransactionId()[i] == response.getTransactionId()[i]) continue;
            return new Error(ErrorCode.StunInvalidTransactionId, new Exception(StringExtensions.format("Response transaction ID {0} does not match request transaction ID {1}.", ByteExtensions.toString(response.getTransactionId()[i]), ByteExtensions.toString(sendRequestArgs.getMessage().getTransactionId()[i]))));
        }
        if (Global.equals((Object)response.getMessageType(), (Object)MessageType.ErrorResponse)) {
            ErrorCodeAttribute errorCode = response.getErrorCode();
            if (errorCode == null) {
                return new Error(ErrorCode.StunInvalidErrorCode, new Exception("Error response received, but no error code was supplied."));
            }
            Error error = fm.icelink.stun.Error.createStunError(errorCode.getCode(), response);
            if (error != null) {
                return error;
            }
            return new Error(ErrorCode.StunUnknownStunErrorCode, new Exception(StringExtensions.format("Server responded with an unknown error code ({0}).", IntegerExtensions.toString(errorCode.getCode()))));
        }
        return null;
    }
}

