/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Holder;
import fm.icelink.IntegerHolder;
import fm.icelink.ParseAssistant;
import fm.icelink.StringComparison;
import fm.icelink.StringExtensions;

public class IceServer {
    private String _ipAddress;
    private String _password;
    private String _url;
    private String _username;

    public static int getDefaultPort() {
        return 3478;
    }

    public String getHost() {
        String host = null;
        int port = 0;
        Holder<Object> _var0 = new Holder<Object>(host);
        IntegerHolder _var1 = new IntegerHolder(port);
        boolean _var2 = IceServer.parseAddress(this.getUrl(), _var0, _var1);
        host = _var0.getValue();
        port = _var1.getValue();
        return host;
    }

    String getIPAddress() {
        return this._ipAddress;
    }

    public boolean getIsStun() {
        return this.getUrl().startsWith("stun:") || this.getUrl().startsWith("stuns:");
    }

    public boolean getIsTcp() {
        return !this.getUrl().endsWith("?transport=udp");
    }

    public boolean getIsTurn() {
        return this.getUrl().startsWith("turn:") || this.getUrl().startsWith("turns:");
    }

    public boolean getIsUdp() {
        return !this.getUrl().endsWith("?transport=tcp");
    }

    public String getPassword() {
        return this._password;
    }

    public int getPort() {
        String host = null;
        int port = 0;
        Holder<Object> _var0 = new Holder<Object>(host);
        IntegerHolder _var1 = new IntegerHolder(port);
        boolean _var2 = IceServer.parseAddress(this.getUrl(), _var0, _var1);
        host = _var0.getValue();
        port = _var1.getValue();
        return port;
    }

    public String getUrl() {
        return this._url;
    }

    public String getUsername() {
        return this._username;
    }

    public IceServer(String url) {
        if (url == null) {
            throw new RuntimeException(new Exception("Url cannot be null."));
        }
        if (url.startsWith("turn:") || url.startsWith("turns:")) {
            throw new RuntimeException(new Exception("TURN servers require a username and password."));
        }
        if (!url.startsWith("stun:") && !url.startsWith("stuns:")) {
            url = StringExtensions.format("stun:{0}", url);
        }
        if (!url.contains("?transport=")) {
            url = StringExtensions.format("{0}?transport=udp", url);
        }
        this.setUrl(url);
    }

    public IceServer(String url, String username, String password) {
        if (url == null) {
            throw new RuntimeException(new Exception("Url cannot be null."));
        }
        if (username == null) {
            throw new RuntimeException(new Exception("Username cannot be null."));
        }
        if (password == null) {
            throw new RuntimeException(new Exception("Password cannot be null."));
        }
        if (url.startsWith("stun:") || url.startsWith("stuns:")) {
            throw new RuntimeException(new Exception("STUN servers do not have a username or password."));
        }
        if (!url.startsWith("turn:") && !url.startsWith("turns:")) {
            url = StringExtensions.format("turn:{0}", url);
        }
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }

    private static boolean parseAddress(String address, Holder<String> host, IntegerHolder port) {
        Object[] strArray;
        host.setValue(null);
        port.setValue(3478);
        if (address == null) {
            return false;
        }
        if ((address = StringExtensions.split(address, new char[]{'?'})[0]).startsWith("stun:") || address.startsWith("stuns:") || address.startsWith("turn:") || address.startsWith("turns:")) {
            address = address.substring(StringExtensions.indexOf(address, ":", StringComparison.InvariantCulture) + 1);
        }
        if (address.startsWith("[")) {
            address = StringExtensions.substring(address, 1, StringExtensions.getLength(address) - 1);
            strArray = StringExtensions.split(address, new char[]{']'});
        } else {
            strArray = StringExtensions.split(address, new char[]{':'});
        }
        if (ArrayExtensions.getLength(strArray) > 0) {
            host.setValue((String)strArray[0]);
        }
        if (ArrayExtensions.getLength(strArray) > 1) {
            port.setValue(IceServer.parsePort((String)strArray[1]));
        }
        return true;
    }

    private static int parsePort(String portString) {
        int intResult = 0;
        IntegerHolder _var0 = new IntegerHolder(intResult);
        boolean _var1 = ParseAssistant.tryParseIntegerValue(portString, _var0);
        intResult = _var0.getValue();
        if (_var1) {
            return intResult;
        }
        return 3478;
    }

    void setIPAddress(String value) {
        this._ipAddress = value;
    }

    private void setPassword(String value) {
        this._password = value;
    }

    private void setUrl(String value) {
        this._url = value;
    }

    private void setUsername(String value) {
        this._username = value;
    }
}

