/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.IFormatProvider;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateExtensions {
    private static long origin;

    public static Date createDate(long ticks) {
        return new Date(ticks / 10000L + origin);
    }

    public static Date createDate(int year, int month, int date, int hour, int minute, int second) {
        return new Date(year - 1900, month - 1, date, hour, minute, second);
    }

    public static Date getNow() {
        return new Date();
    }

    public static Date getUtcNow() {
        return new Date();
    }

    public static long getTicks(Date date) {
        long milliseconds = date.getTime() - origin;
        return (long)((double)milliseconds * 10000.0);
    }

    public static Date toUniversalTime(Date date) {
        return new Date(date.getTime());
    }

    public static String toString(Date date, String format, IFormatProvider provider) {
        format = format.replace("T", "'T'").replace("f", "S");
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date).substring(0, 22).replace("'T'", "T");
    }

    public static int getYear(Date date) {
        return date.getYear();
    }

    public static int getMonth(Date date) {
        return date.getMonth() + 1;
    }

    public static int getDay(Date date) {
        return date.getDate();
    }

    public static int getHour(Date date) {
        return date.getHours();
    }

    public static int getMinute(Date date) {
        return date.getMinutes();
    }

    public static int getSecond(Date date) {
        return date.getSeconds();
    }

    public static Date addSeconds(Date date, double seconds) {
        return new Date(date.getTime() + (long)(seconds * 1000.0));
    }

    public static Date addMilliseconds(Date date, double milliseconds) {
        return new Date(date.getTime() + (long)(milliseconds * 1.0));
    }

    static {
        try {
            origin = -62135596800000L;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

