/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPooled;
import fm.icelink.HashMapExtensions;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.PoolStatistics;
import fm.icelink.StackExtensions;
import fm.icelink.StringExtensions;
import java.util.HashMap;
import java.util.Stack;

public class DataBufferPool {
    private HashMap<String, Stack<byte[]>> __pools = new HashMap();
    private static DataBufferPool __singleton = new DataBufferPool();
    private boolean _enableStatistics;
    private PoolStatistics _statistics;

    private DataBufferPooled allocateDataBuffer(int requestedSize, int paddedSize, boolean littleEndian) {
        DataBufferPooled pooled = new DataBufferPooled(this, new byte[paddedSize], requestedSize, littleEndian);
        if (this.getEnableStatistics()) {
            this.getStatistics().__totalPoolSize.add(paddedSize);
        }
        return pooled;
    }

    public DataBufferPool() {
        this.setEnableStatistics(true);
        this.setStatistics(new PoolStatistics());
    }

    public boolean getEnableStatistics() {
        return this._enableStatistics;
    }

    public static DataBufferPool getInstance() {
        return __singleton;
    }

    public PoolStatistics getStatistics() {
        return this._statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerReturn(byte[] buffer) {
        String key = IntegerExtensions.toString(ArrayExtensions.getLength(buffer));
        if (this.__pools.containsKey(key)) {
            Stack<byte[]> stack;
            Stack<byte[]> stack2 = stack = HashMapExtensions.getItem(this.__pools).get(key);
            synchronized (stack2) {
                stack.push(buffer);
            }
            if (this.getEnableStatistics()) {
                this.getStatistics().__pendingPoolSize.add(ArrayExtensions.getLength(buffer));
            }
        } else {
            HashMap<String, Stack<byte[]>> hashMap = this.__pools;
            synchronized (hashMap) {
                if (!this.__pools.containsKey(key)) {
                    if (this.getEnableStatistics()) {
                        this.getStatistics().__creates.increment();
                    }
                    Log.debug(StringExtensions.format("Creating a new DataBuffer pool ({0}).", key));
                    HashMapExtensions.add(this.__pools, key, new Stack());
                    this.getStatistics().__activePools = HashMapExtensions.getCount(this.__pools);
                }
            }
            this.innerReturn(buffer);
        }
    }

    private static int padToBlock(int size) {
        int num = size + 128 - 1;
        return num - (num & 0x7F);
    }

    void returnBuffer(DataBufferPooled buffer) {
        if (buffer.getIsPooled()) {
            int num = buffer.decrementRetain();
            if (num == 0) {
                this.innerReturn(buffer.invalidate());
            } else if (num < 0) {
                Log.warn("Buffer with negative retain count returned to pool.");
            }
        } else {
            Log.warn("Unpooled DataBuffer returned to pool.");
        }
    }

    public void setEnableStatistics(boolean value) {
        this._enableStatistics = value;
    }

    private void setStatistics(PoolStatistics value) {
        this._statistics = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer takeBuffer(int size, boolean littleEndian) {
        DataBufferPooled pooled;
        int paddedSize = DataBufferPool.padToBlock(size);
        String key = IntegerExtensions.toString(paddedSize);
        if (this.__pools.containsKey(key)) {
            Stack<byte[]> stack;
            Stack<byte[]> stack2 = stack = HashMapExtensions.getItem(this.__pools).get(key);
            synchronized (stack2) {
                if (StackExtensions.getCount(stack) > 0) {
                    pooled = new DataBufferPooled(this, stack.pop(), size, littleEndian);
                    if (this.getEnableStatistics()) {
                        this.getStatistics().__hits.increment();
                        this.getStatistics().__pendingPoolSize.subtract(ArrayExtensions.getLength(pooled.getData()));
                    }
                } else {
                    if (this.getEnableStatistics()) {
                        this.getStatistics().__misses.increment();
                    }
                    pooled = this.allocateDataBuffer(size, paddedSize, littleEndian);
                }
            }
        } else {
            if (this.getEnableStatistics()) {
                this.getStatistics().__misses.increment();
            }
            pooled = this.allocateDataBuffer(size, paddedSize, littleEndian);
        }
        if (this.getEnableStatistics()) {
            this.getStatistics().__paddingWasted.add(paddedSize - size);
        }
        pooled.keep();
        return pooled;
    }

    public DataBuffer takeBuffer(int size) {
        return this.takeBuffer(size, false);
    }
}

