/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.Encoding;
import fm.icelink.Log;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    public static byte[] secureRandom(int length) {
        SecureRandom sr = new SecureRandom();
        byte[] random = new byte[length];
        sr.nextBytes(random);
        return random;
    }

    public static Integer encryptAes128Cbc(byte[] key, byte[] iv, byte[] input, int inputOffset, byte[] output, int outputOffset, int length) throws Exception {
        return Crypto.encryptAesCbc(128, key, iv, input, inputOffset, output, outputOffset, length);
    }

    public static Integer encryptAes256Cbc(byte[] key, byte[] iv, byte[] input, int inputOffset, byte[] output, int outputOffset, int length) throws Exception {
        return Crypto.encryptAesCbc(256, key, iv, input, inputOffset, output, outputOffset, length);
    }

    private static Integer encryptAesCbc(int keySize, byte[] key, byte[] iv, byte[] input, int inputOffset, byte[] output, int outputOffset, int length) throws Exception {
        if (keySize != 128 && keySize != 192 && keySize != 256) {
            throw new Exception("Invalid key size.");
        }
        if (length % 16 != 0) {
            throw new Exception("Data length must be a multiple of 16.");
        }
        try {
            SecretKeySpec sk = new SecretKeySpec(key, "AES");
            IvParameterSpec ips = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(1, (Key)sk, ips);
            return cipher.doFinal(input, inputOffset, length, output, outputOffset);
        }
        catch (Exception ex) {
            Log.error("Could not encrypt data with AES.", ex);
            return 0;
        }
    }

    public static int decryptAes128Cbc(byte[] key, byte[] iv, byte[] input, int inputOffset, byte[] output, int outputOffset, int length) throws Exception {
        return Crypto.decryptAesCbc(128, key, iv, input, inputOffset, output, outputOffset, length);
    }

    public static int decryptAes256Cbc(byte[] key, byte[] iv, byte[] input, int inputOffset, byte[] output, int outputOffset, int length) throws Exception {
        return Crypto.decryptAesCbc(256, key, iv, input, inputOffset, output, outputOffset, length);
    }

    private static int decryptAesCbc(int keySize, byte[] key, byte[] iv, byte[] input, int inputOffset, byte[] output, int outputOffset, int length) throws Exception {
        if (keySize != 128 && keySize != 192 && keySize != 256) {
            throw new Exception("Invalid key size.");
        }
        if (length % 16 != 0) {
            throw new Exception("Data length must be a multiple of 16.");
        }
        try {
            SecretKeySpec sk = new SecretKeySpec(key, "AES");
            IvParameterSpec ips = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)sk, ips);
            return cipher.doFinal(input, inputOffset, length, output, outputOffset);
        }
        catch (Exception ex) {
            Log.error("Could not decrypt data with AES.", ex);
            return 0;
        }
    }

    public static byte[] getMd5Hash(String s) {
        return Crypto.getMd5Hash(DataBuffer.wrap(Encoding.getUtf8().getBytes(s)));
    }

    public static byte[] getMd5Hash(DataBuffer buffer) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(buffer.getData(), buffer.getIndex(), buffer.getLength());
            return md5.digest();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static byte[] getSha1Hash(String s) {
        return Crypto.getSha1Hash(DataBuffer.wrap(Encoding.getUtf8().getBytes(s)));
    }

    public static byte[] getSha1Hash(DataBuffer buffer) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            sha1.update(buffer.getData(), buffer.getIndex(), buffer.getLength());
            return sha1.digest();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static byte[] getMd5Sha1Hash(String s) {
        return Crypto.getMd5Sha1Hash(DataBuffer.wrap(Encoding.getUtf8().getBytes(s)));
    }

    public static byte[] getMd5Sha1Hash(DataBuffer buffer) {
        byte[] md5 = Crypto.getMd5Hash(buffer);
        byte[] sha1 = Crypto.getSha1Hash(buffer);
        byte[] hash = new byte[36];
        BitAssistant.copy(md5, 0, hash, 0, 16);
        BitAssistant.copy(sha1, 0, hash, 16, 20);
        return hash;
    }

    public static byte[] getSha256Hash(String s) {
        return Crypto.getSha256Hash(DataBuffer.wrap(Encoding.getUtf8().getBytes(s)));
    }

    public static byte[] getSha256Hash(DataBuffer buffer) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.update(buffer.getData(), buffer.getIndex(), buffer.getLength());
            return sha256.digest();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static byte[] getHmacMd5(byte[] key, DataBuffer buffer) {
        try {
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(new SecretKeySpec(key, "HmacMD5"));
            mac.update(buffer.getData(), buffer.getIndex(), buffer.getLength());
            return mac.doFinal();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static byte[] getHmacSha1(byte[] key, DataBuffer buffer) {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key, "HmacSHA1"));
            mac.update(buffer.getData(), buffer.getIndex(), buffer.getLength());
            return mac.doFinal();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }
}

