/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.HttpRequestArgs;
import fm.HttpResponseArgs;
import fm.HttpTransfer;
import fm.HttpTransferFactory;
import fm.SingleAction;
import fm.websync.MessageRequestArgs;
import fm.websync.MessageResponseArgs;
import fm.websync.MessageTransfer;

public class HttpMessageTransfer
extends MessageTransfer {
    private String _callbackKey = "fm.websync.httpMessageTransfer.callback";
    private HttpTransfer _httpTransfer = HttpTransferFactory.getHttpTransfer();

    @Override
    public MessageResponseArgs sendMessages(MessageRequestArgs requestArgs) throws Exception {
        HttpRequestArgs args = super.messageRequestArgsToHttpRequestArgs(requestArgs);
        HttpResponseArgs httpResponseArgs = this._httpTransfer.send(args);
        return super.httpResponseArgsToMessageResponseArgs(httpResponseArgs);
    }

    @Override
    public void sendMessagesAsync(MessageRequestArgs requestArgs, SingleAction<MessageResponseArgs> callback) throws Exception {
        HttpRequestArgs args = super.messageRequestArgsToHttpRequestArgs(requestArgs);
        args.setDynamicValue(this._callbackKey, callback);
        final HttpMessageTransfer _var0 = this;
        this._httpTransfer.sendAsync(args, (SingleAction)new SingleAction<HttpResponseArgs>(){

            public void invoke(HttpResponseArgs httpResponseArgs) {
                try {
                    _var0.sendMessagesAsyncCallback(httpResponseArgs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void sendMessagesAsyncCallback(HttpResponseArgs httpResponseArgs) throws Exception {
        SingleAction dynamicValue = (SingleAction)httpResponseArgs.getRequestArgs().getDynamicValue(this._callbackKey);
        httpResponseArgs.getRequestArgs().unsetDynamicValue(this._callbackKey);
        dynamicValue.invoke((Object)super.httpResponseArgsToMessageResponseArgs(httpResponseArgs));
    }

    @Override
    public void shutdown() {
        try {
            this._httpTransfer.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

