/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Log;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import java.util.Arrays;

class Native
extends fm.icelink.Native {
    private long _encoderState;
    private long _decoderState;
    private boolean _isEncoder;

    public boolean getForceKeyFrame() {
        return Native.OpenH264FMEncoderGetForceKeyFrame(this._encoderState) != 0;
    }

    public void setForceKeyFrame(boolean value) {
        Native.OpenH264FMEncoderSetForceKeyFrame(this._encoderState, value ? 1 : 0);
    }

    public int getBitrate() {
        return Native.OpenH264FMEncoderGetBitrate(this._encoderState);
    }

    public void setBitrate(int value) {
        Native.OpenH264FMEncoderSetBitrate(this._encoderState, value);
    }

    public double getQuality() {
        return Native.OpenH264FMEncoderGetQuality(this._encoderState);
    }

    public void setQuality(double value) {
        Native.OpenH264FMEncoderSetQuality(this._encoderState, value);
    }

    public double getMaxPayload() {
        return Native.OpenH264FMEncoderGetMaxPayload(this._encoderState);
    }

    public void setMaxPayload(int value) {
        Native.OpenH264FMEncoderSetMaxPayload(this._encoderState, value);
    }

    public boolean getNeedsKeyFrame() {
        return Native.OpenH264FMDecoderGetNeedsKeyFrame(this._decoderState) != 0;
    }

    public void setNeedsKeyFrame(boolean value) {
        Native.OpenH264FMDecoderSetNeedsKeyFrame(this._decoderState, value ? 1 : 0);
    }

    public Native(boolean encoder) {
        this._isEncoder = encoder;
        if (this._isEncoder) {
            this._encoderState = Native.OpenH264FMEncoderCreate(0L, 0L, 0L, 0L);
        } else {
            this._decoderState = Native.OpenH264FMDecoderCreate(0L, 0L, 0L, 0L);
        }
    }

    public void destroy() {
        if (this._isEncoder) {
            Native.OpenH264FMEncoderDestroy(this._encoderState);
        } else {
            Native.OpenH264FMDecoderDestroy(this._decoderState);
        }
        this._encoderState = 0L;
        this._decoderState = 0L;
    }

    public VideoBuffer encode(VideoBuffer buffer, VideoFormat outputFormat) {
        byte[][] planeDatas = new byte[4][];
        int[] planeStrides = new int[4];
        int[] planeIndexes = new int[4];
        int[] planeLengths = new int[4];
        for (int i = 0; i < buffer.getDataBuffers().length; ++i) {
            DataBuffer plane = buffer.getDataBuffers()[i];
            planeDatas[i] = plane.getData();
            planeStrides[i] = buffer.getStrides()[i];
            planeIndexes[i] = plane.getIndex();
            planeLengths[i] = plane.getLength();
        }
        int[] encodedLengthArray = new int[1];
        byte[] outputData = Native.OpenH264FMEncoderEncodei420(this._encoderState, buffer.getWidth(), buffer.getHeight(), planeDatas, planeStrides, planeIndexes, planeLengths, encodedLengthArray);
        if (outputData != null) {
            return new VideoBuffer(buffer.getWidth(), buffer.getHeight(), DataBuffer.wrap((byte[])outputData), outputFormat);
        }
        return null;
    }

    public VideoBuffer decode(VideoBuffer encodedFrame, VideoFormat outputFormat) {
        int[] widthArray = new int[1];
        int[] heightArray = new int[1];
        int[] planeStrides = new int[4];
        int[] planeLengths = new int[4];
        int[] planeCountArray = new int[1];
        DataBuffer buffer = encodedFrame.getDataBuffers()[0];
        byte[] outputData = Native.OpenH264FMDecoderDecode(this._decoderState, Arrays.copyOfRange(buffer.getData(), buffer.getIndex(), buffer.getLength()), buffer.getLength(), widthArray, heightArray, planeStrides, planeLengths, planeCountArray);
        if (outputData != null) {
            buffer = DataBuffer.wrap((byte[])outputData);
            int width = widthArray[0];
            int height = heightArray[0];
            final int[] strides = new int[planeStrides.length];
            int planeCount = planeCountArray[0];
            DataBuffer[] planes = new DataBuffer[planeCount];
            int offset = 0;
            for (int i = 0; i < planeCount; ++i) {
                strides[i] = planeStrides[i];
                planes[i] = buffer.subset(offset, planeLengths[i]);
                offset += planeLengths[i];
            }
            return new VideoBuffer(width, height, planes, outputFormat){
                {
                    super(x0, x1, x2, x3);
                    this.setStrides(strides);
                }
            };
        }
        return null;
    }

    private static void DebugCallback(String msg) {
        Log.info((String)("LibOpenH264FM: " + msg));
    }

    private static void ErrorCallback(String msg) {
        Log.error((String)("LibOpenH264FM: " + msg));
    }

    private static native int OpenH264FMEncoderGetMaxPayload(long var0);

    private static native void OpenH264FMEncoderSetMaxPayload(long var0, int var2);

    private static native int OpenH264FMEncoderGetBitrate(long var0);

    private static native void OpenH264FMEncoderSetBitrate(long var0, int var2);

    private static native double OpenH264FMEncoderGetQuality(long var0);

    private static native void OpenH264FMEncoderSetQuality(long var0, double var2);

    private static native int OpenH264FMEncoderGetForceKeyFrame(long var0);

    private static native void OpenH264FMEncoderSetForceKeyFrame(long var0, int var2);

    private static native long OpenH264FMEncoderCreate(long var0, long var2, long var4, long var6);

    private static native void OpenH264FMEncoderDestroy(long var0);

    private static native byte[] OpenH264FMEncoderEncodei420(long var0, int var2, int var3, byte[][] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    private static native long OpenH264FMDecoderCreate(long var0, long var2, long var4, long var6);

    private static native void OpenH264FMDecoderDestroy(long var0);

    private static native byte[] OpenH264FMDecoderDecode(long var0, byte[] var2, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    private static native int OpenH264FMDecoderGetNeedsKeyFrame(long var0);

    private static native void OpenH264FMDecoderSetNeedsKeyFrame(long var0, int var2);

    static {
        Global.loadLibrary((String)"openh264fmJNI");
    }
}

