/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.crypto.agreement.srp.SRP6StandardGroups;
import org.bouncycastle.crypto.params.SRP6GroupParameters;
import org.bouncycastle.crypto.tls.TlsSRPGroupVerifier;

public class DefaultTlsSRPGroupVerifier
implements TlsSRPGroupVerifier {
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;

    static {
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1024);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1536);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_2048);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_3072);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_4096);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_6144);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_8192);
    }

    public DefaultTlsSRPGroupVerifier() {
        this(DEFAULT_GROUPS);
    }

    public DefaultTlsSRPGroupVerifier(Vector groups) {
        this.groups = groups;
    }

    @Override
    public boolean accept(SRP6GroupParameters group) {
        int i = 0;
        while (i < this.groups.size()) {
            if (this.areGroupsEqual(group, (SRP6GroupParameters)this.groups.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean areGroupsEqual(SRP6GroupParameters a, SRP6GroupParameters b) {
        return a == b || this.areParametersEqual(a.getN(), b.getN()) && this.areParametersEqual(a.getG(), b.getG());
    }

    protected boolean areParametersEqual(BigInteger a, BigInteger b) {
        return a == b || a.equals(b);
    }
}

