/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.Binary;
import fm.icelink.Crc32;
import fm.icelink.stun.Attribute;

public class FingerprintAttribute
extends Attribute {
    private static Crc32 __crc32;
    private byte[] _messageBytes;
    private static long _xorValue;

    public static FingerprintAttribute fromValueBytes(byte[] valueBytes, byte[] messageBytes) {
        long num2 = Binary.fromBytes32(valueBytes, 0, false) ^ _xorValue;
        if (num2 != FingerprintAttribute.getCheckSum(messageBytes)) {
            throw new RuntimeException(new Exception("Supplied checksum does not match calculated checksum."));
        }
        return new FingerprintAttribute();
    }

    byte[] getBytes(byte[] messageBytes) {
        if (messageBytes == null) {
            throw new RuntimeException(new Exception("messageBytes cannot be null."));
        }
        this.setMessageBytes(messageBytes);
        byte[] bytes = super.getBytes();
        this.setMessageBytes(null);
        return bytes;
    }

    private static long getCheckSum(byte[] messageBytes) {
        return __crc32.compute(messageBytes);
    }

    private byte[] getMessageBytes() {
        return this._messageBytes;
    }

    @Override
    protected byte[] getValueBytes() {
        long num2 = FingerprintAttribute.getCheckSum(this.getMessageBytes()) ^ _xorValue;
        return Binary.toBytes32(num2, false);
    }

    private void setMessageBytes(byte[] value) {
        this._messageBytes = value;
    }

    public String toString() {
        return "FINGERPRINT";
    }

    static {
        _xorValue = 1398035790L;
        __crc32 = new Crc32(Crc32.getCrc32Polynomial());
    }
}

