/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.h264;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.h264.Nalu;
import fm.icelink.h264.NaluType;
import java.util.ArrayList;

public class Packet {
    private DataBuffer __buffer;
    private boolean _fragmentEnd;
    private boolean _fragmentStart;
    private boolean _last;
    private Nalu[] _nalus;
    private int _naluType;
    private long _sequenceNumber;

    public static DataBuffer depacketize(Packet[] packets) {
        return Packet.depacketize(packets, 0);
    }

    public static DataBuffer depacketize(Packet[] packets, int packetizationMode) {
        DataBuffer empty = DataBuffer.getEmpty();
        for (Packet packet : packets) {
            empty.append(packet.getBytes());
        }
        return empty;
    }

    private static Packet flushNaluAccumulator(Nalu[] nalus) {
        if (ArrayExtensions.getLength(nalus) == 1) {
            return new Packet(nalus[0]);
        }
        Packet packet = new Packet();
        packet.setNaluType(24);
        packet.setNalus(nalus);
        return packet;
    }

    public DataBuffer getBuffer() {
        if (this.__buffer == null) {
            this.__buffer = this.getBytes();
        }
        return this.__buffer;
    }

    private DataBuffer getBytes() {
        DataBuffer empty = this.getNaluType() == 24 ? DataBuffer.wrap(new byte[]{this.getNalus()[0].getFBit() ? (byte)1 : (byte)(this.getNalus()[0].getNalRefIdc() | this.getNaluType())}) : (this.getNaluType() == 28 ? DataBuffer.wrap(new byte[]{this.getNalus()[0].getFBit() ? (byte)1 : (byte)(this.getNalus()[0].getNalRefIdc() | 0x1C), (byte)((this.getFragmentStart() ? Packet.getFuSBitMask() : 0) | (this.getFragmentEnd() ? Packet.getFuEBitMask() : 0) | this.getNalus()[0].getType())}) : DataBuffer.getEmpty());
        for (int i = 0; i < ArrayExtensions.getLength(this.getNalus()); ++i) {
            if (this.getNaluType() == 24) {
                empty.append(this.getNalus()[i].getShortLength());
            }
            if (this.getNaluType() == 28) {
                empty.append(this.getNalus()[i].getPayload());
                continue;
            }
            empty.append(this.getNalus()[i].getBuffer());
        }
        return empty;
    }

    public boolean getFragmentEnd() {
        return this._fragmentEnd;
    }

    public boolean getFragmentStart() {
        return this._fragmentStart;
    }

    public static int getFuEBitMask() {
        return 64;
    }

    public static int getFuRBitMask() {
        return 32;
    }

    public static int getFuSBitMask() {
        return 128;
    }

    public boolean getLast() {
        return this._last;
    }

    public static int getMaxPacketSize() {
        return 1150;
    }

    public Nalu[] getNalus() {
        return this._nalus;
    }

    public int getNaluType() {
        return this._naluType;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public Packet() {
        this.setFragmentEnd(false);
        this.setFragmentStart(false);
    }

    public Packet(Nalu nalu) {
        this.setNalus(new Nalu[]{nalu});
        this.setNaluType(nalu.getType());
    }

    public static Packet[] packetize(DataBuffer encodedData) {
        return Packet.packetize(encodedData, 0);
    }

    public static Packet[] packetize(DataBuffer encodedData, int packetizationMode) {
        Nalu nalu;
        int num = Packet.getMaxPacketSize() - 1;
        ArrayList<Nalu> list = new ArrayList<Nalu>();
        int num2 = 0;
        ArrayList<Packet> list2 = new ArrayList<Packet>();
        int nalStart = Nalu.findNextNalu(encodedData, 0);
        while ((nalu = Nalu.getNalu(encodedData, nalStart)) != null) {
            if (nalu.getPayload().getLength() > num) {
                if (ArrayListExtensions.getCount(list) > 0) {
                    list2.add(Packet.flushNaluAccumulator(list.toArray(new Nalu[0])));
                    list.clear();
                    num2 = 0;
                }
                if (packetizationMode == 0) {
                    Log.error(StringExtensions.concat(new Object[]{"NAL Unit too large for H.264 Single NAL packetization mode. NaluSize=", nalu.getPayload().getLength(), ", MaxPayloadSize=", num}));
                    return null;
                }
                int count = num - 1;
                boolean flag = false;
                int i = 0;
                while (!flag) {
                    if (count + i >= nalu.getPayload().getLength()) {
                        count = nalu.getPayload().getLength() - i;
                        flag = true;
                    }
                    DataBuffer payload = DataBuffer.allocate(count);
                    payload.write(nalu.getPayload().subset(i, count), 0);
                    Packet item = new Packet(new Nalu(payload, 0, nalu.getNalRefIdc(), nalu.getType()));
                    item.setNaluType(28);
                    item.setFragmentStart(i == 0);
                    item.setFragmentEnd(flag);
                    list2.add(item);
                    i += count;
                }
            } else if (nalu.getPayload().getLength() > 0) {
                if (packetizationMode == 0) {
                    list2.add(new Packet(nalu));
                } else {
                    if (num2 + nalu.getPayload().getLength() > num && ArrayListExtensions.getCount(list) > 0) {
                        list2.add(Packet.flushNaluAccumulator(list.toArray(new Nalu[0])));
                        list.clear();
                        num2 = 0;
                    }
                    list.add(nalu);
                    num2 += nalu.getPayload().getLength();
                }
            }
            if ((nalStart += nalu.getBuffer().getLength() + Nalu.getStartCode().getLength()) < encodedData.getLength()) continue;
        }
        if (ArrayListExtensions.getCount(list) > 0) {
            list2.add(Packet.flushNaluAccumulator(list.toArray(new Nalu[0])));
        } else if (ArrayListExtensions.getCount(list2) == 0) {
            Log.error("Cannot packetize data.");
            return null;
        }
        return list2.toArray(new Packet[0]);
    }

    private void setFragmentEnd(boolean value) {
        this._fragmentEnd = value;
    }

    private void setFragmentStart(boolean value) {
        this._fragmentStart = value;
    }

    public void setLast(boolean value) {
        this._last = value;
    }

    public void setNalus(Nalu[] value) {
        this._nalus = value;
    }

    private void setNaluType(int value) {
        this._naluType = value;
    }

    public void setSequenceNumber(long value) {
        this._sequenceNumber = value;
    }

    public static Packet wrap(DataBuffer buffer) {
        Packet packet = new Packet();
        ArrayList<Nalu> list = new ArrayList<Nalu>();
        packet.setNaluType(NaluType.getNaluType(buffer.read8(0)));
        packet.setFragmentStart(false);
        packet.setFragmentEnd(false);
        if (packet.getNaluType() == 24) {
            int length = 0;
            for (int i = 3; i < buffer.getLength(); i += length + 2) {
                length = buffer.clone(false).read16(i - 2);
                if (i + length > buffer.getLength()) {
                    Log.debug(StringExtensions.format("H264Packet ParseBytes packetBytes STAP-A size error: nalSize={0} packetBytesLength={1} nalStart={2} sizeBytes=[{3}]", new Object[]{IntegerExtensions.toString(length), IntegerExtensions.toString(buffer.getLength()), IntegerExtensions.toString(i), IntegerExtensions.toString(length)}));
                    length = buffer.getLength() - i;
                }
                list.add(new Nalu(buffer.subset(i, length)));
            }
        } else if (packet.getNaluType() == 28) {
            if ((buffer.read8(1) & Packet.getFuSBitMask()) != 0) {
                packet.setFragmentStart(true);
            } else if ((buffer.read8(1) & Packet.getFuEBitMask()) != 0) {
                packet.setFragmentEnd(true);
            }
            list.add(new Nalu(buffer.subset(2), buffer.read8(0) & Nalu.getFBitMask(), buffer.read8(0) & Nalu.getNriMask(), buffer.read8(1) & Nalu.getTypeMask()));
        } else if (NaluType.isSingleNalu(packet.getNaluType())) {
            list.add(new Nalu(buffer));
        } else {
            Log.error("Unsupported H264Packet NaluType");
            return null;
        }
        packet.setNalus(list.toArray(new Nalu[0]));
        return packet;
    }
}

