/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.h264;

import fm.icelink.DataBuffer;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.RtpPacket;
import fm.icelink.h264.Frame;
import fm.icelink.h264.Packet;
import java.util.ArrayList;
import java.util.HashMap;

public class Accumulator {
    private HashMap<String, Frame> _h264FrameMap = new HashMap();

    public DataBuffer add(RtpPacket rtpPacket, long sequenceNumber, LongHolder newSequenceNumber) {
        newSequenceNumber.setValue(sequenceNumber);
        Packet packet = this.extractH264(rtpPacket, sequenceNumber);
        String key = LongExtensions.toString(rtpPacket.getTimestamp());
        if (packet != null) {
            Frame frame = null;
            Holder<Object> _var0 = new Holder<Object>(frame);
            boolean _var1 = HashMapExtensions.tryGetValue(this._h264FrameMap, key, _var0);
            frame = _var0.getValue();
            if (_var1) {
                frame.add(packet);
                if (frame.getIsComplete()) {
                    HashMapExtensions.remove(this._h264FrameMap, key);
                    DataBuffer _var2 = frame.assemble(newSequenceNumber);
                    return _var2;
                }
            } else {
                if (packet.getLast() || packet.getFragmentEnd()) {
                    DataBuffer _var3 = new Frame(packet).assemble(newSequenceNumber);
                    return _var3;
                }
                HashMapExtensions.set(HashMapExtensions.getItem(this._h264FrameMap), key, new Frame(packet));
            }
        }
        return null;
    }

    public int clearAged() {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : HashMapExtensions.getKeys(this._h264FrameMap)) {
            list.add(str);
        }
        int num = 0;
        for (String str : list) {
            Frame frame = HashMapExtensions.getItem(this._h264FrameMap).get(str);
            frame.increaseAge();
            if (!frame.getIsAged()) continue;
            HashMapExtensions.remove(this._h264FrameMap, str);
            ++num;
        }
        return num;
    }

    private Packet extractH264(RtpPacket rtpPacket, long sequenceNumber) {
        Packet packet = Packet.wrap(rtpPacket.getPayload());
        if (packet == null) {
            return null;
        }
        packet.setLast(rtpPacket.getMarker());
        packet.setSequenceNumber(sequenceNumber);
        return packet;
    }
}

