/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IntegerExtensions;
import fm.icelink.LongExtensions;
import fm.icelink.MediaFormat;
import fm.icelink.ParseAssistant;
import java.util.HashMap;

public class VideoFormat
extends MediaFormat<VideoFormat> {
    private static HashMap<String, String> _fourCCLookup;
    private static HashMap<String, String> _reverseFourCCLookup;

    @Override
    public VideoFormat clone() {
        return (VideoFormat)super.clone();
    }

    @Override
    protected VideoFormat createInstance() {
        return new VideoFormat();
    }

    public static long formatNameToFourCC(String formatName) {
        String str = null;
        Holder<Object> _var0 = new Holder<Object>(str);
        boolean _var1 = HashMapExtensions.tryGetValue(_fourCCLookup, formatName, _var0);
        str = _var0.getValue();
        if (_var1) {
            return ParseAssistant.parseLongValue(str);
        }
        return 0L;
    }

    public String fourCCToFormatName(long fourcc) {
        if (_reverseFourCCLookup == null) {
            HashMap dictionary = new HashMap();
            for (String str : HashMapExtensions.getKeys(_fourCCLookup)) {
                HashMapExtensions.set(HashMapExtensions.getItem(dictionary), HashMapExtensions.getItem(_fourCCLookup).get(str), str);
            }
            _reverseFourCCLookup = dictionary;
        }
        String str2 = null;
        Holder<Object> _var0 = new Holder<Object>(str2);
        boolean _var1 = HashMapExtensions.tryGetValue(_reverseFourCCLookup, LongExtensions.toString(fourcc), _var0);
        str2 = _var0.getValue();
        if (_var1) {
            return str2;
        }
        return "";
    }

    public static VideoFormat getAbgr() {
        return new VideoFormat(VideoFormat.getAbgrName());
    }

    public static String getAbgrName() {
        return "ABGR";
    }

    public static VideoFormat getArgb() {
        return new VideoFormat(VideoFormat.getArgbName());
    }

    public static String getArgbName() {
        return "ARGB";
    }

    public static VideoFormat getBgr() {
        return new VideoFormat(VideoFormat.getBgrName());
    }

    public static VideoFormat getBgra() {
        return new VideoFormat(VideoFormat.getBgraName());
    }

    public static String getBgraName() {
        return "BGRA";
    }

    public static String getBgrName() {
        return "BGR";
    }

    public long getFourCC() {
        return VideoFormat.formatNameToFourCC(super.getName());
    }

    public static VideoFormat getH264() {
        return new VideoFormat(VideoFormat.getH264Name());
    }

    public static String getH264Name() {
        return "H264";
    }

    public static VideoFormat getI420() {
        return new VideoFormat(VideoFormat.getI420Name());
    }

    public static String getI420Name() {
        return "I420";
    }

    public static VideoFormat getNv12() {
        return new VideoFormat(VideoFormat.getNv12Name());
    }

    public static String getNv12Name() {
        return "NV12";
    }

    public static VideoFormat getNv21() {
        return new VideoFormat(VideoFormat.getNv21Name());
    }

    public static String getNv21Name() {
        return "NV21";
    }

    @Override
    public String getParameters() {
        return null;
    }

    public static VideoFormat getRgb() {
        return new VideoFormat(VideoFormat.getRgbName());
    }

    public static VideoFormat getRgba() {
        return new VideoFormat(VideoFormat.getRgbaName());
    }

    public static String getRgbaName() {
        return "RGBA";
    }

    public static String getRgbName() {
        return "RGB";
    }

    public static String getVp8Name() {
        return "VP8";
    }

    public static String getVp9Name() {
        return "VP9";
    }

    public static VideoFormat getYv12() {
        return new VideoFormat(VideoFormat.getYv12Name());
    }

    public static String getYv12Name() {
        return "YV12";
    }

    public void setFourCC(long value) {
        super.setName(this.fourCCToFormatName(value));
    }

    public static int toFourCC(String fourcc) {
        return VideoFormat.toFourCC(fourcc.charAt(0), fourcc.charAt(1), fourcc.charAt(2), fourcc.charAt(3));
    }

    public static int toFourCC(char a, char b, char c, char d) {
        return a | BitAssistant.leftShiftInteger(b, 8) | BitAssistant.leftShiftInteger(c, 16) | BitAssistant.leftShiftInteger(d, 24);
    }

    protected VideoFormat() {
    }

    public VideoFormat(String name, int clockRate) {
        super(name, clockRate);
    }

    public VideoFormat(String name) {
        this(name, 90000);
    }

    static {
        HashMap dictionary = new HashMap();
        HashMapExtensions.add(dictionary, VideoFormat.getRgbName(), IntegerExtensions.toString(VideoFormat.toFourCC('r', 'a', 'w', ' ')));
        HashMapExtensions.add(dictionary, VideoFormat.getBgrName(), IntegerExtensions.toString(VideoFormat.toFourCC('2', '4', 'B', 'G')));
        HashMapExtensions.add(dictionary, VideoFormat.getNv12Name(), IntegerExtensions.toString(VideoFormat.toFourCC('N', 'V', '1', '2')));
        HashMapExtensions.add(dictionary, VideoFormat.getNv21Name(), IntegerExtensions.toString(VideoFormat.toFourCC('N', 'V', '2', '1')));
        HashMapExtensions.add(dictionary, VideoFormat.getI420Name(), IntegerExtensions.toString(VideoFormat.toFourCC('I', '4', '2', '0')));
        HashMapExtensions.add(dictionary, VideoFormat.getYv12Name(), IntegerExtensions.toString(VideoFormat.toFourCC('Y', 'V', '1', '2')));
        HashMapExtensions.add(dictionary, VideoFormat.getArgbName(), IntegerExtensions.toString(VideoFormat.toFourCC('A', 'R', 'G', 'B')));
        HashMapExtensions.add(dictionary, VideoFormat.getAbgrName(), IntegerExtensions.toString(VideoFormat.toFourCC('A', 'B', 'G', 'R')));
        HashMapExtensions.add(dictionary, VideoFormat.getRgbaName(), IntegerExtensions.toString(VideoFormat.toFourCC('R', 'G', 'B', 'A')));
        HashMapExtensions.add(dictionary, VideoFormat.getBgraName(), IntegerExtensions.toString(VideoFormat.toFourCC('B', 'G', 'R', 'A')));
        _fourCCLookup = dictionary;
        _reverseFourCCLookup = null;
    }
}

