/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpErrorCause;
import fm.icelink.StringExtensions;

class SctpInvalidStreamIdentifier
extends SctpErrorCause {
    private int _streamIdentifier;

    @Override
    public byte[] getBytes() {
        return SctpInvalidStreamIdentifier.getBytes(this);
    }

    public static byte[] getBytes(SctpInvalidStreamIdentifier cause) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(cause.getCauseCode(), false));
        bytes.addRange(Binary.toBytes16(8, false));
        bytes.addRange(Binary.toBytes16(cause.getStreamIdentifier(), false));
        SctpChunk.addPadding(bytes);
        return bytes.toArray();
    }

    public int getStreamIdentifier() {
        return this._streamIdentifier;
    }

    public static SctpInvalidStreamIdentifier parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int streamIdentifier = Binary.fromBytes16(bytes, 4, false);
            offsetPlus.setValue(8);
            Log.debug(StringExtensions.format("SCTP Error: invalid stream identifier: {0}.", IntegerExtensions.toString(streamIdentifier)));
            return new SctpInvalidStreamIdentifier(streamIdentifier);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpInvalidStreamIdentifier(int streamIdentifier) {
        super.setCauseCode(1);
        this.setStreamIdentifier(streamIdentifier);
    }

    public void setStreamIdentifier(int value) {
        this._streamIdentifier = value;
    }
}

