/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFormatCollection;
import java.util.HashMap;

class RtpParameters<TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>> {
    private String _canonicalName;
    private long[] _localContributingSources;
    private long[] _localSynchronizationSources;
    private Object _localSynchronizationSourcesLock;
    private TFormatCollection _negotiatedFormats;
    private HashMap<String, TFormat> _payloadTypeRegistry;
    private long[] _remoteSynchronizationSources;
    private Object _remoteSynchronizationSourcesLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalSynchronizationSource(long localSynchronizationSource) {
        Object object = this._localSynchronizationSourcesLock;
        synchronized (object) {
            if (!this.hasLocalSynchronizationSource(localSynchronizationSource)) {
                long[] numArray = new long[ArrayExtensions.getLength(this.getLocalSynchronizationSources()) + 1];
                for (int i = 0; i < ArrayExtensions.getLength(this.getLocalSynchronizationSources()); ++i) {
                    numArray[i] = this.getLocalSynchronizationSources()[i];
                }
                numArray[ArrayExtensions.getLength((long[])numArray) - 1] = localSynchronizationSource;
                this.setLocalSynchronizationSources(numArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteSynchronizationSource(long remoteSynchronizationSource) {
        Object object = this._remoteSynchronizationSourcesLock;
        synchronized (object) {
            if (!this.hasRemoteSynchronizationSource(remoteSynchronizationSource)) {
                long[] numArray = new long[ArrayExtensions.getLength(this.getRemoteSynchronizationSources()) + 1];
                for (int i = 0; i < ArrayExtensions.getLength(this.getRemoteSynchronizationSources()); ++i) {
                    numArray[i] = this.getRemoteSynchronizationSources()[i];
                }
                numArray[ArrayExtensions.getLength((long[])numArray) - 1] = remoteSynchronizationSource;
                this.setRemoteSynchronizationSources(numArray);
            }
        }
    }

    String getCanonicalName() {
        return this._canonicalName;
    }

    public long[] getLocalContributingSources() {
        return this._localContributingSources;
    }

    public long[] getLocalSynchronizationSources() {
        return this._localSynchronizationSources;
    }

    public TFormatCollection getNegotiatedFormats() {
        return this._negotiatedFormats;
    }

    public HashMap<String, TFormat> getPayloadTypeRegistry() {
        return this._payloadTypeRegistry;
    }

    public long[] getRemoteSynchronizationSources() {
        return this._remoteSynchronizationSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLocalSynchronizationSource(long synchronizationSource) {
        Object object = this._localSynchronizationSourcesLock;
        synchronized (object) {
            long[] localSynchronizationSources;
            for (long num : localSynchronizationSources = this.getLocalSynchronizationSources()) {
                if (synchronizationSource != num) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemoteSynchronizationSource(long synchronizationSource) {
        Object object = this._remoteSynchronizationSourcesLock;
        synchronized (object) {
            long[] remoteSynchronizationSources;
            for (long num : remoteSynchronizationSources = this.getRemoteSynchronizationSources()) {
                if (synchronizationSource != num) continue;
                return true;
            }
            return false;
        }
    }

    public RtpParameters(TFormatCollection emptyFormatCollection) {
        this._localSynchronizationSourcesLock = new Object();
        this.setPayloadTypeRegistry(new HashMap());
        this.setNegotiatedFormats(emptyFormatCollection);
        this.setLocalSynchronizationSources(new long[0]);
        this.setRemoteSynchronizationSources(new long[0]);
    }

    void setCanonicalName(String value) {
        this._canonicalName = value;
    }

    public void setLocalContributingSources(long[] value) {
        this._localContributingSources = value;
    }

    private void setLocalSynchronizationSources(long[] value) {
        this._localSynchronizationSources = value;
    }

    public void setNegotiatedFormats(TFormatCollection value) {
        this._negotiatedFormats = value;
    }

    public void setPayloadTypeRegistry(HashMap<String, TFormat> value) {
        this._payloadTypeRegistry = value;
    }

    private void setRemoteSynchronizationSources(long[] value) {
        this._remoteSynchronizationSources = value;
    }
}

