/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AecContext;
import fm.icelink.AudioConfig;
import fm.icelink.AudioDecoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioSink;
import fm.icelink.AudioTrack;
import fm.icelink.IAudioSink;
import fm.icelink.IAudioSource;
import fm.icelink.IVideoSink;
import fm.icelink.Log;
import fm.icelink.Media;
import fm.icelink.SoundConverter;
import fm.icelink.VideoDecoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoPipe;
import fm.icelink.VideoSink;
import fm.icelink.VideoTrack;
import fm.icelink.ViewSink;
import fm.icelink.pcma.Format;
import fm.icelink.pcmu.Decoder;
import fm.icelink.vp8.Depacketizer;
import java.util.ArrayList;

public abstract class RtcRemoteMedia<TView>
extends Media {
    private ArrayList<AudioSink> __audioRecorders;
    private AudioConfig __opusConfig = new AudioConfig(48000, 2);
    private AudioConfig __pcmaConfig;
    private AudioConfig __pcmuConfig = new AudioConfig(8000, 1);
    private ArrayList<VideoSink> __videoRecorders;
    private AecContext _aecContext;
    private boolean _audioDisabled;
    private Object _audioRecordingLock;
    private boolean _videoDisabled;
    private Object _videoRecordingLock;
    private ViewSink<TView> _viewSink;

    protected abstract AudioSink createAudioRecorder(AudioFormat var1);

    protected abstract AudioSink createAudioSink(AudioConfig var1);

    protected abstract VideoDecoder createH264Decoder();

    protected abstract VideoPipe createImageConverter(VideoFormat var1);

    protected abstract AudioDecoder createOpusDecoder(AudioConfig var1);

    protected AudioDecoder createPcmaDecoder(AudioConfig config) {
        return new fm.icelink.pcma.Decoder(config);
    }

    protected AudioDecoder createPcmuDecoder(AudioConfig config) {
        return new Decoder(config);
    }

    protected abstract VideoSink createVideoRecorder(VideoFormat var1);

    protected abstract ViewSink<TView> createViewSink();

    protected abstract VideoDecoder createVp8Decoder();

    protected abstract VideoDecoder createVp9Decoder();

    @Override
    public void destroy() {
        if (!this.getAecDisabled()) {
            for (IAudioSource source : (IAudioSource[])super.getAudioTrack().getOutputs()) {
                source.removeSink(this.getAecContext().getOutputMixer());
            }
        }
        for (AudioSink sink : this.__audioRecorders) {
            sink.destroy();
        }
        for (VideoSink sink2 : this.__videoRecorders) {
            sink2.destroy();
        }
        super.destroy();
    }

    public AecContext getAecContext() {
        return this._aecContext;
    }

    public boolean getAecDisabled() {
        return this.getAecContext() == null || this.getAudioDisabled();
    }

    public boolean getAudioDisabled() {
        return this._audioDisabled;
    }

    public IAudioSink[] getAudioInputs() {
        return (IAudioSink[])super.getAudioTrack().getInputs();
    }

    private AudioSink getAudioRecorder(AudioFormat inputFormat) {
        AudioSink item = this.createAudioRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__audioRecorders.add(item);
        }
        return item;
    }

    public boolean getVideoDisabled() {
        return this._videoDisabled;
    }

    public IVideoSink[] getVideoInputs() {
        return (IVideoSink[])super.getVideoTrack().getInputs();
    }

    private VideoSink getVideoRecorder(VideoFormat inputFormat) {
        VideoSink item = this.createVideoRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__videoRecorders.add(item);
        }
        return item;
    }

    public TView getView() {
        return this.getViewSink() == null ? null : (TView)this.getViewSink().getView();
    }

    public ViewSink<TView> getViewSink() {
        return this._viewSink;
    }

    public void initialize() {
        try {
            VideoTrack videoTrack;
            AudioTrack audioTrack;
            this.setViewSink(this.createViewSink());
            AudioDecoder element = this.createOpusDecoder(this.__opusConfig);
            AudioDecoder decoder2 = this.createPcmaDecoder(this.__pcmaConfig);
            AudioDecoder decoder3 = this.createPcmuDecoder(this.__pcmuConfig);
            AudioSink audioRecorder = this.getAudioRecorder(new fm.icelink.opus.Format(this.__opusConfig));
            AudioSink sink2 = this.getAudioRecorder(new Format(this.__pcmaConfig));
            AudioSink sink3 = this.getAudioRecorder(new fm.icelink.pcmu.Format(this.__pcmuConfig));
            if (this.getAudioDisabled()) {
                audioTrack = new AudioTrack();
            } else {
                AudioTrack[] audioTrackArray = new AudioTrack[3];
                AudioTrack audioTrack2 = element != null ? (AudioTrack)new AudioTrack(new fm.icelink.opus.Depacketizer(this.__opusConfig)).next(new AudioTrack[]{audioRecorder != null ? new AudioTrack(audioRecorder) : new AudioTrack(), (AudioTrack)new AudioTrack(element).next(this.getAecDisabled() ? this.createAudioSink(this.__opusConfig) : new SoundConverter(this.getAecContext().getConfig()))}) : (audioTrackArray[0] = new AudioTrack());
                AudioTrack audioTrack3 = decoder3 != null ? (AudioTrack)new AudioTrack(new fm.icelink.pcmu.Depacketizer(this.__pcmuConfig)).next(new AudioTrack[]{sink3 != null ? new AudioTrack(sink3) : new AudioTrack(), (AudioTrack)new AudioTrack(decoder3).next(this.getAecDisabled() ? this.createAudioSink(this.__pcmuConfig) : new SoundConverter(this.getAecContext().getConfig()))}) : (audioTrackArray[1] = new AudioTrack());
                audioTrackArray[2] = decoder2 != null ? (AudioTrack)new AudioTrack(new fm.icelink.pcma.Depacketizer(this.__pcmaConfig)).next(new AudioTrack[]{sink2 != null ? new AudioTrack(sink2) : new AudioTrack(), (AudioTrack)new AudioTrack(decoder2).next(this.getAecDisabled() ? this.createAudioSink(this.__pcmaConfig) : new SoundConverter(this.getAecContext().getConfig()))}) : new AudioTrack();
                audioTrack = new AudioTrack(audioTrackArray);
            }
            this.addAudioTrack(audioTrack);
            if (!this.getAecDisabled()) {
                for (IAudioSource source : (IAudioSource[])super.getAudioTrack().getOutputs()) {
                    source.addSink(this.getAecContext().getOutputMixer());
                }
            }
            VideoDecoder decoder4 = this.createVp8Decoder();
            VideoDecoder decoder5 = this.createVp9Decoder();
            VideoDecoder decoder6 = this.createH264Decoder();
            VideoSink videoRecorder = this.getVideoRecorder(new fm.icelink.vp8.Format());
            VideoSink sink5 = this.getVideoRecorder(new fm.icelink.vp9.Format());
            VideoSink sink6 = this.getVideoRecorder(new fm.icelink.h264.Format());
            if (this.getVideoDisabled()) {
                videoTrack = new VideoTrack();
            } else {
                VideoTrack[] videoTrackArray = new VideoTrack[3];
                VideoTrack videoTrack2 = decoder4 != null ? (VideoTrack)new VideoTrack(new Depacketizer()).next(new VideoTrack[]{videoRecorder != null ? new VideoTrack(videoRecorder) : new VideoTrack(), new VideoTrack(decoder4)}) : (videoTrackArray[0] = new VideoTrack());
                VideoTrack videoTrack3 = decoder6 != null ? (VideoTrack)new VideoTrack(new fm.icelink.h264.Depacketizer()).next(new VideoTrack[]{sink6 != null ? new VideoTrack(sink6) : new VideoTrack(), new VideoTrack(decoder6)}) : (videoTrackArray[1] = new VideoTrack());
                videoTrackArray[2] = decoder5 != null ? (VideoTrack)new VideoTrack(new fm.icelink.vp9.Depacketizer()).next(new VideoTrack[]{sink5 != null ? new VideoTrack(sink5) : new VideoTrack(), new VideoTrack(decoder5)}) : new VideoTrack();
                videoTrack = (VideoTrack)((VideoTrack)new VideoTrack(videoTrackArray).next(this.createImageConverter((VideoFormat)this.getViewSink().getInputFormat()))).next(this.getViewSink());
            }
            this.addVideoTrack(videoTrack);
        }
        catch (Exception exception) {
            Log.error("Error occured while initializing remote media.", exception);
            throw new RuntimeException(exception);
        }
    }

    public RtcRemoteMedia(boolean disableAudio, boolean disableVideo, AecContext aecContext) {
        this.__pcmaConfig = new AudioConfig(8000, 1);
        this.__audioRecorders = new ArrayList();
        this.__videoRecorders = new ArrayList();
        this._audioRecordingLock = new Object();
        this._videoRecordingLock = new Object();
        this.setAudioDisabled(disableAudio);
        this.setVideoDisabled(disableVideo);
        this.setAecContext(aecContext);
    }

    public RtcRemoteMedia(boolean disableAudio, boolean disableVideo) {
        this(disableAudio, disableVideo, null);
    }

    private void setAecContext(AecContext value) {
        this._aecContext = value;
    }

    private void setAudioDisabled(boolean value) {
        this._audioDisabled = value;
    }

    private void setVideoDisabled(boolean value) {
        this._videoDisabled = value;
    }

    private void setViewSink(ViewSink<TView> value) {
        this._viewSink = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleAudioRecording() {
        Object object = this._audioRecordingLock;
        synchronized (object) {
            super.setIsRecordingAudio(!super.getIsRecordingAudio());
            this.getViewSink().setIsRecording(super.getIsRecordingVideo() || super.getIsRecordingAudio());
            for (AudioSink sink : this.__audioRecorders) {
                sink.setDisabled(!super.getIsRecordingAudio());
            }
            return super.getIsRecordingAudio();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleVideoRecording() {
        Object object = this._videoRecordingLock;
        synchronized (object) {
            super.setIsRecordingVideo(!super.getIsRecordingVideo());
            if (this.getViewSink() != null) {
                this.getViewSink().setIsRecording(super.getIsRecordingVideo() || super.getIsRecordingAudio());
            }
            for (VideoSink sink : this.__videoRecorders) {
                sink.setDisabled(!super.getIsRecordingVideo());
            }
            return super.getIsRecordingVideo();
        }
    }
}

