/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IActionDelegate3;
import fm.icelink.IceCandidate;
import fm.icelink.IceCandidatePair;
import fm.icelink.IceCandidatePairState;
import fm.icelink.IceCandidateType;
import fm.icelink.IceCheckList;
import fm.icelink.IceComponent;
import fm.icelink.IceDatagramSocketManager;
import fm.icelink.IceGatherer;
import fm.icelink.IceGatheringState;
import fm.icelink.IceKeepAlivePolicy;
import fm.icelink.IceLocalRelayedCandidate;
import fm.icelink.IceLocalRelayedCandidateState;
import fm.icelink.IceParameters;
import fm.icelink.IceRole;
import fm.icelink.IceSendMessageArgs;
import fm.icelink.IceSendRequestSuccessArgs;
import fm.icelink.IceTransactionManager;
import fm.icelink.IceTransportOptions;
import fm.icelink.IceTransportState;
import fm.icelink.IceValidList;
import fm.icelink.LocalNetwork;
import fm.icelink.Log;
import fm.icelink.ProtocolType;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.StringExtensions;
import fm.icelink.Transport;
import fm.icelink.TransportAddress;
import fm.icelink.stun.BindingResponse;
import fm.icelink.stun.FingerprintAttribute;
import fm.icelink.stun.Message;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.Utility;
import fm.icelink.stun.XorMappedAddressAttribute;
import java.util.ArrayList;
import java.util.List;

class IceTransport
extends Transport {
    private IceCandidatePair __activeCandidatePair;
    private IceCheckList __checkList;
    private IceComponent __component;
    private ScheduledItem __cpCheckScheduledItem;
    private IceGatherer __gatherer;
    private ArrayList<IceCandidate> __localCandidates;
    private Object __lock;
    private List<IAction2<IceTransport, IceCandidatePair>> __onActiveCandidatePairChange = new ArrayList<IAction2<IceTransport, IceCandidatePair>>();
    private List<IAction1<DataBuffer>> __onReceive = new ArrayList<IAction1<DataBuffer>>();
    private List<IAction1<IceTransport>> __onStateChange = new ArrayList<IAction1<IceTransport>>();
    private ArrayList<IceCandidate> __remoteCandidates;
    private IceParameters __remoteParameters;
    private IceTransport __rtcpTransport = null;
    private Scheduler __scheduler;
    private ArrayList<DataBuffer> __sendQueue;
    private IceTransportState __state;
    private long __tieBreaker;
    private IceTransactionManager __transactionManager;
    private ScheduledItem __transitionToFailedState;
    private IceValidList __validList;
    private boolean _closingShouldNotTriggerGlobalNonGracefulShutdown;
    private Error _error;
    private String _id;
    private IAction2<IceTransport, IceCandidatePair> _onActiveCandidatePairChange = new IAction2<IceTransport, IceCandidatePair>(){

        @Override
        public void invoke(IceTransport p0, IceCandidatePair p1) {
            for (IAction2 action : new ArrayList(IceTransport.this.__onActiveCandidatePairChange)) {
                action.invoke(p0, p1);
            }
        }
    };
    private IAction1<DataBuffer> _onReceive = new IAction1<DataBuffer>(){

        @Override
        public void invoke(DataBuffer p0) {
            for (IAction1 action : new ArrayList(IceTransport.this.__onReceive)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<IceTransport> _onStateChange = new IAction1<IceTransport>(){

        @Override
        public void invoke(IceTransport p0) {
            for (IAction1 action : new ArrayList(IceTransport.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private IceTransportOptions _options;
    private IceRole _role;

    private void addCandidatePair(IceCandidate localCandidate, IceCandidate remoteCandidate) {
        if (Global.equals((Object)LocalNetwork.getAddressType(localCandidate.getIPAddress()), (Object)LocalNetwork.getAddressType(remoteCandidate.getIPAddress())) && Global.equals((Object)localCandidate.getOperatingProtocol(), (Object)remoteCandidate.getOperatingProtocol())) {
            if (this.__remoteParameters != null) {
                remoteCandidate.setUsername(this.__remoteParameters.getUsernameFragment());
                remoteCandidate.setPassword(this.__remoteParameters.getPassword());
            }
            IceCandidatePair pair2 = new IceCandidatePair(this.__lock, localCandidate, remoteCandidate, this.getGatherer().getLocalParameters(), this.getRemoteParameters(), this.getRole(), this.__tieBreaker, this.getComponent(), this.__transactionManager);
            pair2.setKeepAliveInterval(this.getOptions().getKeepAliveInterval());
            IceCandidatePair candidatePair = pair2;
            candidatePair.setOnStateChange((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processCandidatePairStateChange";
                }

                @Override
                public void invoke(IceCandidatePair pair) {
                    IceTransport.this.processCandidatePairStateChange(pair);
                }
            });
            candidatePair.setOnStunResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processStunResponse";
                }

                @Override
                public void invoke(IceSendRequestSuccessArgs e) {
                    IceTransport.this.processStunResponse(e);
                }
            });
            if (candidatePair.getAwaitingOriginalRelayPermissions()) {
                candidatePair.setOnOriginalRelayPermissionsObtained((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceTransport.processGotOriginalRelayPermission";
                    }

                    @Override
                    public void invoke(IceCandidatePair pair) {
                        IceTransport.this.processGotOriginalRelayPermission(pair);
                    }
                });
                this.__checkList.addToAwaitingOriginalRelayPermissionsList(candidatePair);
            } else {
                this.__checkList.addToOrdinaryCheckList(candidatePair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocalCandidate(IceCandidate localCandidate) {
        Object object = this.__lock;
        synchronized (object) {
            if (!this.__localCandidates.contains(localCandidate)) {
                this.__localCandidates.add(localCandidate);
                if (!this.getIsClosed()) {
                    for (IceCandidate candidate : this.__remoteCandidates) {
                        this.addCandidatePair(localCandidate, candidate);
                    }
                }
            }
        }
    }

    public void addOnActiveCandidatePairChange(IAction2<IceTransport, IceCandidatePair> value) {
        this.__onActiveCandidatePairChange.add(value);
    }

    @Override
    public void addOnReceive(IAction1<DataBuffer> value) {
        this.__onReceive.add(value);
    }

    public void addOnStateChange(IAction1<IceTransport> value) {
        this.__onStateChange.add(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteCandidate(IceCandidate remoteCandidate) {
        Object object = this.__lock;
        synchronized (object) {
            if (!this.getIsClosed()) {
                IceCandidate candidate = null;
                for (IceCandidate candidate2 : this.__remoteCandidates) {
                    if (!candidate2.equals(remoteCandidate)) continue;
                    candidate = candidate2;
                }
                if (candidate == null) {
                    this.__remoteCandidates.add(remoteCandidate);
                    for (IceCandidate candidate3 : this.__localCandidates) {
                        this.addCandidatePair(candidate3, remoteCandidate);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCandidatePair(ScheduledItem item) {
        Object object = this.__lock;
        synchronized (object) {
            IceCandidatePair waitingCandidatePair = this.__checkList.getWaitingCandidatePair();
            if (waitingCandidatePair == null) {
                this.__cpCheckScheduledItem.setSuspended(true);
            } else {
                waitingCandidatePair.checkForConnectivity();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceTransport createRtcpTransport() {
        Object object = this.__lock;
        synchronized (object) {
            if (this.__rtcpTransport != null || Global.equals((Object)this.getState(), (Object)IceTransportState.Closed) || Global.equals((Object)this.__component, (Object)IceComponent.Rtcp)) {
                return null;
            }
            IceTransport transport = new IceTransport(this.__lock, this.__scheduler, this.getOptions());
            transport.__component = IceComponent.Rtcp;
            this.__rtcpTransport = transport;
            return this.__rtcpTransport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcessStunResponse(IceSendRequestSuccessArgs e) {
        Object object = this.__lock;
        synchronized (object) {
            IceSendMessageArgs state = (IceSendMessageArgs)e.getItem().getState();
            IceCandidatePair candidatePair = state.getCandidatePair();
            if (!Global.equals(e.getRemoteAddress().getIPAddress(), candidatePair.getRemote().getIPAddress()) || e.getRemoteAddress().getPort() != candidatePair.getRemote().getPort()) {
                candidatePair.setState(IceCandidatePairState.Failed);
                return false;
            }
            MessageIntegrityAttribute messageIntegrity = e.getResponse().getMessageIntegrity();
            if (messageIntegrity == null) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Check discarded from {0} to {1}. Message integrity not found.", candidatePair.getLocal().toString(), candidatePair.getRemote().toString()));
                }
                candidatePair.setState(IceCandidatePairState.Failed);
                return false;
            }
            if (!messageIntegrity.isValid(Utility.createShortTermKey(candidatePair.getRemote().getPassword()))) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Check discarded from {0} to {1}. Message integrity check failed.", candidatePair.getLocal().toString(), candidatePair.getRemote().toString()));
                }
                candidatePair.setState(IceCandidatePairState.Failed);
                return false;
            }
            Error error = IceDatagramSocketManager.validateResponse(state, e.getResponse(), e.getRemoteAddress());
            if (error != null) {
                ErrorCode errorCode = error.getErrorCode();
                if (Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunUnauthorized) || Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunStaleCredentials) || Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunInvalidMessageIntegrity) || Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunMissingUsername) || Global.equals((Object)error.getErrorCode(), (Object)ErrorCode.StunServerError)) {
                    Log.debug(StringExtensions.format("Retrying check from {0} to {1}. {2}", candidatePair.getLocal().getTransportAddress().toString(), candidatePair.getRemote().getTransportAddress().toString(), error.getDescription()));
                    return false;
                }
                Log.debug(StringExtensions.format("Check failed from {0} to {1}: {2}", candidatePair.getLocal().getTransportAddress().toString(), candidatePair.getRemote().getTransportAddress().toString(), error.getDescription()));
                this.__transactionManager.remove(e.getItem(), candidatePair);
                candidatePair.setState(IceCandidatePairState.Failed);
                return false;
            }
            this.__transactionManager.remove(e.getItem(), candidatePair);
            XorMappedAddressAttribute xorMappedAddress = e.getResponse().getXorMappedAddress();
            if (xorMappedAddress == null) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Check discarded from {0} to {1}. XOR-mapped address not found.", candidatePair.getLocal().toString(), candidatePair.getRemote().toString()));
                }
                candidatePair.setState(IceCandidatePairState.Failed);
                return false;
            }
            IceCandidate local = this.__gatherer.findMatchingLocalCandidate(xorMappedAddress.getIPAddress(), xorMappedAddress.getPort());
            if (local == null) {
                int num2;
                if (TransportAddress.isPrivate(xorMappedAddress.getIPAddress()) && e.getRelayed()) {
                    if (Log.getIsWarnEnabled()) {
                        Log.warn(StringExtensions.format("Check discarded from {0} to {1}. Potential peer-reflexive candidate had a private XOR-mapped IP address. (Is the TURN server on the same network as the remote client?)", candidatePair.getLocal().toString(), candidatePair.getRemote().toString()));
                    }
                    candidatePair.setState(IceCandidatePairState.Failed);
                    return false;
                }
                IceCandidate candidate2 = candidatePair.getLocal();
                int num = 2;
                for (num2 = 0; Global.equals((Object)candidate2.getType(), (Object)IceCandidateType.PeerReflexive) && num2 < num; ++num2) {
                    candidate2 = candidate2.getBase();
                }
                if (num2 == num) {
                    Error error2 = new Error(ErrorCode.IcePeerReflexiveError, new Exception("Base of a local peer reflexive candidate is peer reflexive. Cannot create a new peer reflexive candiate."));
                    this.setError(error2);
                    candidatePair.setState(IceCandidatePairState.Failed);
                    this.setState(IceTransportState.Closed);
                    return false;
                }
                String foundation = IceCandidate.generateLocalCandidateFoundation(IceCandidateType.PeerReflexive, xorMappedAddress.getIPAddress(), null, ProtocolType.Udp);
                IceCandidate candidate4 = new IceCandidate(this.__lock, foundation, ProtocolType.Udp, xorMappedAddress.getIPAddress(), xorMappedAddress.getPort(), IceCandidateType.PeerReflexive, candidate2.getIPAddress(), candidate2.getPort());
                candidate4.setBase(candidate2);
                candidate4.setAdapterSpeed(candidate2.getAdapterSpeed());
                IceCandidate candidate = candidate4;
                candidate.setUsername(candidate2.getUsername());
                candidate.setPassword(candidate2.getPassword());
                candidate.setPriority(state.getMessage().getPriority().getPriority());
                local = this.__gatherer.registerLocalPeerReflexiveCandidate(candidate);
                if (Log.getIsDebugEnabled() && Global.equals((Object)local.getType(), (Object)IceCandidateType.PeerReflexive)) {
                    Log.debug(StringExtensions.format("Learned new local peer reflexive candidate {0}.", candidate.toString()));
                }
            }
            IceCandidatePair pair4 = new IceCandidatePair(this.__lock, local, candidatePair.getRemote(), this.__gatherer.getLocalParameters(), this.getRemoteParameters(), this.getRole(), this.__tieBreaker, this.getComponent(), this.__transactionManager);
            pair4.setKeepAliveInterval(this.getOptions().getKeepAliveInterval());
            pair4.setOnStunResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processStunResponse";
                }

                @Override
                public void invoke(IceSendRequestSuccessArgs e) {
                    IceTransport.this.processStunResponse(e);
                }
            });
            pair4.setOnStateChange((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processCandidatePairStateChange";
                }

                @Override
                public void invoke(IceCandidatePair pair) {
                    IceTransport.this.processCandidatePairStateChange(pair);
                }
            });
            IceCandidatePair cp = pair4;
            IceCandidatePair pair3 = null;
            pair3 = this.__checkList.findMatchingCandidatePair(cp);
            if (pair3 != null) {
                cp = pair3;
            } else {
                cp.assignPriority(this.getRole());
                if (Global.equals((Object)cp.getLocal().getType(), (Object)IceCandidateType.Relayed)) {
                    cp.startPermissionRequests();
                }
            }
            cp.setValid(true);
            if (cp.getRelatedValidPair() == null) {
                cp.setRelatedValidPair(cp);
            }
            cp.setState(IceCandidatePairState.Succeeded);
            this.__validList.addCandidatePair(cp);
            candidatePair.setRelatedValidPair(cp);
            candidatePair.setState(IceCandidatePairState.Succeeded);
            if (Global.equals((Object)this.getRole(), (Object)IceRole.Controlling) && state.getMessage().getUseCandidate() != null || Global.equals((Object)this.getRole(), (Object)IceRole.Controlled) && candidatePair.getUseCandidateReceived()) {
                cp.setNominated(true);
                this.processNominatedPair();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSetActiveCandidatePair(IceCandidatePair value) {
        boolean flag = false;
        Object object = this.__lock;
        synchronized (object) {
            if (value == null) {
                this.__activeCandidatePair = null;
                this.setState(IceTransportState.Disconnected);
            } else {
                IceLocalRelayedCandidate local;
                if (Global.equals((Object)value.getState(), (Object)IceCandidatePairState.Closed) || Global.equals((Object)value.getState(), (Object)IceCandidatePairState.Failed)) {
                    return false;
                }
                if (Global.equals((Object)value.getLocal().getType(), (Object)IceCandidateType.Relayed) && (Global.equals((Object)(local = (IceLocalRelayedCandidate)value.getLocal()).getRelayState(), (Object)IceLocalRelayedCandidateState.Closed) || Global.equals((Object)local.getRelayState(), (Object)IceLocalRelayedCandidateState.Closing) || Global.equals((Object)local.getRelayState(), (Object)IceLocalRelayedCandidateState.Failed))) {
                    return false;
                }
                if (this.__activeCandidatePair != null && !this.__activeCandidatePair.equals(value) || this.__activeCandidatePair == null) {
                    this.__activeCandidatePair = value;
                    flag = true;
                    ScheduledItem stopCandidatePair = this.__activeCandidatePair.getStopCandidatePair();
                    if (stopCandidatePair != null) {
                        this.__scheduler.remove(stopCandidatePair);
                        this.__activeCandidatePair.setStopCandidatePair(null);
                    }
                    Log.debug(StringExtensions.format("Setting new active candidate pair: {0}", this.__activeCandidatePair.toString()));
                }
            }
            if (flag) {
                IAction2<IceTransport, IceCandidatePair> onActiveCandidatePairChange = this._onActiveCandidatePairChange;
                if (onActiveCandidatePairChange != null) {
                    onActiveCandidatePairChange.invoke(this, value);
                }
                this.processCandidatePairStateChange(this.__activeCandidatePair);
            }
            this.stopNonActivePairs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceCandidate findMatchingRemoteCandidate(String ipAddress, int port) {
        Object object = this.__lock;
        synchronized (object) {
            for (IceCandidate candidate : this.__remoteCandidates) {
                if (!Global.equals(candidate.getIPAddress(), ipAddress) || candidate.getPort() != port) continue;
                return candidate;
            }
            return null;
        }
    }

    IceCandidatePair getActiveCandidatePair() {
        return this.__activeCandidatePair;
    }

    public boolean getClosingShouldNotTriggerGlobalNonGracefulShutdown() {
        return this._closingShouldNotTriggerGlobalNonGracefulShutdown;
    }

    public IceComponent getComponent() {
        return this.__component;
    }

    public Error getError() {
        return this._error;
    }

    public IceGatherer getGatherer() {
        return this.__gatherer;
    }

    public String getId() {
        return this._id;
    }

    @Override
    public boolean getIsClosed() {
        return Global.equals((Object)this.getState(), (Object)IceTransportState.Closed);
    }

    IceTransportOptions getOptions() {
        return this._options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceCandidate[] getRemoteCandidates() {
        Object object = this.__lock;
        synchronized (object) {
            return this.__remoteCandidates.toArray(new IceCandidate[0]);
        }
    }

    public IceParameters getRemoteParameters() {
        return this.__remoteParameters;
    }

    public IceRole getRole() {
        return this._role;
    }

    public IceTransportState getState() {
        return this.__state;
    }

    public IceTransport(Object lockObject, Scheduler scheduler, IceTransportOptions options) {
        this.__remoteCandidates = new ArrayList();
        this.__localCandidates = new ArrayList();
        this.__sendQueue = new ArrayList();
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.__lock = lockObject;
        this.__checkList = new IceCheckList(this.__lock);
        this.__validList = new IceValidList(this.__lock);
        this.__scheduler = scheduler;
        this.__state = IceTransportState.New;
        this.__component = IceComponent.Rtp;
        this.__gatherer = null;
        this.__remoteParameters = null;
        this.setRole(IceRole.Controlling);
        this.__activeCandidatePair = null;
        this.setOptions(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCandidatePairStateChange(IceCandidatePair pair) {
        if (!Global.equals((Object)this.getState(), (Object)IceTransportState.New) && !Global.equals((Object)this.getState(), (Object)IceTransportState.Closed)) {
            Object object = this.__lock;
            synchronized (object) {
                if (!Global.equals((Object)this.getState(), (Object)IceTransportState.New) && !Global.equals((Object)this.getState(), (Object)IceTransportState.Closed) && pair != null) {
                    IceCandidatePairState state = pair.getState();
                    IceCandidatePairState _var0 = state;
                    if (_var0 == IceCandidatePairState.Succeeded) {
                        if (Global.equals((Object)this.getState(), (Object)IceTransportState.Checking)) {
                            this.setState(IceTransportState.Connected);
                        }
                        return;
                    }
                    if (_var0 == IceCandidatePairState.InProgress) {
                        if (this.__checkList.getAtLeastOneCandidatePairSucceeded()) {
                            this.setState(IceTransportState.Connected);
                        } else {
                            this.setState(IceTransportState.Checking);
                        }
                        return;
                    }
                    if (_var0 == IceCandidatePairState.Failed) {
                        if (Global.equals(this.getActiveCandidatePair(), pair)) {
                            this.updateActivePair();
                        }
                        if (this.__checkList.getConnectivityChecksCompletedAndNoneSucceeded()) {
                            this.setState(IceTransportState.Disconnected);
                        }
                        return;
                    }
                    if (_var0 == IceCandidatePairState.ConnectivityLost) {
                        if (Global.equals(this.getActiveCandidatePair(), pair)) {
                            this.updateActivePair();
                        }
                        return;
                    }
                    if (_var0 == IceCandidatePairState.Closed) {
                        this.updateActivePair();
                        if (this.__checkList.getConnectivityChecksCompletedAndNoneSucceeded()) {
                            this.setState(IceTransportState.Failed);
                        }
                        return;
                    }
                    if (Global.equals((Object)state, (Object)IceCandidatePairState.Waiting)) {
                        this.__cpCheckScheduledItem.setSuspended(false);
                        if (this.__checkList.getAtLeastOneCandidatePairSucceeded()) {
                            this.setState(IceTransportState.Connected);
                        } else {
                            this.setState(IceTransportState.Checking);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGotOriginalRelayPermission(IceCandidatePair pair) {
        Object object = this.__lock;
        synchronized (object) {
            this.__checkList.processGotOriginalRelayPermission(pair);
        }
    }

    private void processIncomingApplicationData(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
        if (this.getActiveCandidatePair() != null) {
            IAction1<DataBuffer> onReceive;
            IceCandidatePair pair2 = null;
            IceCandidate remote = this.findMatchingRemoteCandidate(remoteAddress.getIPAddress(), remoteAddress.getPort());
            if (remote != null) {
                pair2 = this.__validList.findMatchingCandidatePair(localCandidate, remote);
                if (pair2 == null) {
                    pair2 = this.__checkList.findMatchingCandidatePair(localCandidate, remote);
                }
                if (pair2 != null) {
                    pair2.notifyDataReceived();
                }
            } else if (!Global.equals((Object)this.getState(), (Object)IceTransportState.Closed) && !Global.equals((Object)this.getState(), (Object)IceTransportState.Failed)) {
                Log.debug(StringExtensions.format("Receiving data from an unknown remote candidate {0}", remoteAddress.toString()));
            }
            if ((onReceive = this._onReceive) != null) {
                onReceive.invoke(data);
            }
        }
    }

    private void processLocalCandidate(IceGatherer gatherer, IceCandidate localCandidate) {
        this.addLocalCandidate(localCandidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNominatedPair() {
        IceCandidatePair nominatedPairWithHighestPriority = this.__validList.getNominatedPairWithHighestPriority();
        Object object = this.__lock;
        synchronized (object) {
            if (!this.getIsClosed() || nominatedPairWithHighestPriority == null) {
                this.setActiveCandidatePair(nominatedPairWithHighestPriority);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStunRequest(Message message, IceCandidate localCandidate, TransportAddress remoteAddress) {
        if (this.getIsClosed() || this.__gatherer == null) {
            return;
        }
        IceParameters localParameters = this.__gatherer.getLocalParameters();
        IceParameters remoteParameters = this.getRemoteParameters();
        if (remoteParameters != null) {
            UsernameAttribute username = message.getUsername();
            if (username == null) {
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("Ignoring request from {0}. Username required.", remoteAddress.toString()));
                }
            } else {
                String str = StringExtensions.format("{0}:{1}", localParameters.getUsernameFragment(), remoteParameters.getUsernameFragment());
                if (!Global.equals(username.getValue(), str)) {
                    if (Log.getIsDebugEnabled()) {
                        Log.debug(StringExtensions.format("Ignoring request from {0}. Username '{1}' does not match expected value '{2}'.", remoteAddress.toString(), username.getValue(), str));
                    }
                } else if (!message.getMessageIntegrity().isValid(Utility.createShortTermKey(localParameters.getPassword()))) {
                    if (Log.getIsDebugEnabled()) {
                        Log.debug(StringExtensions.format("Ignoring request from {0}. Message integrity check failed.", remoteAddress.toString()));
                    }
                } else {
                    Object object;
                    Object obj2;
                    BindingResponse response = new BindingResponse(message.getTransactionId(), true);
                    response.setXorMappedAddress(new XorMappedAddressAttribute(remoteAddress.getIPAddress(), remoteAddress.getPort(), message.getTransactionId()));
                    response.setMessageIntegrity(new MessageIntegrityAttribute(Utility.createShortTermKey(localParameters.getPassword())));
                    response.setFingerprint(new FingerprintAttribute());
                    TransportAddress turnServer = null;
                    if (Global.equals((Object)localCandidate.getType(), (Object)IceCandidateType.Relayed)) {
                        turnServer = ((IceLocalRelayedCandidate)localCandidate).getTurnServer();
                    }
                    IceSendMessageArgs args2 = new IceSendMessageArgs(response, remoteAddress);
                    args2.setTurnRelay(turnServer);
                    IceSendMessageArgs args = args2;
                    localCandidate.sendStunMessage(args);
                    IceCandidate remote = this.findMatchingRemoteCandidate(remoteAddress.getIPAddress(), remoteAddress.getPort());
                    if (remote == null) {
                        if (TransportAddress.isPrivate(remoteAddress.getIPAddress()) && Global.equals((Object)localCandidate.getType(), (Object)IceCandidateType.Relayed)) {
                            if (Log.getIsWarnEnabled()) {
                                Log.warn(StringExtensions.format("Check request discarded from {0} to {1}. Potential peer-reflexive candidate had a private IP address. (Is the TURN server on the same network as the local client?)", remoteAddress.toString(), localCandidate.toString()));
                            }
                            return;
                        }
                        String foundation = "";
                        boolean flag = false;
                        object = obj2 = this.__lock;
                        synchronized (object) {
                            while (!flag) {
                                flag = true;
                                foundation = Guid.newGuid().toString().replace("-", "");
                                for (IceCandidate candidate2 : this.__remoteCandidates) {
                                    if (!Global.equals(candidate2.getFoundation(), foundation)) continue;
                                    flag = false;
                                }
                            }
                            IceCandidate candidate4 = new IceCandidate(this.__lock, foundation, ProtocolType.Udp, remoteAddress.getIPAddress(), remoteAddress.getPort(), IceCandidateType.PeerReflexive, localCandidate.getIPAddress(), localCandidate.getPort());
                            candidate4.setBase(localCandidate);
                            IceCandidate item = candidate4;
                            item.setPriority(message.getPriority().getPriority());
                            item.setUsername(remoteParameters.getUsernameFragment());
                            item.setPassword(remoteParameters.getPassword());
                            if (Log.getIsDebugEnabled()) {
                                Log.debug(StringExtensions.format("Learned new remote peer reflexive candidate {0}.", item.toString()));
                            }
                            this.__remoteCandidates.add(item);
                            remote = item;
                        }
                    }
                    IceCandidatePair pair2 = new IceCandidatePair(this.__lock, localCandidate, remote, localParameters, remoteParameters, this.getRole(), this.__tieBreaker, this.getComponent(), this.__transactionManager);
                    pair2.setKeepAliveInterval(this.getOptions().getKeepAliveInterval());
                    pair2.setState(IceCandidatePairState.New);
                    IceCandidatePair pair = pair2;
                    pair.notifyDataReceived();
                    pair.setOnStunResponse((IAction1<IceSendRequestSuccessArgs>)new IActionDelegate1<IceSendRequestSuccessArgs>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceTransport.processStunResponse";
                        }

                        @Override
                        public void invoke(IceSendRequestSuccessArgs e) {
                            IceTransport.this.processStunResponse(e);
                        }
                    });
                    pair.setOnStateChange((IAction1<IceCandidatePair>)new IActionDelegate1<IceCandidatePair>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.IceTransport.processCandidatePairStateChange";
                        }

                        @Override
                        public void invoke(IceCandidatePair pair) {
                            IceTransport.this.processCandidatePairStateChange(pair);
                        }
                    });
                    object = obj2 = this.__lock;
                    synchronized (object) {
                        Holder<IceCandidatePair> _var0 = new Holder<IceCandidatePair>(pair);
                        this.__checkList.addToTriggeredCheckList(_var0);
                        pair = _var0.getValue();
                    }
                    if (Global.equals((Object)this.getRole(), (Object)IceRole.Controlled) && message.getUseCandidate() != null) {
                        if (Global.equals((Object)pair.getState(), (Object)IceCandidatePairState.Succeeded)) {
                            pair.getRelatedValidPair().setNominated(true);
                            this.processNominatedPair();
                        } else {
                            pair.setUseCandidateReceived(true);
                        }
                    }
                }
            }
        }
    }

    private void processStunResponse(IceSendRequestSuccessArgs e) {
        this.doProcessStunResponse(e);
    }

    private void raiseStateChange() {
        IAction1<IceTransport> onStateChange = this._onStateChange;
        if (onStateChange != null) {
            onStateChange.invoke(this);
        }
    }

    public void removeOnActiveCandidatePairChange(IAction2<IceTransport, IceCandidatePair> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onActiveCandidatePairChange, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onActiveCandidatePairChange.remove(value);
    }

    @Override
    public void removeOnReceive(IAction1<DataBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceive, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceive.remove(value);
    }

    public void removeOnStateChange(IAction1<IceTransport> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRtcpTransport() {
        Object object = this.__lock;
        synchronized (object) {
            this.__rtcpTransport = null;
        }
    }

    @Override
    public void send(DataBuffer buffer) {
        IceCandidatePair activeCandidatePair = this.getActiveCandidatePair();
        if (activeCandidatePair != null) {
            try {
                activeCandidatePair.send(buffer);
            }
            catch (Exception exception) {
                Error error = new Error(ErrorCode.IceSendError);
                error.setException(exception);
                this.setError(error);
            }
        }
    }

    private void setActiveCandidatePair(IceCandidatePair value) {
        this.doSetActiveCandidatePair(value);
    }

    public void setClosingShouldNotTriggerGlobalNonGracefulShutdown(boolean value) {
        this._closingShouldNotTriggerGlobalNonGracefulShutdown = value;
    }

    private void setError(Error value) {
        this._error = value;
    }

    private void setId(String value) {
        this._id = value;
    }

    void setOptions(IceTransportOptions value) {
        this._options = value;
    }

    private void setRole(IceRole value) {
        this._role = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(IceTransportState value) {
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                Scheduler scheduler;
                boolean flag = false;
                if (Global.equals((Object)this.__state, (Object)IceTransportState.Closed)) {
                    flag = true;
                } else if (Global.equals((Object)value, (Object)IceTransportState.Connected)) {
                    scheduler = this.__scheduler;
                    if (this.__transitionToFailedState != null && scheduler != null) {
                        scheduler.remove(this.__transitionToFailedState);
                    }
                    if (this.__activeCandidatePair == null) {
                        flag = true;
                    }
                }
                if (!flag) {
                    this.__state = value;
                    if (Global.equals((Object)this.__state, (Object)IceTransportState.Connected) && ArrayListExtensions.getCount(this.__sendQueue) > 0) {
                        for (DataBuffer buffer : this.__sendQueue) {
                            this.send(buffer);
                        }
                        this.__sendQueue.clear();
                    }
                    this.raiseStateChange();
                    if (Global.equals((Object)value, (Object)IceTransportState.Disconnected) && (scheduler = this.__scheduler) != null) {
                        int delay = this.getOptions() == null ? 0 : (this.getOptions().getDeadStreamTimeout() < 0 ? 0 : this.getOptions().getDeadStreamTimeout());
                        this.__transitionToFailedState = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.IceTransport.transitionToFailedStateOnDeadStreamTimeout";
                            }

                            @Override
                            public void invoke(ScheduledItem item) {
                                IceTransport.this.transitionToFailedStateOnDeadStreamTimeout(item);
                            }
                        }, delay, delay, ScheduledItem.getUnset(), 1);
                        scheduler.add(this.__transitionToFailedState);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(IceGatherer gatherer, IceParameters remoteParameters, IceRole role, long tieBreaker) {
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)IceTransportState.New) && !Global.equals((Object)this.getState(), (Object)IceTransportState.Closed)) {
                return false;
            }
            if (Global.equals((Object)gatherer.getState(), (Object)IceGatheringState.Closed)) {
                throw new RuntimeException(new Exception("Cannot start Ice Transport: supplied gatherer is in an invalid state."));
            }
            if (!Global.equals((Object)gatherer.getComponent(), (Object)this.getComponent())) {
                Log.error("Components do not match.");
                return false;
            }
            this.__cpCheckScheduledItem = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.checkCandidatePair";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    IceTransport.this.checkCandidatePair(item);
                }
            }, 0, 20, ScheduledItem.getUnset(), ScheduledItem.getUnset());
            this.__scheduler.add(this.__cpCheckScheduledItem);
            this.__transactionManager = gatherer.getTransactionManager();
            this.setState(IceTransportState.Checking);
            this.__gatherer = gatherer;
            this.__remoteParameters = remoteParameters;
            this.setRole(role);
            this.__tieBreaker = tieBreaker;
            this.__gatherer.removeOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processLocalCandidate";
                }

                @Override
                public void invoke(IceGatherer gatherer, IceCandidate localCandidate) {
                    IceTransport.this.processLocalCandidate(gatherer, localCandidate);
                }
            });
            this.__gatherer.addOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processLocalCandidate";
                }

                @Override
                public void invoke(IceGatherer gatherer, IceCandidate localCandidate) {
                    IceTransport.this.processLocalCandidate(gatherer, localCandidate);
                }
            });
            this.__gatherer.removeOnIncomingApplicationData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processIncomingApplicationData";
                }

                @Override
                public void invoke(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
                    IceTransport.this.processIncomingApplicationData(data, localCandidate, remoteAddress);
                }
            });
            this.__gatherer.addOnIncomingApplicationData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processIncomingApplicationData";
                }

                @Override
                public void invoke(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
                    IceTransport.this.processIncomingApplicationData(data, localCandidate, remoteAddress);
                }
            });
            this.__gatherer.setOnStunRequest((IAction3<Message, IceCandidate, TransportAddress>)new IActionDelegate3<Message, IceCandidate, TransportAddress>(){

                @Override
                public String getId() {
                    return "fm.icelink.IceTransport.processStunRequest";
                }

                @Override
                public void invoke(Message message, IceCandidate localCandidate, TransportAddress remoteAddress) {
                    IceTransport.this.processStunRequest(message, localCandidate, remoteAddress);
                }
            });
            for (IceCandidate candidate : this.__gatherer.getLocalCandidates()) {
                this.addLocalCandidate(candidate);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Object object = this.__lock;
        synchronized (object) {
            if (!(Global.equals((Object)this.getState(), (Object)IceTransportState.New) || Global.equals((Object)this.getState(), (Object)IceTransportState.Checking) || Global.equals((Object)this.getState(), (Object)IceTransportState.Failed) || Global.equals((Object)this.getState(), (Object)IceTransportState.Connected) || Global.equals((Object)this.getState(), (Object)IceTransportState.Disconnected))) {
                return false;
            }
            this.removeRtcpTransport();
            if (this.__transactionManager != null) {
                this.__transactionManager.remove(this);
            }
            this.removeRtcpTransport();
            this.__sendQueue.clear();
            this.__localCandidates.clear();
            this.__remoteCandidates.clear();
            this.__validList.clear();
            this.__checkList.clear();
            IceGatherer gatherer = this.__gatherer;
            if (gatherer != null) {
                gatherer.removeOnIncomingApplicationData((IAction3<DataBuffer, IceCandidate, TransportAddress>)new IActionDelegate3<DataBuffer, IceCandidate, TransportAddress>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceTransport.processIncomingApplicationData";
                    }

                    @Override
                    public void invoke(DataBuffer data, IceCandidate localCandidate, TransportAddress remoteAddress) {
                        IceTransport.this.processIncomingApplicationData(data, localCandidate, remoteAddress);
                    }
                });
                gatherer.removeOnLocalCandidate((IAction2<IceGatherer, IceCandidate>)new IActionDelegate2<IceGatherer, IceCandidate>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.IceTransport.processLocalCandidate";
                    }

                    @Override
                    public void invoke(IceGatherer gatherer, IceCandidate localCandidate) {
                        IceTransport.this.processLocalCandidate(gatherer, localCandidate);
                    }
                });
                this.__gatherer = null;
            }
            this.__remoteParameters = null;
            if (!Global.equals((Object)this.getState(), (Object)IceTransportState.Failed)) {
                this.setState(IceTransportState.Closed);
            }
            return true;
        }
    }

    private void stopNonActivePair(final IceCandidatePair pair) {
        IAction1<ScheduledItem> defaultCallback = null;
        if (!pair.equals(this.getActiveCandidatePair())) {
            if (this.getActiveCandidatePair() == null || this.getActiveCandidatePair().getPriority() > pair.getPriority()) {
                pair.stop();
            } else if (pair.getStopCandidatePair() == null && Global.equals((Object)pair.getState(), (Object)IceCandidatePairState.Succeeded)) {
                if (defaultCallback == null) {
                    defaultCallback = new IAction1<ScheduledItem>(){

                        @Override
                        public void invoke(ScheduledItem unused) {
                            pair.stop();
                        }
                    };
                }
                ScheduledItem item = new ScheduledItem(defaultCallback, 5000, ScheduledItem.getUnset(), ScheduledItem.getUnset(), 1);
                pair.setStopCandidatePair(item);
                if (this.__scheduler != null) {
                    this.__scheduler.add(item);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopNonActivePairs() {
        if (Global.equals((Object)this.getOptions().getKeepAlivePolicy(), (Object)IceKeepAlivePolicy.ActiveOnly)) {
            Object object = this.__lock;
            synchronized (object) {
                for (IceCandidatePair pair : this.__validList.getCandidatePairs()) {
                    this.stopNonActivePair(pair);
                }
            }
        }
    }

    private void transitionToFailedStateOnDeadStreamTimeout(ScheduledItem item) {
        Scheduler scheduler = this.__scheduler;
        if (scheduler != null) {
            scheduler.remove(item);
        }
        this.setError(new Error(ErrorCode.ConnectionDeadStream));
        this.setState(IceTransportState.Failed);
    }

    private void updateActivePair() {
        this.processNominatedPair();
    }
}

