/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1ArrayOf;
import fm.icelink.BooleanHolder;
import fm.icelink.ByteCollection;
import fm.icelink.CompareResult;
import fm.icelink.IFunctionDelegate2;
import fm.icelink.IntegerHolder;
import fm.icelink.MathAssistant;
import fm.icelink.Sort;
import java.util.ArrayList;

class Asn1SetOf<T extends Asn1Any>
extends Asn1ArrayOf<T> {
    public Asn1SetOf(T[] values) {
        super.setValues(values);
    }

    public Asn1SetOf() {
    }

    private CompareResult compareByteArrays(byte[] byteArray1, byte[] byteArray2) {
        if (byteArray1 == null) {
            return CompareResult.Negative;
        }
        if (byteArray2 == null) {
            return CompareResult.Positive;
        }
        for (int i = 0; i < MathAssistant.min(ArrayExtensions.getLength(byteArray1), ArrayExtensions.getLength(byteArray2)); ++i) {
            byte num2 = byteArray1[i];
            byte num3 = byteArray2[i];
            if (num2 < num3) {
                return CompareResult.Negative;
            }
            if (num2 <= num3) continue;
            return CompareResult.Positive;
        }
        if (ArrayExtensions.getLength(byteArray1) < ArrayExtensions.getLength(byteArray2)) {
            return CompareResult.Negative;
        }
        if (ArrayExtensions.getLength(byteArray1) > ArrayExtensions.getLength(byteArray2)) {
            return CompareResult.Positive;
        }
        return CompareResult.Equal;
    }

    @Override
    public byte[] getContents() {
        ArrayList<byte[]> array = new ArrayList<byte[]>();
        for (Asn1Any local : super.getValues()) {
            array.add(local.getBytes());
        }
        Sort.quickSort(array, new IFunctionDelegate2<byte[], byte[], CompareResult>(){

            @Override
            public String getId() {
                return "fm.icelink.Asn1SetOf<T>.compareByteArrays";
            }

            @Override
            public CompareResult invoke(byte[] byteArray1, byte[] byteArray2) {
                return Asn1SetOf.this.compareByteArrays(byteArray1, byteArray2);
            }
        });
        ByteCollection bytes = new ByteCollection();
        for (byte[] buffer : array) {
            bytes.addRange(buffer);
        }
        return bytes.toArray();
    }

    @Override
    public void getProperties(IntegerHolder tag, IntegerHolder klass, BooleanHolder isConstructed, BooleanHolder isIndefinite) {
        tag.setValue(17);
        klass.setValue(0);
        isConstructed.setValue(true);
        isIndefinite.setValue(false);
    }
}

