/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import fm.icelink.DataBuffer;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IVideoSource;
import fm.icelink.Log;
import fm.icelink.ManagedCondition;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFrame;
import fm.icelink.PliControlFrame;
import fm.icelink.RRControlFrame;
import fm.icelink.ReportBlock;
import fm.icelink.Utility;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoEncoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.android.MediaCodecUtility;
import java.nio.ByteBuffer;
import java.util.Locale;

public class MediaCodecEncoder
extends VideoEncoder {
    private MediaCodec _encoder;
    private long _currentSynchronizationSource;
    private int _losslessCount;
    private int _lossyCount;
    private int _bitrate;
    private int _currentWidth;
    private int _currentHeight;
    private int _currentBitrate;
    private String _mimeType;
    private int _colorFormat;
    private MediaCodecInfo _encoderInfo;
    private boolean _forceKeyFrame;
    private static final int _infinite = -1;
    private MediaCodec.BufferInfo _outputBufferInfo = new MediaCodec.BufferInfo();
    private long _startNanos = 0L;
    private DataBuffer _lastSpsBuffer = null;
    private DataBuffer _lastPpsBuffer = null;
    private volatile boolean _encoding = false;
    private Object _stateLock = new Object();
    private ManagedThread _thread;
    private ManagedCondition _condition;

    public int getBitrate() {
        return this._bitrate;
    }

    public void setBitrate(int bitrate) {
        this._bitrate = bitrate;
    }

    public boolean getForceKeyFrame() {
        return this._forceKeyFrame;
    }

    public void setForceKeyFrame(boolean value) {
        this._forceKeyFrame = value;
    }

    public MediaCodecEncoder(MediaCodecInfo encoderInfo, VideoFormat inputFormat, VideoFormat outputFormat) {
        super(inputFormat, outputFormat);
        this.initialize(encoderInfo, inputFormat, outputFormat);
    }

    public MediaCodecEncoder(MediaCodecInfo encoderInfo, IVideoSource source, VideoFormat outputFormat) {
        super((VideoFormat)source.getOutputFormat(), outputFormat);
        this.initialize(encoderInfo, (VideoFormat)source.getOutputFormat(), outputFormat);
    }

    private void initialize(MediaCodecInfo encoderInfo, VideoFormat inputFormat, VideoFormat outputFormat) {
        if (Build.VERSION.SDK_INT < 19) {
            throw new RuntimeException("Android 4.4 or higher is required to use hardware encoding.");
        }
        this._bitrate = 320;
        this._encoderInfo = encoderInfo;
        if (!this._encoderInfo.isEncoder()) {
            throw new RuntimeException("encoderInfo is not a valid encoder");
        }
        this._mimeType = MediaCodecUtility.getMimeType(outputFormat);
        if (this._mimeType == null) {
            throw new RuntimeException("Invalid input format " + outputFormat.getName());
        }
        if (!MediaCodecUtility.hasMimeType(this._encoderInfo, this._mimeType)) {
            throw new RuntimeException("Invalid input format " + inputFormat.getName() + " and respective mime type " + this._mimeType + " for this encoderInfo");
        }
        this._colorFormat = MediaCodecUtility.getColorFormat(inputFormat);
        if (this._colorFormat < 0 || !MediaCodecUtility.hasColorFormat(this._encoderInfo, this._mimeType, this._colorFormat)) {
            throw new RuntimeException("Invalid output format " + inputFormat.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDestroy() {
        Object object = this._stateLock;
        synchronized (object) {
            this._encoding = false;
            this._condition.pulse();
        }
        if (this._encoder != null) {
            this._encoder.stop();
            this._encoder.release();
            this._encoder = null;
        }
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        this._currentSynchronizationSource = frame.getSynchronizationSource();
        this.encode(inputBuffer, (VideoFormat)this.getOutputFormat());
    }

    public String getLabel() {
        return "MediaCodecEncoder";
    }

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
        for (MediaControlFrame frame : controlFrames) {
            ReportBlock reportBlock;
            if (frame instanceof PliControlFrame) {
                this.setForceKeyFrame(true);
                continue;
            }
            if (!(frame instanceof RRControlFrame) || (reportBlock = ((RRControlFrame)frame).getReportBlock(this._currentSynchronizationSource)) == null) continue;
            if (reportBlock.getSynchronizationSource() == this._currentSynchronizationSource) {
                Log.debug((String)String.format(Locale.getDefault(), "Video encoder report: %s packet loss (%d cumulative packets lost)", Utility.formatDoubleAsPercent((double)reportBlock.getPercentLost(), (int)2), reportBlock.getCumulativeNumberOfPacketsLost()));
                if (reportBlock.getFractionLost() <= 0) continue;
                this._losslessCount = 0;
                ++this._lossyCount;
                if (this._lossyCount <= 5 || this.getBitrate() <= 64) continue;
                this._lossyCount = 0;
                if (this.getBitrate() <= 64) continue;
                this.setBitrate(MathAssistant.max((int)64, (int)(this.getBitrate() - 64)));
                Log.info((String)String.format(Locale.getDefault(), "Decreasing video encoder bitrate to %d.", this.getBitrate()));
                continue;
            }
            this._lossyCount = 0;
            ++this._losslessCount;
            if (this._losslessCount <= 5 || this.getBitrate() >= 640) continue;
            this._losslessCount = 0;
            if (this.getBitrate() >= 640) continue;
            this.setBitrate(MathAssistant.min((int)640, (int)(this.getBitrate() + 64)));
            Log.info((String)String.format(Locale.getDefault(), "Increasing video encoder bitrate to %d.", this.getBitrate()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMediaCodec(int width, int height) throws Exception {
        MediaFormat format = MediaFormat.createVideoFormat((String)this._mimeType, (int)width, (int)height);
        this._encoder = MediaCodec.createByCodecName((String)this._encoderInfo.getName());
        format.setInteger("bitrate", this._bitrate * 1024);
        format.setInteger("color-format", this._colorFormat);
        format.setInteger("frame-rate", 30);
        format.setInteger("i-frame-interval", 1800);
        format.setInteger("stride", width);
        format.setInteger("slice-height", height);
        this._currentWidth = width;
        this._currentHeight = height;
        this._currentBitrate = this._bitrate;
        this._encoder.configure(format, null, null, 1);
        this._encoder.start();
        Object object = this._stateLock;
        synchronized (object) {
            this._encoding = true;
        }
        this._condition = new ManagedCondition();
        this._thread = new ManagedThread((IAction1)new IActionDelegate1<ManagedThread>(){

            public String getId() {
                return "fm.icelink.android.MediaCodecEncoder.loop";
            }

            public void invoke(ManagedThread thread) {
                MediaCodecEncoder.this.loop(thread);
            }
        });
        this._thread.start();
    }

    @SuppressLint(value={"NewApi"})
    public void encode(VideoBuffer inputBuffer, VideoFormat outputFormat) {
        try {
            if (this._encoder != null && (inputBuffer.getWidth() != this._currentWidth || inputBuffer.getHeight() != this._currentHeight || this._bitrate != this._currentBitrate)) {
                this._encoder.stop();
                this._encoder.release();
                this._encoder = null;
            }
            this._currentWidth = inputBuffer.getWidth();
            this._currentHeight = inputBuffer.getHeight();
            this._currentBitrate = this._bitrate;
            if (this._encoder == null) {
                this.initializeMediaCodec(this._currentWidth, this._currentHeight);
                this._forceKeyFrame = true;
            }
            if (this._forceKeyFrame) {
                Bundle b = new Bundle();
                b.putInt("request-sync", 0);
                this._encoder.setParameters(b);
            }
            DataBuffer[] buffers = inputBuffer.getDataBuffers();
            this.queueFrame(buffers);
        }
        catch (Exception e) {
            if (this._encoder != null) {
                this._encoder.stop();
                this._encoder.release();
                this._encoder = null;
            }
            Log.error((String)("MediaCodec encode failed for " + this._mimeType + " \n" + e.getMessage()));
        }
    }

    @SuppressLint(value={"NewApi"})
    private void queueFrame(DataBuffer[] planes) {
        int inputBufferIndex = -1;
        while (inputBufferIndex < 0) {
            inputBufferIndex = this._encoder.dequeueInputBuffer(-1L);
        }
        ByteBuffer inputBuffer = Build.VERSION.SDK_INT < 21 ? this._encoder.getInputBuffers()[inputBufferIndex] : this._encoder.getInputBuffer(inputBufferIndex);
        int lengthSum = 0;
        for (DataBuffer plane : planes) {
            lengthSum += plane.getLength();
        }
        inputBuffer.position(0);
        inputBuffer.limit(lengthSum);
        for (DataBuffer plane : planes) {
            inputBuffer.put(plane.toArray());
        }
        inputBuffer.position(0);
        long timestampMicros = 0L;
        if (this._startNanos == 0L) {
            this._startNanos = System.nanoTime();
        } else {
            timestampMicros = (System.nanoTime() - this._startNanos) / 1000L / 33333L * 33333L;
        }
        this._encoder.queueInputBuffer(inputBufferIndex, 0, lengthSum, timestampMicros, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void loop(ManagedThread thread) {
        while (this._encoding) {
            thread.loopBegin();
            int outputBufferIndex = this._encoder.dequeueOutputBuffer(this._outputBufferInfo, 0L);
            if (outputBufferIndex >= 0) {
                DataBuffer encodedFrame = null;
                Object object = this._stateLock;
                synchronized (object) {
                    ByteBuffer outputBuffer = Build.VERSION.SDK_INT < 21 ? this._encoder.getOutputBuffers()[outputBufferIndex] : this._encoder.getOutputBuffer(outputBufferIndex);
                    outputBuffer.position(this._outputBufferInfo.offset);
                    outputBuffer.limit(this._outputBufferInfo.offset + this._outputBufferInfo.size);
                    encodedFrame = DataBuffer.allocate((int)this._outputBufferInfo.size);
                    outputBuffer.get(encodedFrame.getData());
                    this._encoder.releaseOutputBuffer(outputBufferIndex, false);
                    boolean isH264 = ((VideoFormat)this.getOutputFormat()).getName().equals(VideoFormat.getH264Name());
                    boolean isVp8 = ((VideoFormat)this.getOutputFormat()).getName().equals(VideoFormat.getVp8Name());
                    boolean isVp9 = ((VideoFormat)this.getOutputFormat()).getName().equals(VideoFormat.getVp9Name());
                    boolean outputIsKeyframe = false;
                    if (isVp8) {
                        outputIsKeyframe = fm.icelink.vp8.Utility.isKeyFrame((DataBuffer)encodedFrame);
                    } else if (isVp9) {
                        outputIsKeyframe = fm.icelink.vp8.Utility.isKeyFrame((DataBuffer)encodedFrame);
                    } else if (isH264) {
                        outputIsKeyframe = fm.icelink.h264.Utility.isKeyFrame((DataBuffer)encodedFrame);
                    } else if (Build.VERSION.SDK_INT >= 21) {
                        outputIsKeyframe = (this._outputBufferInfo.flags & 1) > 0;
                    } else {
                        boolean bl = outputIsKeyframe = (this._outputBufferInfo.flags & 1) > 0;
                    }
                    if (this._forceKeyFrame && !outputIsKeyframe) {
                        continue;
                    }
                    if (isH264 && outputIsKeyframe) {
                        Log.debug((String)"Encoder generated keyframe.");
                        if (fm.icelink.h264.Utility.isSps((DataBuffer)encodedFrame)) {
                            this._lastSpsBuffer = encodedFrame;
                        } else if (fm.icelink.h264.Utility.isPps((DataBuffer)encodedFrame)) {
                            this._lastPpsBuffer = encodedFrame;
                        } else if (fm.icelink.h264.Utility.isIdr((DataBuffer)encodedFrame)) {
                            int encodedFrameLength = encodedFrame.getLength();
                            if (this._lastSpsBuffer != null) {
                                encodedFrameLength += this._lastSpsBuffer.getLength();
                            }
                            if (this._lastPpsBuffer != null) {
                                encodedFrameLength += this._lastPpsBuffer.getLength();
                            }
                            if (encodedFrameLength != encodedFrame.getLength()) {
                                DataBuffer newEncodedFrame = DataBuffer.allocate((int)encodedFrameLength);
                                int offset = 0;
                                if (this._lastSpsBuffer != null) {
                                    newEncodedFrame.write(this._lastSpsBuffer, offset);
                                    offset += this._lastSpsBuffer.getLength();
                                }
                                if (this._lastPpsBuffer != null) {
                                    newEncodedFrame.write(this._lastPpsBuffer, offset);
                                    offset += this._lastPpsBuffer.getLength();
                                }
                                newEncodedFrame.write(encodedFrame, offset);
                                encodedFrame = newEncodedFrame;
                            }
                        }
                    }
                }
                if (encodedFrame != null) {
                    VideoFrame frame = new VideoFrame(new VideoBuffer(this._currentWidth, this._currentHeight, encodedFrame, (VideoFormat)this.getOutputFormat())){
                        {
                            this.setSynchronizationSource(MediaCodecEncoder.this._currentSynchronizationSource);
                        }
                    };
                    this.raiseFrame((MediaFrame)frame);
                }
            } else if (outputBufferIndex == -1) {
                ManagedCondition managedCondition = this._condition;
                synchronized (managedCondition) {
                    this._condition.halt(1);
                }
            }
            thread.loopEnd();
        }
    }
}

