/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.Guid;
import fm.HashMapExtensions;
import fm.Holder;
import fm.Serializable;
import fm.websync.Record;
import fm.websync.Serializer;
import java.util.HashMap;

public class SubscribedClient
extends Serializable {
    private HashMap<String, Record> _boundRecords;
    private Guid _clientId;

    public static SubscribedClient fromJson(String subscribedClientJson) throws Exception {
        return Serializer.deserializeSubscribedClient(subscribedClientJson);
    }

    public static SubscribedClient[] fromJsonMultiple(String subscribedClientsJson) throws Exception {
        return Serializer.deserializeSubscribedClientArray(subscribedClientsJson);
    }

    public HashMap<String, Record> getBoundRecords() {
        return this._boundRecords;
    }

    public String getBoundRecordValueJson(String key) {
        if (this.getBoundRecords() == null) {
            return null;
        }
        Record record = null;
        Holder _var0 = new Holder(record);
        boolean _var1 = HashMapExtensions.tryGetValue(this.getBoundRecords(), (Object)key, (Holder)_var0);
        record = (Record)((Object)_var0.getValue());
        if (!_var1) {
            return null;
        }
        return record.getValueJson();
    }

    public Guid getClientId() {
        return this._clientId;
    }

    public void setBoundRecords(HashMap<String, Record> value) {
        this._boundRecords = value;
    }

    public void setClientId(Guid value) {
        this._clientId = value;
    }

    public SubscribedClient(Guid clientId, HashMap<String, Record> boundRecords) {
        this.setClientId(clientId);
        this.setBoundRecords(boundRecords);
    }

    public SubscribedClient() {
        this.setBoundRecords(new HashMap<String, Record>());
    }

    public static String toJson(SubscribedClient subscribedClient) {
        return Serializer.serializeSubscribedClient(subscribedClient);
    }

    public String toJson() {
        return SubscribedClient.toJson(this);
    }

    public static String toJsonMultiple(SubscribedClient[] subscribedClients) {
        return Serializer.serializeSubscribedClientArray(subscribedClients);
    }
}

