/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;

public class PGPSignatureSubpacketVector {
    SignatureSubpacket[] packets;

    PGPSignatureSubpacketVector(SignatureSubpacket[] packets) {
        this.packets = packets;
    }

    public SignatureSubpacket getSubpacket(int type) {
        int i = 0;
        while (i != this.packets.length) {
            if (this.packets[i].getType() == type) {
                return this.packets[i];
            }
            ++i;
        }
        return null;
    }

    public boolean hasSubpacket(int type) {
        return this.getSubpacket(type) != null;
    }

    public SignatureSubpacket[] getSubpackets(int type) {
        ArrayList<SignatureSubpacket> list = new ArrayList<SignatureSubpacket>();
        int i = 0;
        while (i != this.packets.length) {
            if (this.packets[i].getType() == type) {
                list.add(this.packets[i]);
            }
            ++i;
        }
        return list.toArray(new SignatureSubpacket[0]);
    }

    public PGPSignatureList getEmbeddedSignatures() throws PGPException {
        SignatureSubpacket[] sigs = this.getSubpackets(32);
        ArrayList<PGPSignature> l = new ArrayList<PGPSignature>();
        int i = 0;
        while (i < sigs.length) {
            try {
                l.add(new PGPSignature(SignaturePacket.fromByteArray(sigs[i].getData())));
            }
            catch (IOException e) {
                throw new PGPException("Unable to parse signature packet: " + e.getMessage(), e);
            }
            ++i;
        }
        return new PGPSignatureList(l.toArray(new PGPSignature[l.size()]));
    }

    public NotationData[] getNotationDataOccurrences() {
        SignatureSubpacket[] notations = this.getSubpackets(20);
        NotationData[] vals = new NotationData[notations.length];
        int i = 0;
        while (i < notations.length) {
            vals[i] = (NotationData)notations[i];
            ++i;
        }
        return vals;
    }

    public NotationData[] getNotationDataOccurences() {
        return this.getNotationDataOccurrences();
    }

    public long getIssuerKeyID() {
        SignatureSubpacket p = this.getSubpacket(16);
        if (p == null) {
            return 0L;
        }
        return ((IssuerKeyID)p).getKeyID();
    }

    public Date getSignatureCreationTime() {
        SignatureSubpacket p = this.getSubpacket(2);
        if (p == null) {
            return null;
        }
        return ((SignatureCreationTime)p).getTime();
    }

    public long getSignatureExpirationTime() {
        SignatureSubpacket p = this.getSubpacket(3);
        if (p == null) {
            return 0L;
        }
        return ((SignatureExpirationTime)p).getTime();
    }

    public long getKeyExpirationTime() {
        SignatureSubpacket p = this.getSubpacket(9);
        if (p == null) {
            return 0L;
        }
        return ((KeyExpirationTime)p).getTime();
    }

    public int[] getPreferredHashAlgorithms() {
        SignatureSubpacket p = this.getSubpacket(21);
        if (p == null) {
            return null;
        }
        return ((PreferredAlgorithms)p).getPreferences();
    }

    public int[] getPreferredSymmetricAlgorithms() {
        SignatureSubpacket p = this.getSubpacket(11);
        if (p == null) {
            return null;
        }
        return ((PreferredAlgorithms)p).getPreferences();
    }

    public int[] getPreferredCompressionAlgorithms() {
        SignatureSubpacket p = this.getSubpacket(22);
        if (p == null) {
            return null;
        }
        return ((PreferredAlgorithms)p).getPreferences();
    }

    public int getKeyFlags() {
        SignatureSubpacket p = this.getSubpacket(27);
        if (p == null) {
            return 0;
        }
        return ((KeyFlags)p).getFlags();
    }

    public String getSignerUserID() {
        SignatureSubpacket p = this.getSubpacket(28);
        if (p == null) {
            return null;
        }
        return ((SignerUserID)p).getID();
    }

    public boolean isPrimaryUserID() {
        PrimaryUserID primaryId = (PrimaryUserID)this.getSubpacket(25);
        if (primaryId != null) {
            return primaryId.isPrimaryUserID();
        }
        return false;
    }

    public int[] getCriticalTags() {
        int count = 0;
        int i = 0;
        while (i != this.packets.length) {
            if (this.packets[i].isCritical()) {
                ++count;
            }
            ++i;
        }
        int[] list = new int[count];
        count = 0;
        int i2 = 0;
        while (i2 != this.packets.length) {
            if (this.packets[i2].isCritical()) {
                list[count++] = this.packets[i2].getType();
            }
            ++i2;
        }
        return list;
    }

    public Features getFeatures() {
        SignatureSubpacket p = this.getSubpacket(30);
        if (p == null) {
            return null;
        }
        return new Features(p.isCritical(), p.isLongLength(), p.getData());
    }

    public int size() {
        return this.packets.length;
    }

    SignatureSubpacket[] toSubpacketArray() {
        return this.packets;
    }
}

