/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.pcmu;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioEncoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.DataBuffer;
import fm.icelink.IAudioOutput;
import fm.icelink.pcmu.Codec;
import fm.icelink.pcmu.Format;

public class Encoder
extends AudioEncoder {
    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        AudioBuffer buffer = this.encode(inputBuffer);
        if (buffer != null) {
            frame.addBuffer(buffer);
            this.raiseFrame(frame);
        }
    }

    private AudioBuffer encode(AudioBuffer inputBuffer) {
        DataBuffer dataBuffer = inputBuffer.getDataBuffer();
        DataBuffer buffer2 = DataBuffer.allocate(dataBuffer.getLength() / 2, ((AudioFormat)super.getOutputFormat()).getLittleEndian());
        int offset = 0;
        int i = 0;
        while (offset < buffer2.getLength()) {
            buffer2.write8(Codec.compress(dataBuffer.read16(i)), offset);
            ++offset;
            i += 2;
        }
        return new AudioBuffer(buffer2, (AudioFormat)super.getOutputFormat());
    }

    public Encoder(IAudioOutput input) {
        this(input.getConfig());
        super.addInput(input);
    }

    public Encoder() {
        this(new Format().getConfig());
    }

    public Encoder(AudioConfig config) {
        super(new fm.icelink.pcm.Format(config), new Format(config));
    }

    @Override
    public String getLabel() {
        return "PCMU (G.711u) Encoder";
    }
}

