/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.AsyncLogger;
import fm.icelink.HashMapExtensions;
import fm.icelink.ILog;
import fm.icelink.LogConfiguration;
import fm.icelink.LogLevel;
import fm.icelink.LogProvider;

public class Log {
    private static ILog __staticLogger = new AsyncLogger("FM");

    public static void debug(String message, Exception ex) {
        __staticLogger.debug(message, ex);
    }

    public static void debug(String message) {
        __staticLogger.debug(message);
    }

    public static void error(String message) {
        __staticLogger.error(message);
    }

    public static void error(String message, Exception ex) {
        __staticLogger.error(message, ex);
    }

    public static void fatal(String message) {
        __staticLogger.fatal(message);
    }

    public static void fatal(String message, Exception ex) {
        __staticLogger.fatal(message, ex);
    }

    public static boolean getIsDebugEnabled() {
        return LogConfiguration.getDefaultLogLevel().getAssignedValue() <= LogLevel.Debug.getAssignedValue();
    }

    public static boolean getIsErrorEnabled() {
        return LogConfiguration.getDefaultLogLevel().getAssignedValue() <= LogLevel.Error.getAssignedValue();
    }

    public static boolean getIsFatalEnabled() {
        return LogConfiguration.getDefaultLogLevel().getAssignedValue() <= LogLevel.Fatal.getAssignedValue();
    }

    public static boolean getIsInfoEnabled() {
        return LogConfiguration.getDefaultLogLevel().getAssignedValue() <= LogLevel.Info.getAssignedValue();
    }

    public static boolean getIsWarnEnabled() {
        return LogConfiguration.getDefaultLogLevel().getAssignedValue() <= LogLevel.Warn.getAssignedValue();
    }

    public static ILog getLogger(String tag, LogLevel level) {
        if (!LogConfiguration.getTagOverrides().containsKey(tag)) {
            Log.setTagOverride(tag, level);
        }
        return Log.getLogger(tag);
    }

    public static ILog getLogger(String tag) {
        return new AsyncLogger(tag);
    }

    public static LogLevel getLogLevel() {
        return LogConfiguration.getDefaultLogLevel();
    }

    public static LogProvider getProvider() {
        Object[] logProviders = LogConfiguration.getLogProviders();
        return ArrayExtensions.getLength(logProviders) > 0 ? logProviders[0] : null;
    }

    public static void info(String message, Exception ex) {
        __staticLogger.info(message, ex);
    }

    public static void info(String message) {
        __staticLogger.info(message);
    }

    public static void registerProvider(LogProvider provider) {
        LogConfiguration.addLogProvider(provider);
        if (provider.getLevel().getAssignedValue() < LogConfiguration.getDefaultLogLevel().getAssignedValue()) {
            LogConfiguration.setDefaultLogLevel(provider.getLevel());
        }
    }

    public static void removeProvider(LogProvider provider) {
        LogConfiguration.removeLogProvider(provider);
    }

    public static void setLogLevel(LogLevel value) {
        LogConfiguration.setDefaultLogLevel(value);
    }

    public static void setProvider(LogProvider value) {
        LogConfiguration.clearLogProviders();
        Log.registerProvider(value);
    }

    public static void setTagOverride(String tag, LogLevel level) {
        HashMapExtensions.set(HashMapExtensions.getItem(LogConfiguration.getTagOverrides()), tag, level);
    }

    public static void warn(String message, Exception ex) {
        __staticLogger.warn(message, ex);
    }

    public static void warn(String message) {
        __staticLogger.warn(message);
    }

    public static void writeLine(String text) {
        __staticLogger.log(text);
    }
}

