/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBranch;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.AudioSink;
import fm.icelink.AudioSource;
import fm.icelink.AudioStream;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioInput;
import fm.icelink.IAudioInputCollection;
import fm.icelink.IAudioOutput;
import fm.icelink.IAudioOutputCollection;
import fm.icelink.IAudioTrack;
import fm.icelink.IMediaTrack;
import fm.icelink.MathAssistant;
import fm.icelink.MediaTrack;
import java.util.ArrayList;
import java.util.List;

public class AudioTrack
extends MediaTrack<IAudioOutput, IAudioOutputCollection, IAudioInput, IAudioInputCollection, IAudioElement, AudioSource, AudioSink, AudioPipe, AudioTrack, AudioBranch, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>
implements IAudioTrack,
IMediaTrack {
    private ArrayList<IAudioElement> __elements;
    private double __gain = 1.0;
    private List<IAction1<Double>> __onLevel = new ArrayList<IAction1<Double>>();
    private List<IAction1<AudioBuffer>> __onPcmBuffer = new ArrayList<IAction1<AudioBuffer>>();
    private double __volume = 1.0;
    private IAction1<Double> _onLevel = new IAction1<Double>(){

        @Override
        public void invoke(Double p0) {
            for (IAction1 action : new ArrayList(AudioTrack.this.__onLevel)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<AudioBuffer> _onPcmBuffer = new IAction1<AudioBuffer>(){

        @Override
        public void invoke(AudioBuffer p0) {
            for (IAction1 action : new ArrayList(AudioTrack.this.__onPcmBuffer)) {
                action.invoke(p0);
            }
        }
    };
    private IAudioInput _pcmGainInput;
    private IAudioOutput _pcmGainOutput;
    private IAudioInput _pcmVolumeInput;
    private IAudioOutput _pcmVolumeOutput;

    @Override
    protected void addElement(IAudioElement element) {
        if (element instanceof AudioBranch) {
            AudioBranch branch = (AudioBranch)element;
            for (AudioTrack track : (AudioTrack[])branch.getTracks()) {
                track.addOnPcmBuffer((IAction1<AudioBuffer>)new IActionDelegate1<AudioBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.AudioTrack.track_OnPcmBuffer";
                    }

                    @Override
                    public void invoke(AudioBuffer pcmBuffer) {
                        AudioTrack.this.track_OnPcmBuffer(pcmBuffer);
                    }
                });
            }
        } else {
            IAudioOutput output;
            AudioFormat outputFormat;
            IAudioInput input;
            AudioFormat inputFormat;
            if (element instanceof IAudioInput && (inputFormat = (AudioFormat)(input = (IAudioInput)element).getInputFormat()) != null && inputFormat.getIsPcm()) {
                if (this.getPcmGainInput() == null && this.getPcmGainOutput() == null) {
                    this.setPcmGainInput(input);
                    this.getPcmGainInput().addOnProcessFrame(new IActionDelegate1<AudioFrame>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.AudioTrack.pcmGain_OnProcessFrame";
                        }

                        @Override
                        public void invoke(AudioFrame frame) {
                            AudioTrack.this.pcmGain_OnProcessFrame(frame);
                        }
                    });
                }
                if (this.getPcmVolumeInput() != null) {
                    this.getPcmVolumeInput().removeOnProcessFrame(new IActionDelegate1<AudioFrame>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.AudioTrack.pcmVolume_OnProcessFrame";
                        }

                        @Override
                        public void invoke(AudioFrame frame) {
                            AudioTrack.this.pcmVolume_OnProcessFrame(frame);
                        }
                    });
                }
                if (this.getPcmVolumeOutput() != null) {
                    this.getPcmVolumeOutput().removeOnRaiseFrame(new IActionDelegate1<AudioFrame>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.AudioTrack.pcmVolume_OnProcessFrame";
                        }

                        @Override
                        public void invoke(AudioFrame frame) {
                            AudioTrack.this.pcmVolume_OnProcessFrame(frame);
                        }
                    });
                }
                this.setPcmVolumeInput(input);
                this.getPcmVolumeInput().addOnProcessFrame(new IActionDelegate1<AudioFrame>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.AudioTrack.pcmVolume_OnProcessFrame";
                    }

                    @Override
                    public void invoke(AudioFrame frame) {
                        AudioTrack.this.pcmVolume_OnProcessFrame(frame);
                    }
                });
            }
            if (element instanceof IAudioOutput && (outputFormat = (AudioFormat)(output = (IAudioOutput)element).getOutputFormat()) != null && outputFormat.getIsPcm()) {
                if (this.getPcmGainInput() == null && this.getPcmGainOutput() == null) {
                    this.setPcmGainOutput(output);
                    this.getPcmGainOutput().addOnRaiseFrame(new IActionDelegate1<AudioFrame>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.AudioTrack.pcmGain_OnProcessFrame";
                        }

                        @Override
                        public void invoke(AudioFrame frame) {
                            AudioTrack.this.pcmGain_OnProcessFrame(frame);
                        }
                    });
                }
                if (this.getPcmVolumeInput() != null) {
                    this.getPcmVolumeInput().removeOnProcessFrame(new IActionDelegate1<AudioFrame>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.AudioTrack.pcmVolume_OnProcessFrame";
                        }

                        @Override
                        public void invoke(AudioFrame frame) {
                            AudioTrack.this.pcmVolume_OnProcessFrame(frame);
                        }
                    });
                }
                if (this.getPcmVolumeOutput() != null) {
                    this.getPcmVolumeOutput().removeOnRaiseFrame(new IActionDelegate1<AudioFrame>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.AudioTrack.pcmVolume_OnProcessFrame";
                        }

                        @Override
                        public void invoke(AudioFrame frame) {
                            AudioTrack.this.pcmVolume_OnProcessFrame(frame);
                        }
                    });
                }
                this.setPcmVolumeOutput(output);
                this.getPcmVolumeOutput().addOnRaiseFrame(new IActionDelegate1<AudioFrame>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.AudioTrack.pcmVolume_OnProcessFrame";
                    }

                    @Override
                    public void invoke(AudioFrame frame) {
                        AudioTrack.this.pcmVolume_OnProcessFrame(frame);
                    }
                });
            }
        }
        this.__elements.add(element);
    }

    @Override
    public void addOnLevel(IAction1<Double> value) {
        this.__onLevel.add(value);
    }

    void addOnPcmBuffer(IAction1<AudioBuffer> value) {
        this.__onPcmBuffer.add(value);
    }

    private void applyGain(AudioBuffer pcmBuffer) {
        if (pcmBuffer != null) {
            pcmBuffer.applyGain(this.getGain());
        }
    }

    private void applyVolume(AudioBuffer pcmBuffer) {
        if (pcmBuffer != null) {
            pcmBuffer.applyGain(this.getVolume());
        }
    }

    protected IAudioInput[] arrayFromInputs(ArrayList<IAudioInput> inputs) {
        return inputs.toArray(new IAudioInput[0]);
    }

    protected IAudioOutput[] arrayFromOutputs(ArrayList<IAudioOutput> outputs) {
        return outputs.toArray(new IAudioOutput[0]);
    }

    public AudioTrack() {
        this.__elements = new ArrayList();
        this.initialize(null);
    }

    public AudioTrack(AudioTrack[] tracks) {
        this.__elements = new ArrayList();
        this.initialize(tracks == null ? null : new AudioBranch(tracks));
    }

    public AudioTrack(IAudioElement element) {
        this.__elements = new ArrayList();
        this.initialize(element);
    }

    protected AudioBranch branchFromTracks(AudioTrack[] tracks) {
        return new AudioBranch(tracks);
    }

    public AudioConfig getConfig() {
        IAudioInput pcmGainInput = this.getPcmGainInput();
        if (pcmGainInput != null) {
            return pcmGainInput.getConfig();
        }
        IAudioOutput pcmGainOutput = this.getPcmGainOutput();
        if (pcmGainOutput != null) {
            return pcmGainOutput.getConfig();
        }
        IAudioInput pcmVolumeInput = this.getPcmVolumeInput();
        if (pcmVolumeInput != null) {
            return pcmVolumeInput.getConfig();
        }
        IAudioOutput pcmVolumeOutput = this.getPcmVolumeOutput();
        if (pcmVolumeOutput != null) {
            return pcmVolumeOutput.getConfig();
        }
        return null;
    }

    public IAudioElement[] getElements() {
        return this.__elements.toArray(new IAudioElement[0]);
    }

    @Override
    public double getGain() {
        return this.__gain;
    }

    @Override
    public String getLabel() {
        return "Audio Track";
    }

    IAudioInput getPcmGainInput() {
        return this._pcmGainInput;
    }

    IAudioOutput getPcmGainOutput() {
        return this._pcmGainOutput;
    }

    IAudioInput getPcmVolumeInput() {
        return this._pcmVolumeInput;
    }

    IAudioOutput getPcmVolumeOutput() {
        return this._pcmVolumeOutput;
    }

    @Override
    public double getVolume() {
        return this.__volume;
    }

    private void initialize(IAudioElement element) {
        if (element != null) {
            this.addElement(element);
        }
    }

    @Override
    protected boolean isBranch(IAudioElement element) {
        return element instanceof AudioBranch;
    }

    @Override
    protected boolean isInput(IAudioElement element) {
        return element instanceof IAudioInput;
    }

    @Override
    protected boolean isOutput(IAudioElement element) {
        return element instanceof IAudioOutput;
    }

    @Override
    protected boolean isPipe(IAudioElement element) {
        return element instanceof AudioPipe;
    }

    @Override
    protected boolean isSink(IAudioElement element) {
        return element instanceof AudioSink;
    }

    @Override
    protected boolean isSource(IAudioElement element) {
        return element instanceof AudioSource;
    }

    @Override
    protected boolean isStream(IAudioElement element) {
        return element instanceof AudioStream;
    }

    private void pcmGain_OnProcessFrame(AudioFrame frame) {
        AudioBuffer pcmBuffer = (AudioBuffer)frame.getBuffer(AudioFormat.getPcmName());
        this.applyGain(pcmBuffer);
        this.raiseLevel(pcmBuffer);
        this.raisePcmBuffer(pcmBuffer);
        if (this.getPcmVolumeInput() == null && this.getPcmVolumeOutput() == null) {
            this.applyVolume(pcmBuffer);
        }
    }

    private void pcmVolume_OnProcessFrame(AudioFrame frame) {
        AudioBuffer pcmBuffer = (AudioBuffer)frame.getBuffer(AudioFormat.getPcmName());
        if (this.getPcmGainInput() == null && this.getPcmGainOutput() == null) {
            this.applyGain(pcmBuffer);
            this.raiseLevel(pcmBuffer);
            this.raisePcmBuffer(pcmBuffer);
        }
        this.applyVolume(pcmBuffer);
    }

    private void raiseLevel(AudioBuffer pcmBuffer) {
        IAction1<Double> onLevel;
        if (pcmBuffer != null && (onLevel = this._onLevel) != null) {
            onLevel.invoke(pcmBuffer.calculateLevel());
        }
    }

    private void raisePcmBuffer(AudioBuffer pcmBuffer) {
        IAction1<AudioBuffer> onPcmBuffer;
        if (pcmBuffer != null && (onPcmBuffer = this._onPcmBuffer) != null) {
            onPcmBuffer.invoke(pcmBuffer);
        }
    }

    @Override
    public void removeOnLevel(IAction1<Double> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onLevel, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onLevel.remove(value);
    }

    void removeOnPcmBuffer(IAction1<AudioBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onPcmBuffer, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onPcmBuffer.remove(value);
    }

    @Override
    public void setGain(double value) {
        this.__gain = MathAssistant.max(value, 0.0);
    }

    private void setPcmGainInput(IAudioInput value) {
        this._pcmGainInput = value;
    }

    private void setPcmGainOutput(IAudioOutput value) {
        this._pcmGainOutput = value;
    }

    private void setPcmVolumeInput(IAudioInput value) {
        this._pcmVolumeInput = value;
    }

    private void setPcmVolumeOutput(IAudioOutput value) {
        this._pcmVolumeOutput = value;
    }

    @Override
    public void setVolume(double value) {
        this.__volume = MathAssistant.min(MathAssistant.max(value, 0.0), 1.0);
    }

    private void track_OnPcmBuffer(AudioBuffer pcmBuffer) {
        if (this.getPcmVolumeInput() == null && this.getPcmVolumeOutput() == null && this.getPcmGainInput() == null && this.getPcmGainOutput() == null) {
            this.applyGain(pcmBuffer);
            this.raiseLevel(pcmBuffer);
            this.raisePcmBuffer(pcmBuffer);
            this.applyVolume(pcmBuffer);
        }
    }
}

