/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.ArrayExtensions;
import fm.DateExtensions;
import fm.DeserializeCallback;
import fm.EmptyFunction;
import fm.Global;
import fm.HashMapExtensions;
import fm.IntegerExtensions;
import fm.IntegerHolder;
import fm.NullableBoolean;
import fm.NullableDate;
import fm.NullableGuid;
import fm.NullableInteger;
import fm.ParseAssistant;
import fm.Serializable;
import fm.SerializeCallback;
import fm.StringExtensions;
import fm.websync.Advice;
import fm.websync.BaseAdvice;
import fm.websync.ConnectionType;
import fm.websync.Extensions;
import fm.websync.Message;
import fm.websync.MessageType;
import fm.websync.Notification;
import fm.websync.NotifyingClient;
import fm.websync.NullableConnectionType;
import fm.websync.NullableReconnect;
import fm.websync.Publication;
import fm.websync.PublishingClient;
import fm.websync.Reconnect;
import fm.websync.Record;
import fm.websync.SubscribedClient;
import fm.websync.Subscription;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

class Serializer {
    static Advice createAdvice() {
        return new Advice();
    }

    static BaseAdvice createBaseAdvice() {
        return new BaseAdvice();
    }

    static HashMap<String, Record> createBoundRecords() {
        return new HashMap<String, Record>();
    }

    static Extensions createExtensions() {
        return new Extensions();
    }

    static Message createMessage() {
        return new Message();
    }

    static Notification createNotification() {
        return new Notification();
    }

    static NotifyingClient createNotifyingClient() {
        return new NotifyingClient();
    }

    static Publication createPublication() {
        return new Publication();
    }

    static PublishingClient createPublishingClient() {
        return new PublishingClient();
    }

    static Record createRecord() throws Exception {
        return new Record("key");
    }

    static SubscribedClient createSubscribedClient() {
        return new SubscribedClient();
    }

    private static Subscription createSubscription() throws Exception {
        return new Subscription("/");
    }

    public static Advice deserializeAdvice(String adviceJson) throws Exception {
        return (Advice)fm.Serializer.deserializeObjectFast((String)adviceJson, (EmptyFunction)new EmptyFunction<Advice>(){

            public Advice invoke() {
                try {
                    return Serializer.createAdvice();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Advice>(){

            public void invoke(Advice advice, String name, String valueJson) {
                try {
                    Serializer.deserializeAdviceCallback(advice, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    static void deserializeAdviceCallback(Advice advice, String name, String valueJson) throws Exception {
        String _var0 = name;
        if (_var0.equals("websocket")) {
            advice.setWebSocket(Serializer.deserializeBaseAdvice(valueJson));
            return;
        }
        if (_var0.equals("long-polling")) {
            advice.setLongPolling(Serializer.deserializeBaseAdvice(valueJson));
            return;
        }
        if (_var0.equals("callback-polling")) {
            advice.setCallbackPolling(Serializer.deserializeBaseAdvice(valueJson));
            return;
        }
        Serializer.deserializeBaseAdviceCallback(advice, name, valueJson);
    }

    public static BaseAdvice deserializeBaseAdvice(String baseAdviceJson) throws Exception {
        return (BaseAdvice)fm.Serializer.deserializeObjectFast((String)baseAdviceJson, (EmptyFunction)new EmptyFunction<BaseAdvice>(){

            public BaseAdvice invoke() {
                try {
                    return Serializer.createBaseAdvice();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<BaseAdvice>(){

            public void invoke(BaseAdvice advice, String name, String valueJson) {
                try {
                    Serializer.deserializeBaseAdviceCallback(advice, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    static void deserializeBaseAdviceCallback(BaseAdvice advice, String name, String valueJson) throws Exception {
        String str = name;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"hosts")) {
                if (Global.equals((Object)str, (Object)"interval")) {
                    advice.setInterval(fm.Serializer.deserializeInteger((String)valueJson));
                } else if (Global.equals((Object)str, (Object)"reconnect")) {
                    advice.setReconnect(new NullableReconnect(Serializer.deserializeReconnect(valueJson)));
                }
            } else {
                advice.setHosts(fm.Serializer.deserializeStringArray((String)valueJson));
            }
        }
    }

    public static HashMap<String, Record> deserializeBoundRecords(String boundRecordsJson) throws Exception {
        return (HashMap)fm.Serializer.deserializeObject((String)boundRecordsJson, (EmptyFunction)new EmptyFunction<HashMap<String, Record>>(){

            public HashMap<String, Record> invoke() {
                try {
                    return Serializer.createBoundRecords();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<HashMap<String, Record>>(){

            public void invoke(HashMap<String, Record> boundRecords, String name, String valueJson) {
                try {
                    Serializer.deserializeBoundRecordsCallback(boundRecords, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    static void deserializeBoundRecordsCallback(HashMap<String, Record> boundRecords, String name, String valueJson) throws Exception {
        HashMapExtensions.getItem(boundRecords).put(name, new Record(name, fm.Serializer.deserializeRaw((String)valueJson)));
    }

    public static ConnectionType deserializeConnectionType(String connectionTypeJson) throws Exception {
        String _var0 = fm.Serializer.deserializeString((String)connectionTypeJson);
        if (_var0.equals("long-polling")) {
            return ConnectionType.LongPolling;
        }
        if (_var0.equals("callback-polling")) {
            return ConnectionType.CallbackPolling;
        }
        if (_var0.equals("websocket")) {
            return ConnectionType.WebSocket;
        }
        if (_var0.equals("iframe")) {
            return ConnectionType.IFrame;
        }
        if (_var0.equals("flash")) {
            return ConnectionType.Flash;
        }
        return ConnectionType.Unknown;
    }

    public static ConnectionType[] deserializeConnectionTypeArray(String connectionTypesJson) throws Exception {
        if (StringExtensions.isNullOrEmpty((String)connectionTypesJson) || Global.equals((Object)connectionTypesJson, (Object)"null") || StringExtensions.getLength((String)connectionTypesJson) < 2 || connectionTypesJson.charAt(0) != '[' || connectionTypesJson.charAt(StringExtensions.getLength((String)connectionTypesJson) - 1) != ']') {
            return null;
        }
        connectionTypesJson = StringExtensions.substring((String)connectionTypesJson, (int)1, (int)(StringExtensions.getLength((String)connectionTypesJson) - 2));
        Object[] strArray = StringExtensions.split((String)connectionTypesJson, (char[])new char[]{','});
        ConnectionType[] typeArray = new ConnectionType[ArrayExtensions.getLength((Object[])strArray)];
        for (int i = 0; i < ArrayExtensions.getLength((Object[])strArray); ++i) {
            typeArray[i] = Serializer.deserializeConnectionType((String)strArray[i]);
        }
        return typeArray;
    }

    public static Extensions deserializeExtensions(String extensionsJson) throws Exception {
        return (Extensions)fm.Serializer.deserializeObjectFast((String)extensionsJson, (EmptyFunction)new EmptyFunction<Extensions>(){

            public Extensions invoke() {
                try {
                    return Serializer.createExtensions();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Extensions>(){

            public void invoke(Extensions extensions, String name, String valueJson) {
                try {
                    Serializer.deserializeExtensionsCallback(extensions, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    static void deserializeExtensionsCallback(Extensions extensions, String name, String valueJson) throws Exception {
        extensions.setValueJson(name, fm.Serializer.deserializeRaw((String)valueJson), false);
    }

    public static Message deserializeMessage(String messageJson) throws Exception {
        return (Message)fm.Serializer.deserializeObjectFast((String)messageJson, (EmptyFunction)new EmptyFunction<Message>(){

            public Message invoke() {
                try {
                    return Serializer.createMessage();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Message>(){

            public void invoke(Message message, String name, String valueJson) {
                try {
                    Serializer.deserializeMessageCallback(message, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    public static Message[] deserializeMessageArray(String messagesJson) throws Exception {
        ArrayList list = fm.Serializer.deserializeObjectArrayFast((String)messagesJson, (EmptyFunction)new EmptyFunction<Message>(){

            public Message invoke() {
                try {
                    return Serializer.createMessage();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Message>(){

            public void invoke(Message message, String name, String valueJson) {
                try {
                    Serializer.deserializeMessageCallback(message, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new Message[0]);
    }

    static void deserializeMessageCallback(Message message, String name, String valueJson) throws Exception {
        message.setValidate(false);
        String _var0 = name;
        if (_var0.equals("advice")) {
            message.setAdvice(Serializer.deserializeAdvice(valueJson));
        } else if (_var0.equals("binding")) {
            message.setRecords(Serializer.deserializeRecordArray(valueJson));
        } else if (_var0.equals("channel")) {
            message.setBayeuxChannel(fm.Serializer.deserializeString((String)valueJson));
        } else if (_var0.equals("clientId")) {
            message.setClientId(fm.Serializer.deserializeGuid((String)valueJson));
        } else if (_var0.equals("connectionType")) {
            message.setConnectionType(new NullableConnectionType(Serializer.deserializeConnectionType(valueJson)));
        } else if (_var0.equals("data")) {
            message.setDataJson(fm.Serializer.deserializeRaw((String)valueJson));
        } else if (_var0.equals("error")) {
            message.setError(fm.Serializer.deserializeString((String)valueJson));
        } else if (_var0.equals("ext")) {
            message.setExtensions(Serializer.deserializeExtensions(valueJson));
        } else if (_var0.equals("id")) {
            message.setId(fm.Serializer.deserializeString((String)valueJson));
        } else if (_var0.equals("minimumVersion")) {
            message.setMinimumVersion(fm.Serializer.deserializeString((String)valueJson));
        } else if (_var0.equals("subscription")) {
            if (!valueJson.startsWith("[")) {
                String str = fm.Serializer.deserializeString((String)valueJson);
                if (!StringExtensions.isNullOrEmpty((String)str)) {
                    message.setChannels(new String[]{str});
                }
            } else {
                message.setChannels(fm.Serializer.deserializeStringArray((String)valueJson));
            }
        } else if (_var0.equals("successful")) {
            NullableBoolean nullable = fm.Serializer.deserializeBoolean((String)valueJson);
            message.setSuccessful(nullable.hasValue() && nullable.getValue());
        } else if (_var0.equals("supportedConnectionTypes")) {
            message.setSupportedConnectionTypes(Serializer.deserializeConnectionTypeArray(valueJson));
        } else if (_var0.equals("timestamp")) {
            message.setTimestamp(new NullableDate(Serializer.deserializeTimestamp(valueJson)));
        } else if (_var0.equals("version")) {
            message.setVersion(fm.Serializer.deserializeString((String)valueJson));
        }
        message.setValidate(true);
    }

    public static Notification deserializeNotification(String notificationJson) throws Exception {
        return (Notification)fm.Serializer.deserializeObjectFast((String)notificationJson, (EmptyFunction)new EmptyFunction<Notification>(){

            public Notification invoke() {
                try {
                    return Serializer.createNotification();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Notification>(){

            public void invoke(Notification notification, String name, String valueJson) {
                try {
                    Serializer.deserializeNotificationCallback(notification, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    public static Notification[] deserializeNotificationArray(String notificationsJson) throws Exception {
        ArrayList list = fm.Serializer.deserializeObjectArrayFast((String)notificationsJson, (EmptyFunction)new EmptyFunction<Notification>(){

            public Notification invoke() {
                try {
                    return Serializer.createNotification();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Notification>(){

            public void invoke(Notification notification, String name, String valueJson) {
                try {
                    Serializer.deserializeNotificationCallback(notification, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new Notification[0]);
    }

    static void deserializeNotificationCallback(Notification notification, String name, String valueJson) throws Exception {
        notification.setValidate(false);
        String str = name;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"data")) {
                if (Global.equals((Object)str, (Object)"ext")) {
                    notification.setExtensions(Serializer.deserializeExtensions(valueJson));
                } else if (Global.equals((Object)str, (Object)"successful")) {
                    NullableBoolean nullable = fm.Serializer.deserializeBoolean((String)valueJson);
                    notification.setSuccessful(nullable.hasValue() && nullable.getValue());
                } else if (Global.equals((Object)str, (Object)"error")) {
                    notification.setError(fm.Serializer.deserializeString((String)valueJson));
                } else if (Global.equals((Object)str, (Object)"timestamp")) {
                    notification.setTimestamp(new NullableDate(Serializer.deserializeTimestamp(valueJson)));
                }
            } else {
                notification.setDataJson(fm.Serializer.deserializeRaw((String)valueJson));
            }
        }
        notification.setValidate(true);
    }

    public static NotifyingClient deserializeNotifyingClient(String notifyingClientJson) throws Exception {
        return (NotifyingClient)fm.Serializer.deserializeObjectFast((String)notifyingClientJson, (EmptyFunction)new EmptyFunction<NotifyingClient>(){

            public NotifyingClient invoke() {
                try {
                    return Serializer.createNotifyingClient();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<NotifyingClient>(){

            public void invoke(NotifyingClient notifyingClient, String name, String valueJson) {
                try {
                    Serializer.deserializeNotifyingClientCallback(notifyingClient, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    static void deserializeNotifyingClientCallback(NotifyingClient notifyingClient, String name, String valueJson) throws Exception {
        String str = name;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"clientId")) {
                if (Global.equals((Object)str, (Object)"boundRecords")) {
                    notifyingClient.setBoundRecords(Serializer.deserializeBoundRecords(valueJson));
                }
            } else {
                notifyingClient.setClientId(fm.Serializer.deserializeGuid((String)valueJson));
            }
        }
    }

    public static Publication deserializePublication(String publicationJson) throws Exception {
        return (Publication)fm.Serializer.deserializeObjectFast((String)publicationJson, (EmptyFunction)new EmptyFunction<Publication>(){

            public Publication invoke() {
                try {
                    return Serializer.createPublication();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Publication>(){

            public void invoke(Publication publication, String name, String valueJson) {
                try {
                    Serializer.deserializePublicationCallback(publication, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    public static Publication[] deserializePublicationArray(String publicationsJson) throws Exception {
        ArrayList list = fm.Serializer.deserializeObjectArrayFast((String)publicationsJson, (EmptyFunction)new EmptyFunction<Publication>(){

            public Publication invoke() {
                try {
                    return Serializer.createPublication();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Publication>(){

            public void invoke(Publication publication, String name, String valueJson) {
                try {
                    Serializer.deserializePublicationCallback(publication, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new Publication[0]);
    }

    static void deserializePublicationCallback(Publication publication, String name, String valueJson) throws Exception {
        publication.setValidate(false);
        String str = name;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"channel")) {
                if (Global.equals((Object)str, (Object)"data")) {
                    publication.setDataJson(fm.Serializer.deserializeRaw((String)valueJson));
                } else if (Global.equals((Object)str, (Object)"ext")) {
                    publication.setExtensions(Serializer.deserializeExtensions(valueJson));
                } else if (Global.equals((Object)str, (Object)"successful")) {
                    NullableBoolean nullable = fm.Serializer.deserializeBoolean((String)valueJson);
                    publication.setSuccessful(nullable.hasValue() && nullable.getValue());
                } else if (Global.equals((Object)str, (Object)"error")) {
                    publication.setError(fm.Serializer.deserializeString((String)valueJson));
                } else if (Global.equals((Object)str, (Object)"timestamp")) {
                    publication.setTimestamp(new NullableDate(Serializer.deserializeTimestamp(valueJson)));
                }
            } else {
                publication.setChannel(fm.Serializer.deserializeString((String)valueJson));
            }
        }
        publication.setValidate(true);
    }

    public static PublishingClient deserializePublishingClient(String publishingClientJson) throws Exception {
        return (PublishingClient)fm.Serializer.deserializeObjectFast((String)publishingClientJson, (EmptyFunction)new EmptyFunction<PublishingClient>(){

            public PublishingClient invoke() {
                try {
                    return Serializer.createPublishingClient();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<PublishingClient>(){

            public void invoke(PublishingClient publishingClient, String name, String valueJson) {
                try {
                    Serializer.deserializePublishingClientCallback(publishingClient, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    static void deserializePublishingClientCallback(PublishingClient publishingClient, String name, String valueJson) throws Exception {
        String str = name;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"clientId")) {
                if (Global.equals((Object)str, (Object)"boundRecords")) {
                    publishingClient.setBoundRecords(Serializer.deserializeBoundRecords(valueJson));
                }
            } else {
                publishingClient.setClientId(fm.Serializer.deserializeGuid((String)valueJson));
            }
        }
    }

    public static Reconnect deserializeReconnect(String reconnectJson) throws Exception {
        String _var0 = fm.Serializer.deserializeString((String)reconnectJson);
        if (_var0.equals("retry")) {
            return Reconnect.Retry;
        }
        if (_var0.equals("handshake")) {
            return Reconnect.Handshake;
        }
        if (_var0.equals("none")) {
            return Reconnect.None;
        }
        throw new Exception("Unknown reconnect advice.");
    }

    public static Record deserializeRecord(String recordJson) throws Exception {
        return (Record)fm.Serializer.deserializeObjectFast((String)recordJson, (EmptyFunction)new EmptyFunction<Record>(){

            public Record invoke() {
                try {
                    return Serializer.createRecord();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Record>(){

            public void invoke(Record record, String name, String valueJson) {
                try {
                    Serializer.deserializeRecordCallback(record, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    public static Record[] deserializeRecordArray(String recordsJson) throws Exception {
        ArrayList list = fm.Serializer.deserializeObjectArrayFast((String)recordsJson, (EmptyFunction)new EmptyFunction<Record>(){

            public Record invoke() {
                try {
                    return Serializer.createRecord();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Record>(){

            public void invoke(Record record, String name, String valueJson) {
                try {
                    Serializer.deserializeRecordCallback(record, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new Record[0]);
    }

    static void deserializeRecordCallback(Record record, String name, String valueJson) throws Exception {
        record.setValidate(false);
        String str = name;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"key")) {
                if (Global.equals((Object)str, (Object)"private")) {
                    NullableBoolean nullable = fm.Serializer.deserializeBoolean((String)valueJson);
                    record.setPrivate(nullable.hasValue() && nullable.getValue());
                } else if (Global.equals((Object)str, (Object)"value")) {
                    record.setValueJson(fm.Serializer.deserializeRaw((String)valueJson));
                }
            } else {
                record.setKey(fm.Serializer.deserializeString((String)valueJson));
            }
        }
        record.setValidate(true);
    }

    public static SubscribedClient deserializeSubscribedClient(String subscribedClientJson) throws Exception {
        return (SubscribedClient)fm.Serializer.deserializeObjectFast((String)subscribedClientJson, (EmptyFunction)new EmptyFunction<SubscribedClient>(){

            public SubscribedClient invoke() {
                try {
                    return Serializer.createSubscribedClient();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<SubscribedClient>(){

            public void invoke(SubscribedClient subscribedClient, String name, String valueJson) {
                try {
                    Serializer.deserializeSubscribedClientCallback(subscribedClient, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    public static SubscribedClient[] deserializeSubscribedClientArray(String subscribedClientsJson) throws Exception {
        ArrayList list = fm.Serializer.deserializeObjectArrayFast((String)subscribedClientsJson, (EmptyFunction)new EmptyFunction<SubscribedClient>(){

            public SubscribedClient invoke() {
                try {
                    return Serializer.createSubscribedClient();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<SubscribedClient>(){

            public void invoke(SubscribedClient subscribedClient, String name, String valueJson) {
                try {
                    Serializer.deserializeSubscribedClientCallback(subscribedClient, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new SubscribedClient[0]);
    }

    static void deserializeSubscribedClientCallback(SubscribedClient subscribedClient, String name, String valueJson) throws Exception {
        String str = name;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"clientId")) {
                if (Global.equals((Object)str, (Object)"boundRecords")) {
                    subscribedClient.setBoundRecords(Serializer.deserializeBoundRecords(valueJson));
                }
            } else {
                subscribedClient.setClientId(fm.Serializer.deserializeGuid((String)valueJson).getValue());
            }
        }
    }

    public static Subscription deserializeSubscription(String subscriptionJson) throws Exception {
        return (Subscription)fm.Serializer.deserializeObjectFast((String)subscriptionJson, (EmptyFunction)new EmptyFunction<Subscription>(){

            public Subscription invoke() {
                try {
                    return Serializer.createSubscription();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Subscription>(){

            public void invoke(Subscription subscription, String name, String valueJson) {
                try {
                    Serializer.deserializeSubscriptionCallback(subscription, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
    }

    public static Subscription[] deserializeSubscriptionArray(String subscriptionsJson) throws Exception {
        ArrayList list = fm.Serializer.deserializeObjectArrayFast((String)subscriptionsJson, (EmptyFunction)new EmptyFunction<Subscription>(){

            public Subscription invoke() {
                try {
                    return Serializer.createSubscription();
                }
                catch (Exception _var0) {
                    return null;
                }
            }
        }, (DeserializeCallback)new DeserializeCallback<Subscription>(){

            public void invoke(Subscription subscription, String name, String valueJson) {
                try {
                    Serializer.deserializeSubscriptionCallback(subscription, name, valueJson);
                }
                catch (Exception _var1) {
                    // empty catch block
                }
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new Subscription[0]);
    }

    private static void deserializeSubscriptionCallback(Subscription subscription, String name, String valueJson) throws Exception {
        String str = name;
        if (str != null) {
            if (!Global.equals((Object)str, (Object)"channel")) {
                if (Global.equals((Object)str, (Object)"tag")) {
                    subscription.setTag(fm.Serializer.deserializeString((String)valueJson));
                }
            } else {
                subscription.setChannel(fm.Serializer.deserializeString((String)valueJson));
            }
        }
    }

    static Date deserializeTimestamp(String timestampJson) throws Exception {
        String str = fm.Serializer.deserializeString((String)timestampJson);
        Date utcNow = DateExtensions.getUtcNow();
        if (!StringExtensions.isNullOrEmpty((String)str)) {
            Object[] strArray = StringExtensions.split((String)str, (char[])new char[]{'T'});
            if (ArrayExtensions.getLength((Object[])strArray) != 2) {
                return utcNow;
            }
            Object str2 = strArray[0];
            Object str3 = strArray[1];
            strArray = StringExtensions.split((String)str2, (char[])new char[]{'-'});
            if (ArrayExtensions.getLength((Object[])strArray) != 3) {
                return utcNow;
            }
            Object s = strArray[0];
            Object str5 = strArray[1];
            Object str6 = strArray[2];
            strArray = StringExtensions.split((String)str3, (char[])new char[]{':'});
            if (ArrayExtensions.getLength((Object[])strArray) != 3) {
                return utcNow;
            }
            Object str7 = strArray[0];
            Object str8 = strArray[1];
            if (ArrayExtensions.getLength((Object[])(strArray = StringExtensions.split((String)strArray[2], (char[])new char[]{'.'}))) != 2) {
                return utcNow;
            }
            Object str10 = strArray[0];
            int intResult = 0;
            int num2 = 0;
            int num3 = 0;
            int num4 = 0;
            int num5 = 0;
            int num6 = 0;
            IntegerHolder _var0 = new IntegerHolder(intResult);
            boolean _var1 = ParseAssistant.tryParseIntegerValue((String)s, (IntegerHolder)_var0);
            intResult = _var0.getValue();
            IntegerHolder _var2 = new IntegerHolder(num2);
            boolean _var3 = ParseAssistant.tryParseIntegerValue((String)str5, (IntegerHolder)_var2);
            num2 = _var2.getValue();
            IntegerHolder _var4 = new IntegerHolder(num3);
            boolean _var5 = ParseAssistant.tryParseIntegerValue((String)str6, (IntegerHolder)_var4);
            num3 = _var4.getValue();
            IntegerHolder _var6 = new IntegerHolder(num4);
            boolean _var7 = ParseAssistant.tryParseIntegerValue((String)str7, (IntegerHolder)_var6);
            num4 = _var6.getValue();
            IntegerHolder _var8 = new IntegerHolder(num5);
            boolean _var9 = ParseAssistant.tryParseIntegerValue((String)str8, (IntegerHolder)_var8);
            num5 = _var8.getValue();
            IntegerHolder _var10 = new IntegerHolder(num6);
            boolean _var11 = ParseAssistant.tryParseIntegerValue((String)str10, (IntegerHolder)_var10);
            num6 = _var10.getValue();
            if (_var1 && _var3 && _var5 && _var7 && _var9 && _var11) {
                utcNow = DateExtensions.createDate((int)intResult, (int)num2, (int)num3, (int)num4, (int)num5, (int)num6);
            }
        }
        return utcNow;
    }

    public static String serializeAdvice(Advice advice) {
        return fm.Serializer.serializeObjectFast((Serializable)advice, (SerializeCallback)new SerializeCallback<Advice>(){

            public void invoke(Advice advice, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeAdviceCallback(advice, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeAdviceCallback(Advice advice, HashMap<String, String> jsonObject) {
        Serializer.serializeBaseAdviceCallback(advice, jsonObject);
        if (advice.getWebSocket() != null) {
            HashMapExtensions.getItem(jsonObject).put("websocket", Serializer.serializeBaseAdvice(advice.getWebSocket()));
        }
        if (advice.getLongPolling() != null) {
            HashMapExtensions.getItem(jsonObject).put("long-polling", Serializer.serializeBaseAdvice(advice.getLongPolling()));
        }
        if (advice.getCallbackPolling() != null) {
            HashMapExtensions.getItem(jsonObject).put("callback-polling", Serializer.serializeBaseAdvice(advice.getCallbackPolling()));
        }
    }

    public static String serializeBaseAdvice(BaseAdvice baseAdvice) {
        return fm.Serializer.serializeObjectFast((Serializable)baseAdvice, (SerializeCallback)new SerializeCallback<BaseAdvice>(){

            public void invoke(BaseAdvice baseAdvice, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeBaseAdviceCallback(baseAdvice, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeBaseAdviceCallback(BaseAdvice baseAdvice, HashMap<String, String> jsonObject) {
        if (baseAdvice.getHosts() != null) {
            HashMapExtensions.getItem(jsonObject).put("hosts", fm.Serializer.serializeStringArray((String[])baseAdvice.getHosts()));
        }
        if (baseAdvice.getInterval().getHasValue()) {
            HashMapExtensions.getItem(jsonObject).put("interval", fm.Serializer.serializeInteger((NullableInteger)baseAdvice.getInterval()));
        }
        if (baseAdvice.getReconnect().getHasValue()) {
            HashMapExtensions.getItem(jsonObject).put("reconnect", Serializer.serializeReconnect(baseAdvice.getReconnect().getValue()));
        }
    }

    public static String serializeBoundRecords(HashMap<String, Record> boundRecords) {
        return fm.Serializer.serializeObject(boundRecords, (SerializeCallback)new SerializeCallback<HashMap<String, Record>>(){

            public void invoke(HashMap<String, Record> boundRecords, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeBoundRecordsCallback(boundRecords, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeBoundRecordsCallback(HashMap<String, Record> boundRecords, HashMap<String, String> jsonObject) {
        for (String str : HashMapExtensions.getKeys(boundRecords)) {
            HashMapExtensions.getItem(jsonObject).put(str, fm.Serializer.serializeRaw((String)((Record)((Object)HashMapExtensions.getItem(boundRecords).get(str))).getValueJson()));
        }
    }

    public static String serializeConnectionType(ConnectionType connectionType) {
        String str = null;
        ConnectionType _var0 = connectionType;
        if (_var0 == ConnectionType.WebSocket) {
            str = "websocket";
        } else if (_var0 == ConnectionType.LongPolling) {
            str = "long-polling";
        } else if (_var0 == ConnectionType.CallbackPolling) {
            str = "callback-polling";
        } else if (_var0 == ConnectionType.IFrame) {
            str = "iframe";
        } else if (_var0 == ConnectionType.Flash) {
            str = "flash";
        }
        return fm.Serializer.serializeString((String)str);
    }

    public static String serializeConnectionTypeArray(ConnectionType[] connectionTypes) {
        String[] strArray = new String[ArrayExtensions.getLength((Object[])connectionTypes)];
        for (int i = 0; i < ArrayExtensions.getLength((Object[])connectionTypes); ++i) {
            strArray[i] = Serializer.serializeConnectionType(connectionTypes[i]);
        }
        return StringExtensions.concat((String)"[", (String)StringExtensions.join((String)",", (String[])strArray), (String)"]");
    }

    public static String serializeExtensions(Extensions extensions) {
        return fm.Serializer.serializeObjectFast((Serializable)extensions, (SerializeCallback)new SerializeCallback<Extensions>(){

            public void invoke(Extensions extensions, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeExtensionsCallback(extensions, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeExtensionsCallback(Extensions extensions, HashMap<String, String> jsonObject) {
        for (String str : extensions.getNames()) {
            HashMapExtensions.getItem(jsonObject).put(str, fm.Serializer.serializeRaw((String)extensions.getValueJson(str)));
        }
    }

    public static String serializeMessage(Message message) {
        return fm.Serializer.serializeObjectFast((Serializable)message, (SerializeCallback)new SerializeCallback<Message>(){

            public void invoke(Message message, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeMessageCallback(message, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static String serializeMessageArray(Message[] messages) {
        return fm.Serializer.serializeObjectArrayFast((Serializable[])messages, (SerializeCallback)new SerializeCallback<Message>(){

            public void invoke(Message message, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeMessageCallback(message, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeMessageCallback(Message message, HashMap<String, String> jsonObject) {
        if (message.getClientId().getHasValue()) {
            HashMapExtensions.getItem(jsonObject).put("clientId", fm.Serializer.serializeGuid((NullableGuid)message.getClientId()));
        }
        if (message.getTimestamp().getHasValue()) {
            HashMapExtensions.getItem(jsonObject).put("timestamp", Serializer.serializeTimestamp(message.getTimestamp()));
        }
        if (message.getAdvice() != null) {
            HashMapExtensions.getItem(jsonObject).put("advice", Serializer.serializeAdvice(message.getAdvice()));
        }
        if (message.getRecords() != null && (Global.equals((Object)((Object)message.getType()), (Object)((Object)MessageType.Bind)) || Global.equals((Object)((Object)message.getType()), (Object)((Object)MessageType.Unbind)))) {
            HashMapExtensions.getItem(jsonObject).put("binding", Serializer.serializeRecordArray(message.getRecords()));
        }
        if (message.getBayeuxChannel() != null) {
            HashMapExtensions.getItem(jsonObject).put("channel", fm.Serializer.serializeString((String)message.getBayeuxChannel()));
        }
        if (message.getConnectionType().getHasValue()) {
            HashMapExtensions.getItem(jsonObject).put("connectionType", Serializer.serializeConnectionType(message.getConnectionType().getValue()));
        }
        if (message.getDataJson() != null) {
            HashMapExtensions.getItem(jsonObject).put("data", fm.Serializer.serializeRaw((String)message.getDataJson()));
        }
        if (message.getError() != null) {
            HashMapExtensions.getItem(jsonObject).put("error", fm.Serializer.serializeString((String)message.getError()));
        }
        if (message.getExtensions().getCount() > 0) {
            HashMapExtensions.getItem(jsonObject).put("ext", Serializer.serializeExtensions(message.getExtensions()));
        }
        if (message.getId() != null) {
            HashMapExtensions.getItem(jsonObject).put("id", fm.Serializer.serializeString((String)message.getId()));
        }
        if (message.getMinimumVersion() != null) {
            HashMapExtensions.getItem(jsonObject).put("minimumVersion", fm.Serializer.serializeString((String)message.getMinimumVersion()));
        }
        if (message.getChannels() != null && (Global.equals((Object)((Object)message.getType()), (Object)((Object)MessageType.Subscribe)) || Global.equals((Object)((Object)message.getType()), (Object)((Object)MessageType.Unsubscribe)))) {
            HashMapExtensions.getItem(jsonObject).put("subscription", fm.Serializer.serializeStringArray((String[])message.getChannels()));
        }
        if (message.getSuccessful()) {
            HashMapExtensions.getItem(jsonObject).put("successful", fm.Serializer.serializeBoolean((NullableBoolean)new NullableBoolean(message.getSuccessful())));
        }
        if (message.getSupportedConnectionTypes() != null) {
            HashMapExtensions.getItem(jsonObject).put("supportedConnectionTypes", Serializer.serializeConnectionTypeArray(message.getSupportedConnectionTypes()));
        }
        if (message.getVersion() != null) {
            HashMapExtensions.getItem(jsonObject).put("version", fm.Serializer.serializeString((String)message.getVersion()));
        }
    }

    public static String serializeNotification(Notification notification) {
        return fm.Serializer.serializeObjectFast((Serializable)notification, (SerializeCallback)new SerializeCallback<Notification>(){

            public void invoke(Notification notification, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeNotificationCallback(notification, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static String serializeNotificationArray(Notification[] notifications) {
        return fm.Serializer.serializeObjectArrayFast((Serializable[])notifications, (SerializeCallback)new SerializeCallback<Notification>(){

            public void invoke(Notification notification, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeNotificationCallback(notification, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeNotificationCallback(Notification notification, HashMap<String, String> jsonObject) {
        if (notification.getError() != null) {
            HashMapExtensions.getItem(jsonObject).put("error", fm.Serializer.serializeString((String)notification.getError()));
        }
        if (notification.getSuccessful()) {
            HashMapExtensions.getItem(jsonObject).put("successful", fm.Serializer.serializeBoolean((NullableBoolean)new NullableBoolean(notification.getSuccessful())));
        }
        if (notification.getTimestamp().getHasValue()) {
            HashMapExtensions.getItem(jsonObject).put("timestamp", Serializer.serializeTimestamp(notification.getTimestamp()));
        }
        if (notification.getExtensions().getCount() > 0) {
            HashMapExtensions.getItem(jsonObject).put("ext", Serializer.serializeExtensions(notification.getExtensions()));
        }
        if (notification.getDataJson() != null) {
            HashMapExtensions.getItem(jsonObject).put("data", fm.Serializer.serializeRaw((String)notification.getDataJson()));
        }
    }

    public static String serializeNotifyingClient(NotifyingClient notifyingClient) {
        return fm.Serializer.serializeObjectFast((Serializable)notifyingClient, (SerializeCallback)new SerializeCallback<NotifyingClient>(){

            public void invoke(NotifyingClient notifyingClient, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeNotifyingClientCallback(notifyingClient, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeNotifyingClientCallback(NotifyingClient notifyingClient, HashMap<String, String> jsonObject) {
        if (notifyingClient.getClientId().getHasValue()) {
            HashMapExtensions.getItem(jsonObject).put("clientId", fm.Serializer.serializeGuid((NullableGuid)notifyingClient.getClientId()));
        }
        if (notifyingClient.getBoundRecords() != null) {
            HashMapExtensions.getItem(jsonObject).put("boundRecords", Serializer.serializeBoundRecords(notifyingClient.getBoundRecords()));
        }
    }

    public static String serializePublication(Publication publication) {
        return fm.Serializer.serializeObjectFast((Serializable)publication, (SerializeCallback)new SerializeCallback<Publication>(){

            public void invoke(Publication publication, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializePublicationCallback(publication, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static String serializePublicationArray(Publication[] publications) {
        return fm.Serializer.serializeObjectArrayFast((Serializable[])publications, (SerializeCallback)new SerializeCallback<Publication>(){

            public void invoke(Publication publication, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializePublicationCallback(publication, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializePublicationCallback(Publication publication, HashMap<String, String> jsonObject) {
        if (publication.getChannel() != null) {
            HashMapExtensions.getItem(jsonObject).put("channel", fm.Serializer.serializeString((String)publication.getChannel()));
        }
        if (publication.getError() != null) {
            HashMapExtensions.getItem(jsonObject).put("error", fm.Serializer.serializeString((String)publication.getError()));
        }
        if (publication.getSuccessful()) {
            HashMapExtensions.getItem(jsonObject).put("successful", fm.Serializer.serializeBoolean((NullableBoolean)new NullableBoolean(publication.getSuccessful())));
        }
        if (publication.getTimestamp().getHasValue()) {
            HashMapExtensions.getItem(jsonObject).put("timestamp", Serializer.serializeTimestamp(publication.getTimestamp()));
        }
        if (publication.getExtensions().getCount() > 0) {
            HashMapExtensions.getItem(jsonObject).put("ext", Serializer.serializeExtensions(publication.getExtensions()));
        }
        if (publication.getDataJson() != null) {
            HashMapExtensions.getItem(jsonObject).put("data", fm.Serializer.serializeRaw((String)publication.getDataJson()));
        }
    }

    public static String serializePublishingClient(PublishingClient publishingClient) {
        return fm.Serializer.serializeObjectFast((Serializable)publishingClient, (SerializeCallback)new SerializeCallback<PublishingClient>(){

            public void invoke(PublishingClient publishingClient, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializePublishingClientCallback(publishingClient, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializePublishingClientCallback(PublishingClient publishingClient, HashMap<String, String> jsonObject) {
        if (publishingClient.getClientId().getHasValue()) {
            HashMapExtensions.getItem(jsonObject).put("clientId", fm.Serializer.serializeGuid((NullableGuid)publishingClient.getClientId()));
        }
        if (publishingClient.getBoundRecords() != null) {
            HashMapExtensions.getItem(jsonObject).put("boundRecords", Serializer.serializeBoundRecords(publishingClient.getBoundRecords()));
        }
    }

    public static String serializeReconnect(Reconnect reconnect) {
        String str = null;
        Reconnect _var0 = reconnect;
        if (_var0 == Reconnect.Retry) {
            str = "retry";
        } else if (_var0 == Reconnect.Handshake) {
            str = "handshake";
        } else if (_var0 == Reconnect.None) {
            str = "none";
        }
        return fm.Serializer.serializeString((String)str);
    }

    public static String serializeRecord(Record record) {
        return fm.Serializer.serializeObjectFast((Serializable)record, (SerializeCallback)new SerializeCallback<Record>(){

            public void invoke(Record record, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeRecordCallback(record, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static String serializeRecordArray(Record[] records) {
        return fm.Serializer.serializeObjectArrayFast((Serializable[])records, (SerializeCallback)new SerializeCallback<Record>(){

            public void invoke(Record record, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeRecordCallback(record, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeRecordCallback(Record record, HashMap<String, String> jsonObject) {
        if (record.getKey() != null) {
            HashMapExtensions.getItem(jsonObject).put("key", fm.Serializer.serializeString((String)record.getKey()));
        }
        if (record.getPrivate()) {
            HashMapExtensions.getItem(jsonObject).put("private", fm.Serializer.serializeBoolean((NullableBoolean)new NullableBoolean(record.getPrivate())));
        }
        if (record.getValueJson() != null) {
            HashMapExtensions.getItem(jsonObject).put("value", fm.Serializer.serializeRaw((String)record.getValueJson()));
        }
    }

    public static String serializeSubscribedClient(SubscribedClient subscribedClient) {
        return fm.Serializer.serializeObjectFast((Serializable)subscribedClient, (SerializeCallback)new SerializeCallback<SubscribedClient>(){

            public void invoke(SubscribedClient subscribedClient, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeSubscribedClientCallback(subscribedClient, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static String serializeSubscribedClientArray(SubscribedClient[] subscribedClients) {
        return fm.Serializer.serializeObjectArrayFast((Serializable[])subscribedClients, (SerializeCallback)new SerializeCallback<SubscribedClient>(){

            public void invoke(SubscribedClient subscribedClient, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeSubscribedClientCallback(subscribedClient, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static void serializeSubscribedClientCallback(SubscribedClient subscribedClient, HashMap<String, String> jsonObject) {
        HashMapExtensions.getItem(jsonObject).put("clientId", fm.Serializer.serializeGuid((NullableGuid)new NullableGuid(subscribedClient.getClientId())));
        if (subscribedClient.getBoundRecords() != null) {
            HashMapExtensions.getItem(jsonObject).put("boundRecords", Serializer.serializeBoundRecords(subscribedClient.getBoundRecords()));
        }
    }

    public static String serializeSubscription(Subscription subscription) {
        return fm.Serializer.serializeObjectFast((Serializable)subscription, (SerializeCallback)new SerializeCallback<Subscription>(){

            public void invoke(Subscription subscription, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeSubscriptionCallback(subscription, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static String serializeSubscriptionArray(Subscription[] subscriptions) {
        return fm.Serializer.serializeObjectArrayFast((Serializable[])subscriptions, (SerializeCallback)new SerializeCallback<Subscription>(){

            public void invoke(Subscription subscription, HashMap<String, String> jsonObject) {
                try {
                    Serializer.serializeSubscriptionCallback(subscription, jsonObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private static void serializeSubscriptionCallback(Subscription subscription, HashMap<String, String> jsonObject) {
        HashMapExtensions.getItem(jsonObject).put("channel", fm.Serializer.serializeString((String)subscription.getChannel()));
        if (subscription.getTag() != null) {
            HashMapExtensions.getItem(jsonObject).put("tag", fm.Serializer.serializeString((String)subscription.getTag()));
        }
    }

    static String serializeTimestamp(NullableDate timestamp) {
        String str = null;
        if (timestamp.getHasValue()) {
            String str2 = IntegerExtensions.toString((Integer)DateExtensions.getYear((Date)timestamp.getValue()));
            String str3 = IntegerExtensions.toString((Integer)DateExtensions.getMonth((Date)timestamp.getValue()));
            String str4 = IntegerExtensions.toString((Integer)DateExtensions.getDay((Date)timestamp.getValue()));
            String str5 = IntegerExtensions.toString((Integer)DateExtensions.getHour((Date)timestamp.getValue()));
            String str6 = IntegerExtensions.toString((Integer)DateExtensions.getMinute((Date)timestamp.getValue()));
            String str7 = IntegerExtensions.toString((Integer)DateExtensions.getSecond((Date)timestamp.getValue()));
            while (StringExtensions.getLength((String)str2) < 4) {
                str2 = StringExtensions.concat((String)"0", (String)str2);
            }
            while (StringExtensions.getLength((String)str3) < 2) {
                str3 = StringExtensions.concat((String)"0", (String)str3);
            }
            while (StringExtensions.getLength((String)str4) < 2) {
                str4 = StringExtensions.concat((String)"0", (String)str4);
            }
            while (StringExtensions.getLength((String)str5) < 2) {
                str5 = StringExtensions.concat((String)"0", (String)str5);
            }
            while (StringExtensions.getLength((String)str6) < 2) {
                str6 = StringExtensions.concat((String)"0", (String)str6);
            }
            while (StringExtensions.getLength((String)str7) < 2) {
                str7 = StringExtensions.concat((String)"0", (String)str7);
            }
            str = StringExtensions.format((String)"{0}-{1}-{2}T{3}:{4}:{5}.00", (Object[])new Object[]{str2, str3, str4, str5, str6, str7});
        }
        return fm.Serializer.serializeString(str);
    }
}

