/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vpx;

import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoEncoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.vpx.Codec;
import fm.icelink.vpx.EncoderConfig;
import fm.icelink.vpx.Native;

public abstract class Encoder
extends VideoEncoder {
    private EncoderConfig __config;
    private Native __encoder = new Native(true);
    private int __userSetBitrate = -1;

    protected void doDestroy() {
        this.__encoder.destroy();
        this.__encoder = null;
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        VideoBuffer buffer;
        int maxOutputBitrate = this.getMaxOutputBitrate();
        if (maxOutputBitrate > 0 && maxOutputBitrate != this.__encoder.getBitrate()) {
            Log.debug((String)StringExtensions.concat((Object[])new String[]{this.getLabel(), " bitrate changing from ", IntegerExtensions.toString((Integer)this.__encoder.getBitrate()), " to ", IntegerExtensions.toString((Integer)maxOutputBitrate)}));
            this.__encoder.setBitrate(maxOutputBitrate);
        }
        if ((buffer = this.__encoder.encode(inputBuffer.toPlanar(), (VideoFormat)super.getOutputFormat())) != null) {
            if (this.isKeyFrame(buffer.getDataBuffer())) {
                Log.debug((String)StringExtensions.concat((String)this.getLabel(), (String)" generated keyframe."));
            }
            frame.addBuffer((MediaBuffer)buffer);
            this.raiseFrame(frame);
            buffer.getDataBuffer().free();
        }
    }

    public Encoder(VideoFormat outputFormat) {
        super(VideoFormat.getI420(), outputFormat);
        this.__encoder.setCodec(this.getCodec());
        this.__config = new EncoderConfig();
        this.setCodecConfig(this.__config);
    }

    public int getBitrate() {
        return this.__encoder.getBitrate();
    }

    public abstract Codec getCodec();

    public EncoderConfig getCodecConfig() {
        return this.__config.deepCopy();
    }

    public boolean getForceKeyFrame() {
        return this.__encoder.getForceKeyFrame();
    }

    public int getMaxOutputBitrate() {
        int maxOutputBitrate = super.getMaxOutputBitrate();
        return this.__userSetBitrate < 0 ? maxOutputBitrate : (maxOutputBitrate < 0 ? this.__userSetBitrate : MathAssistant.min((int)this.__userSetBitrate, (int)maxOutputBitrate));
    }

    public double getQuality() {
        return 1.0 - (double)(this.__config.getMaxQuantizer() - 31) / 32.0;
    }

    protected abstract boolean isKeyFrame(DataBuffer var1);

    public void setBitrate(int value) {
        this.__userSetBitrate = value;
        this.__encoder.setBitrate(this.__userSetBitrate);
    }

    public int setCodecConfig(EncoderConfig config) {
        int num = this.__encoder.setEncoderConfig(config.getNativeConfig());
        if (num == 0) {
            this.__config = config.deepCopy();
        }
        return num;
    }

    public void setForceKeyFrame(boolean value) {
        this.__encoder.setForceKeyFrame(value);
    }

    public void setQuality(double value) {
        double num = value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
        int num2 = 31 + (int)((1.0 - num) * 32.0);
        if (num2 != this.__config.getMaxQuantizer()) {
            this.__config.setMaxQuantizer(num2);
            if (this.setCodecConfig(this.__config) != 0) {
                throw new RuntimeException(new Exception(StringExtensions.concat((String)"Unable to update ", (String)this.getLabel(), (String)" configuration.")));
            }
        }
    }
}

