/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.opus;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.DataBuffer;
import fm.icelink.Future;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.ManagedThread;
import fm.icelink.Promise;
import fm.icelink.opus.Decoder;
import fm.icelink.opus.Encoder;

public class Utility {
    private static void doInitialize(final Encoder encoder, final Decoder decoder, final Promise<Object> promise) {
        decoder.addOnRaiseFrame((IAction1)new IAction1<AudioFrame>(){

            public void invoke(AudioFrame frame) {
                promise.resolve(null);
                ManagedThread.dispatch((IAction0)new IAction0(){

                    public void invoke() {
                        encoder.destroy();
                        decoder.destroy();
                    }
                });
            }
        });
        encoder.addOnRaiseFrame((IAction1)new IAction1<AudioFrame>(){

            public void invoke(AudioFrame encodedFrame) {
                try {
                    decoder.processFrame(new AudioFrame(-1.0, (AudioBuffer)encodedFrame.getLastBuffer()));
                }
                catch (Exception exception) {
                    promise.reject(exception);
                }
            }
        });
        int num = 20;
        AudioFormat inputFormat = (AudioFormat)encoder.getInputFormat();
        encoder.processFrame(new AudioFrame((double)num, new AudioBuffer(DataBuffer.wrap((byte[])new byte[inputFormat.getClockRate() * inputFormat.getChannelCount() * 2 * num / 1000], (boolean)true), inputFormat)));
    }

    private static Future<Object> initialize(Encoder encoder, Decoder decoder) {
        Promise promise = new Promise();
        try {
            Utility.doInitialize(encoder, decoder, (Promise<Object>)promise);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public static Future<Object> initialize() {
        return Utility.initialize(new Encoder(), new Decoder());
    }
}

