/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.AddressType;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.LocalNetwork;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.stun.Attribute;

public class MappedAddressAttribute
extends Attribute {
    private String _ipAddress;
    private int _port;

    public String getIPAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._port;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getMappedAddressType();
    }

    @Override
    protected int getValueLength() {
        if (Global.equals((Object)LocalNetwork.getAddressType(this.getIPAddress()), (Object)AddressType.IPv4)) {
            return 8;
        }
        return 20;
    }

    public MappedAddressAttribute(String ipAddress, int port) {
        this.setIPAddress(TransportAddress.sanitizeIPAddress(ipAddress));
        this.setPort(port);
    }

    private MappedAddressAttribute() {
    }

    public static MappedAddressAttribute readValueFrom(DataBuffer buffer, int offset) {
        AddressType addressType = Attribute.readAddressType(buffer, offset + 1);
        if (Global.equals((Object)addressType, (Object)AddressType.getByAssignedValue(0))) {
            return null;
        }
        MappedAddressAttribute attribute = new MappedAddressAttribute();
        attribute.setPort(Attribute.readPort(buffer, offset + 2));
        attribute.setIPAddress(Attribute.readIPAddress(buffer, offset + 4, addressType));
        return attribute;
    }

    public void setIPAddress(String value) {
        this._ipAddress = value;
    }

    public void setPort(int value) {
        this._port = value;
    }

    public String toString() {
        return StringExtensions.format("MAPPED-ADDRESS {0}:{1}", this.getIPAddress(), IntegerExtensions.toString(this.getPort()));
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        AddressType addressType = LocalNetwork.getAddressType(this.getIPAddress());
        buffer.write8(0, offset);
        Attribute.writeAddressType(buffer, offset + 1, addressType);
        super.writePort(buffer, offset + 2, this.getPort());
        super.writeIPAddress(buffer, offset + 4, addressType, this.getIPAddress());
    }
}

