/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1Null;
import fm.icelink.Asn1ObjectIdentifier;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import java.util.ArrayList;

class X509AlgorithmIdentifier {
    private long[] _algorithm;
    private byte[] _parameters;

    public static boolean algorithmsAreEqual(X509AlgorithmIdentifier ai1, X509AlgorithmIdentifier ai2) {
        if (ai1 == null != (ai2 == null)) {
            return false;
        }
        return ai1 == null || Asn1ObjectIdentifier.areEqual(ai1.getAlgorithm(), ai2.getAlgorithm());
    }

    public static boolean areEqual(X509AlgorithmIdentifier ai1, X509AlgorithmIdentifier ai2) {
        return X509AlgorithmIdentifier.algorithmsAreEqual(ai1, ai2) && X509AlgorithmIdentifier.parametersAreEqual(ai1, ai2);
    }

    public static X509AlgorithmIdentifier fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 1) {
            return null;
        }
        X509AlgorithmIdentifier identifier = new X509AlgorithmIdentifier();
        identifier.setAlgorithm(((Asn1ObjectIdentifier)sequence.getValues()[0]).getValues());
        if (ArrayExtensions.getLength(sequence.getValues()) > 1) {
            identifier.setParameters(sequence.getValues()[1].getBytes());
        }
        return identifier;
    }

    public long[] getAlgorithm() {
        return this._algorithm;
    }

    public static X509AlgorithmIdentifier getDsaWithSha1() {
        return new X509AlgorithmIdentifier(new long[]{1L, 2L, 840L, 10040L, 4L, 3L});
    }

    public static X509AlgorithmIdentifier getMd2WithRsaEncryption() {
        return new X509AlgorithmIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 1L, 2L}, new Asn1Null().getBytes());
    }

    public static X509AlgorithmIdentifier getMd5WithRsaEncryption() {
        return new X509AlgorithmIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 1L, 4L}, new Asn1Null().getBytes());
    }

    public byte[] getParameters() {
        return this._parameters;
    }

    public static X509AlgorithmIdentifier getRsaEncryption() {
        return new X509AlgorithmIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 1L, 1L}, new Asn1Null().getBytes());
    }

    public static X509AlgorithmIdentifier getSha1WithRsaEncryption() {
        return new X509AlgorithmIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 1L, 5L}, new Asn1Null().getBytes());
    }

    public static X509AlgorithmIdentifier getSha256WithRsaEncryption() {
        return new X509AlgorithmIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 1L, 11L}, new Asn1Null().getBytes());
    }

    public static X509AlgorithmIdentifier getSha384WithRsaEncryption() {
        return new X509AlgorithmIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 1L, 12L}, new Asn1Null().getBytes());
    }

    public static X509AlgorithmIdentifier getSha512WithRsaEncryption() {
        return new X509AlgorithmIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 1L, 13L}, new Asn1Null().getBytes());
    }

    public static boolean parametersAreEqual(X509AlgorithmIdentifier ai1, X509AlgorithmIdentifier ai2) {
        if (ai1 == null != (ai2 == null)) {
            return false;
        }
        if (ai1 != null) {
            if (ai1.getParameters() == null != (ai2.getParameters() == null)) {
                return false;
            }
            if (ai1.getParameters() == null) {
                return true;
            }
            for (int i = 0; i < ArrayExtensions.getLength(ai1.getParameters()); ++i) {
                if (ai1.getParameters()[i] == ai2.getParameters()[i]) continue;
                return false;
            }
        }
        return true;
    }

    public void setAlgorithm(long[] value) {
        this._algorithm = value;
    }

    public void setParameters(byte[] value) {
        this._parameters = value;
    }

    public Asn1Sequence toAsn1() {
        ArrayList<Asn1Any> list = new ArrayList<Asn1Any>();
        list.add(new Asn1ObjectIdentifier(this.getAlgorithm()));
        if (this.getParameters() != null) {
            list.add(Asn1Any.parseBytes(this.getParameters()));
        }
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }

    public X509AlgorithmIdentifier(long[] algorithm, byte[] parameters) {
        this.setAlgorithm(algorithm);
        this.setParameters(parameters);
    }

    public X509AlgorithmIdentifier() {
    }

    public X509AlgorithmIdentifier(long[] algorithm) {
        this(algorithm, null);
    }
}

