/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.LinkedList;
import fm.icelink.ManagedCondition;
import fm.icelink.ManagedThread;
import fm.icelink.Transport;
import java.util.ArrayList;
import java.util.List;

class VirtualLoopTransport
extends Transport {
    private volatile boolean __active = false;
    private ManagedCondition __condition;
    private List<IAction1<DataBuffer>> __onReceive = new ArrayList<IAction1<DataBuffer>>();
    private LinkedList<DataBuffer> __sendBuffer;
    private volatile boolean __stopped = false;
    private ManagedThread __thread;
    private IAction1<DataBuffer> _onReceive = null;

    @Override
    public void addOnReceive(IAction1<DataBuffer> value) {
        if (value != null) {
            if (this._onReceive == null) {
                this._onReceive = new IAction1<DataBuffer>(){

                    @Override
                    public void invoke(DataBuffer p0) {
                        for (IAction1 action : new ArrayList(VirtualLoopTransport.this.__onReceive)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onReceive.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureLoop(ManagedThread thread) {
        while (this.__active) {
            IAction1<DataBuffer> onReceive;
            thread.loopBegin();
            if (this.__sendBuffer.getCount() > 0 && (onReceive = this._onReceive) != null) {
                do {
                    onReceive.invoke(this.__sendBuffer.getFirst().getValue());
                    this.__sendBuffer.removeFirst();
                } while (this.__sendBuffer.getCount() > 0);
            }
            ManagedCondition managedCondition = this.__condition;
            synchronized (managedCondition) {
                if (this.__active) {
                    this.__condition.halt(1);
                }
            }
            thread.loopEnd();
        }
        this.__stopped = true;
    }

    @Override
    public boolean getIsClosed() {
        return false;
    }

    @Override
    public void removeOnReceive(IAction1<DataBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceive, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceive.remove(value);
        if (this.__onReceive.size() == 0) {
            this._onReceive = null;
        }
    }

    @Override
    public void send(DataBuffer buffer) {
        this.__sendBuffer.addLast(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        IAction0 action = null;
        if (!this.__active) {
            ManagedCondition managedCondition = this.__condition;
            synchronized (managedCondition) {
                if (!this.__active) {
                    if (action == null) {
                        action = new IAction0(){

                            @Override
                            public void invoke() {
                                VirtualLoopTransport.this.__active = true;
                                VirtualLoopTransport.this.__stopped = false;
                                VirtualLoopTransport.this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

                                    @Override
                                    public String getId() {
                                        return "fm.icelink.VirtualLoopTransport.captureLoop";
                                    }

                                    @Override
                                    public void invoke(ManagedThread thread) {
                                        VirtualLoopTransport.this.captureLoop(thread);
                                    }
                                });
                                VirtualLoopTransport.this.__thread.start();
                            }
                        };
                    }
                    ManagedThread.dispatch(action);
                }
            }
        }
    }

    public void stop() {
        IAction0 action = null;
        if (!this.__stopped) {
            if (action == null) {
                action = new IAction0(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void invoke() {
                        ManagedCondition managedCondition = VirtualLoopTransport.this.__condition;
                        synchronized (managedCondition) {
                            VirtualLoopTransport.this.__active = false;
                            VirtualLoopTransport.this.__condition.pulse();
                        }
                        while (!VirtualLoopTransport.this.__stopped) {
                            ManagedThread.sleep(10);
                        }
                    }
                };
            }
            ManagedThread.dispatch(action);
        }
    }

    public VirtualLoopTransport() {
        this.__condition = new ManagedCondition();
        this.__sendBuffer = new LinkedList();
    }
}

