/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Log;
import fm.icelink.Randomizer;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.SctpAuthenticatedChunksParameters;
import fm.icelink.SctpDynamicAddressReconfigurationSupportParameters;
import fm.icelink.SctpForwardTsnChunk;
import fm.icelink.SctpPartialReliabilitySupportParameters;
import fm.icelink.SctpSackChunk;
import fm.icelink.SctpStateCookie;
import fm.icelink.SctpStreamCollection;
import fm.icelink.SctpTcbState;
import java.util.Date;

class SctpTransmissionControlBlock {
    static int _ackNewDataPacketCountThreshold = 4;
    private long _advertisedReceiverWindowCredit;
    private int _associationPmtu;
    private SctpAuthenticatedChunksParameters _authenticatedChunksSupport;
    private long _congestionWindow;
    private boolean _cookieAckSent;
    static float _cwndsackTriggerLimit = 0.9f;
    public static int _defaultDestinationPort = 5000;
    public static int _defaultSourcePort = 5000;
    private int _destinationPort;
    private SctpDynamicAddressReconfigurationSupportParameters _dynamicAddressReconfigurationSupport;
    private long _earliestAllowedRetransmissionTime;
    private long _earliestAllowedSackSendTime;
    private boolean _extraPacketInFlight;
    private SctpSackChunk _freshestReceivedSack;
    private long _greatestCumulativeTsnReceived;
    private long _greatestReceivedTsn;
    public static float _immediateAckThreshold = 0.4f;
    private SctpStreamCollection _inboundStreams;
    public static int _initRetrasmitLifetime = 10000;
    private Date _lastSentTime = new Date();
    public static int _maxAckDelay = 500;
    public static int _maxDataChunkSize = 950;
    public static int _maxDataPacketPayloadSize = 1050;
    public static int _maxFTSNDelay = 500;
    private long _maximumStaticCongestionWindow;
    public static long _maxInitiateTag = 0xFFFFFFFFL;
    static long _maxNumberStreamFormats = 0xFFFFFFFFL;
    public static int _maxSsn = 65535;
    public static long _maxSuggestedCookieLifespanIncrement = 0xFFFFFFFFL;
    public static long _maxTsn = 0xFFFFFFFFL;
    private SctpForwardTsnChunk _mostRecentOutgoingForwardTsnChunk;
    private long _myVerificationTag;
    private long _nextTsnToSend;
    private int _numberOfDuplicateForwardTsnRequests;
    public static int _numberOfDuplicateTsnsToSkip = 1;
    public static int _numberOfPacketsProcessorYieldThreshold = 0;
    private SctpStreamCollection _outboundStreams;
    private int _overallErrorCount;
    private int _overallErrorThreshold;
    private long _partialBytesAcked;
    private SctpPartialReliabilitySupportParameters _partialReliabilitySupport;
    private long _peerReceiverWindowCredit;
    private long _peerVerificationTag;
    private boolean _processIncomingSack;
    private boolean _remoteLikelyInConnectedState;
    private long _retransmissionTimeout;
    private long _roundTripTimeVariation;
    public static float _rtoAlpha = 0.125f;
    public static float _rtoBeta = 0.25f;
    public static int _rtoInitial = 1000;
    public static int _rtoMax = 60000;
    public static int _rtoMin = 1000;
    private int _rtoPending;
    private int _sackCounter;
    private SctpSackChunk _sackOnReceivedData;
    private DataBuffer _secretKeyForCookie;
    private ScheduledItem _sendForwardTsnScheduledItem;
    private long _smoothedRoundTripTime;
    private int _sourcePort;
    private long _ssThresh;
    private SctpTcbState _state;
    public static int _t1InitRetransmissionInterval = 200;
    public static int _timeToYield = 1;
    public static int _validCookieLife = 12000;

    public long getAdvertisedReceiverWindowCredit() {
        return this._advertisedReceiverWindowCredit;
    }

    public int getAssociationPmtu() {
        return this._associationPmtu;
    }

    public SctpAuthenticatedChunksParameters getAuthenticatedChunksSupport() {
        return this._authenticatedChunksSupport;
    }

    public long getCongestionWindow() {
        return this._congestionWindow;
    }

    public boolean getCookieAckSent() {
        return this._cookieAckSent;
    }

    int getDestinationPort() {
        return this._destinationPort;
    }

    public SctpDynamicAddressReconfigurationSupportParameters getDynamicAddressReconfigurationSupport() {
        return this._dynamicAddressReconfigurationSupport;
    }

    public long getEarliestAllowedRetransmissionTime() {
        return this._earliestAllowedRetransmissionTime;
    }

    public long getEarliestAllowedSackSendTime() {
        return this._earliestAllowedSackSendTime;
    }

    public boolean getExtraPacketInFlight() {
        return this._extraPacketInFlight;
    }

    public SctpSackChunk getFreshestReceivedSack() {
        return this._freshestReceivedSack;
    }

    public long getGreatestCumulativeTsnReceived() {
        return this._greatestCumulativeTsnReceived;
    }

    public long getGreatestReceivedTsn() {
        return this._greatestReceivedTsn;
    }

    SctpStreamCollection getInboundStreams() {
        return this._inboundStreams;
    }

    public Date getLastSentTime() {
        return this._lastSentTime;
    }

    public long getMaximumStaticCongestionWindow() {
        return this._maximumStaticCongestionWindow;
    }

    public SctpForwardTsnChunk getMostRecentOutgoingForwardTsnChunk() {
        return this._mostRecentOutgoingForwardTsnChunk;
    }

    public long getMyVerificationTag() {
        return this._myVerificationTag;
    }

    public SctpStateCookie getNewCookie() {
        if (this.getSecretKeyForCookie() != null) {
            return new SctpStateCookie(this.getMyVerificationTag(), this.getPeerVerificationTag(), this.getPeerReceiverWindowCredit(), this.getGreatestReceivedTsn(), this.getOutboundStreams().getCount(), Scheduler.getCurrentTime(), this.getSecretKeyForCookie(), this.getDestinationPort(), this.getPartialReliabilitySupport() != null && this.getPartialReliabilitySupport().getPartialReliabilityUsedInThisAssociation());
        }
        Log.error("SCTP: Missing secret key to sign outgoing cookie.");
        return null;
    }

    public long getNextTsnToSend() {
        return this._nextTsnToSend;
    }

    public int getNumberOfDuplicateForwardTsnRequests() {
        return this._numberOfDuplicateForwardTsnRequests;
    }

    SctpStreamCollection getOutboundStreams() {
        return this._outboundStreams;
    }

    public int getOverallErrorCount() {
        return this._overallErrorCount;
    }

    public int getOverallErrorThreshold() {
        return this._overallErrorThreshold;
    }

    public long getPartialBytesAcked() {
        return this._partialBytesAcked;
    }

    public SctpPartialReliabilitySupportParameters getPartialReliabilitySupport() {
        return this._partialReliabilitySupport;
    }

    public long getPeerReceiverWindowCredit() {
        return this._peerReceiverWindowCredit;
    }

    public long getPeerVerificationTag() {
        return this._peerVerificationTag;
    }

    public boolean getProcessIncomingSack() {
        return this._processIncomingSack;
    }

    public boolean getRemoteLikelyInConnectedState() {
        return this._remoteLikelyInConnectedState;
    }

    public long getRetransmissionTimeout() {
        return this._retransmissionTimeout;
    }

    public long getRoundTripTimeVariation() {
        return this._roundTripTimeVariation;
    }

    public int getRtoPending() {
        return this._rtoPending;
    }

    public int getSackCounter() {
        return this._sackCounter;
    }

    public SctpSackChunk getSackOnReceivedData() {
        return this._sackOnReceivedData;
    }

    public DataBuffer getSecretKeyForCookie() {
        return this._secretKeyForCookie;
    }

    public ScheduledItem getSendForwardTsnScheduledItem() {
        return this._sendForwardTsnScheduledItem;
    }

    public long getSmoothedRoundTripTime() {
        return this._smoothedRoundTripTime;
    }

    int getSourcePort() {
        return this._sourcePort;
    }

    public long getSSThresh() {
        return this._ssThresh;
    }

    public SctpTcbState getState() {
        return this._state;
    }

    public void importTcbParameters(SctpTransmissionControlBlock tcb) {
        this.setMyVerificationTag(tcb.getMyVerificationTag());
        this.setPeerVerificationTag(tcb.getPeerVerificationTag());
        this.setPeerReceiverWindowCredit(tcb.getPeerReceiverWindowCredit());
        this.setNextTsnToSend(tcb.getNextTsnToSend());
        this.setGreatestReceivedTsn(tcb.getGreatestReceivedTsn());
        this.setGreatestCumulativeTsnReceived(tcb.getGreatestReceivedTsn());
        this.setOutboundStreams(tcb.getOutboundStreams());
        this.setDestinationPort(tcb.getDestinationPort());
        this.setPartialReliabilitySupport(tcb.getPartialReliabilitySupport());
        this.resetAssociationState();
    }

    public void resetAssociationState() {
        this.setRemoteLikelyInConnectedState(false);
        this.setSackCounter(4);
        this.setEarliestAllowedSackSendTime(ScheduledItem.getUnset());
        this.setEarliestAllowedRetransmissionTime(ScheduledItem.getUnset());
        this.setExtraPacketInFlight(false);
        this.setSackCounter(0);
        this.setRetransmissionTimeout(1000L);
        this.setCookieAckSent(false);
    }

    public SctpTransmissionControlBlock(SctpStateCookie cookie) {
        this(cookie.getMyVerificationTag(), cookie.getPeerVerificationTag(), cookie.getPeerReceiverWindowCredit(), cookie.getLastReceivedTsnFromPeer(), cookie.getNumberOfOutboundStreams(), null);
        this.setDestinationPort(cookie.getDestinationPort());
    }

    public SctpTransmissionControlBlock(long myVerificationTag, long peerVerificationTag, long peerReceiverWindowCredit, long lastReceivedTsnFromPeer, int numOutboundStreams, DataBuffer secretKey) {
        this.setEarliestAllowedSackSendTime(ScheduledItem.getUnset());
        this.setEarliestAllowedRetransmissionTime(ScheduledItem.getUnset());
        this.setMyVerificationTag(myVerificationTag);
        this.setPeerVerificationTag(peerVerificationTag);
        this.setPeerReceiverWindowCredit(peerReceiverWindowCredit);
        this.setNextTsnToSend(myVerificationTag);
        this.setGreatestReceivedTsn(lastReceivedTsnFromPeer);
        this.setOutboundStreams(new SctpStreamCollection(numOutboundStreams));
        this.setSecretKeyForCookie(secretKey);
        this.setRemoteLikelyInConnectedState(false);
        this.setDestinationPort(5000);
        this.setSourcePort(5000);
        this.setCookieAckSent(false);
    }

    public SctpTransmissionControlBlock(int oc, int ic, long a_rwnd) {
        this.setMyVerificationTag(0L);
        this.setCookieAckSent(false);
        this.setState(SctpTcbState.ClosedNeverOpened);
        this.setOutboundStreams(new SctpStreamCollection(oc));
        this.setInboundStreams(new SctpStreamCollection(ic));
        this.setAdvertisedReceiverWindowCredit(a_rwnd);
        this.setSecretKeyForCookie(DataBufferPool.getInstance().take(10));
        this.setSourcePort(5000);
        this.setDestinationPort(5000);
        new Randomizer().nextBytes(this.getSecretKeyForCookie().getData());
        this.resetAssociationState();
    }

    public void setAdvertisedReceiverWindowCredit(long value) {
        this._advertisedReceiverWindowCredit = value;
    }

    public void setAssociationPmtu(int value) {
        this._associationPmtu = value;
    }

    public void setAuthenticatedChunksSupport(SctpAuthenticatedChunksParameters value) {
        this._authenticatedChunksSupport = value;
    }

    public void setCongestionWindow(long value) {
        this._congestionWindow = value;
    }

    public void setCookieAckSent(boolean value) {
        this._cookieAckSent = value;
    }

    void setDestinationPort(int value) {
        this._destinationPort = value;
    }

    public void setDynamicAddressReconfigurationSupport(SctpDynamicAddressReconfigurationSupportParameters value) {
        this._dynamicAddressReconfigurationSupport = value;
    }

    public void setEarliestAllowedRetransmissionTime(long value) {
        this._earliestAllowedRetransmissionTime = value;
    }

    public void setEarliestAllowedSackSendTime(long value) {
        this._earliestAllowedSackSendTime = value;
    }

    public void setExtraPacketInFlight(boolean value) {
        this._extraPacketInFlight = value;
    }

    public void setFreshestReceivedSack(SctpSackChunk value) {
        this._freshestReceivedSack = value;
    }

    public void setGreatestCumulativeTsnReceived(long value) {
        this._greatestCumulativeTsnReceived = value;
    }

    public void setGreatestReceivedTsn(long value) {
        this._greatestReceivedTsn = value;
    }

    void setInboundStreams(SctpStreamCollection value) {
        this._inboundStreams = value;
    }

    public void setLastSentTime(Date value) {
        this._lastSentTime = value;
    }

    public void setMaximumStaticCongestionWindow(long value) {
        this._maximumStaticCongestionWindow = value;
    }

    public void setMostRecentOutgoingForwardTsnChunk(SctpForwardTsnChunk value) {
        this._mostRecentOutgoingForwardTsnChunk = value;
    }

    public void setMyVerificationTag(long value) {
        this._myVerificationTag = value;
    }

    public void setNextTsnToSend(long value) {
        this._nextTsnToSend = value;
    }

    public void setNumberOfDuplicateForwardTsnRequests(int value) {
        this._numberOfDuplicateForwardTsnRequests = value;
    }

    void setOutboundStreams(SctpStreamCollection value) {
        this._outboundStreams = value;
    }

    public void setOverallErrorCount(int value) {
        this._overallErrorCount = value;
    }

    public void setOverallErrorThreshold(int value) {
        this._overallErrorThreshold = value;
    }

    public void setPartialBytesAcked(long value) {
        this._partialBytesAcked = value;
    }

    public void setPartialReliabilitySupport(SctpPartialReliabilitySupportParameters value) {
        this._partialReliabilitySupport = value;
    }

    public void setPeerReceiverWindowCredit(long value) {
        this._peerReceiverWindowCredit = value;
    }

    public void setPeerVerificationTag(long value) {
        this._peerVerificationTag = value;
    }

    public void setProcessIncomingSack(boolean value) {
        this._processIncomingSack = value;
    }

    public void setRemoteLikelyInConnectedState(boolean value) {
        this._remoteLikelyInConnectedState = value;
    }

    public void setRetransmissionTimeout(long value) {
        this._retransmissionTimeout = value;
    }

    public void setRoundTripTimeVariation(long value) {
        this._roundTripTimeVariation = value;
    }

    public void setRtoPending(int value) {
        this._rtoPending = value;
    }

    public void setSackCounter(int value) {
        this._sackCounter = value;
    }

    public void setSackOnReceivedData(SctpSackChunk value) {
        this._sackOnReceivedData = value;
    }

    private void setSecretKeyForCookie(DataBuffer value) {
        this._secretKeyForCookie = value;
    }

    public void setSendForwardTsnScheduledItem(ScheduledItem value) {
        this._sendForwardTsnScheduledItem = value;
    }

    public void setSmoothedRoundTripTime(long value) {
        this._smoothedRoundTripTime = value;
    }

    void setSourcePort(int value) {
        this._sourcePort = value;
    }

    public void setSSThresh(long value) {
        this._ssThresh = value;
    }

    public void setState(SctpTcbState value) {
        this._state = value;
    }
}

