/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1Sequence;
import fm.icelink.AsymmetricKey;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.X509RsaPrivateKey;
import fm.icelink.X509RsaPublicKey;

public class RsaKey
extends AsymmetricKey {
    private byte[] _coefficient;
    private byte[] _exponent1;
    private byte[] _exponent2;
    private byte[] _modulus;
    private byte[] _prime1;
    private byte[] _prime2;
    private byte[] _privateExponent;
    private byte[] _publicExponent;

    public byte[] getBytes() {
        if (this.hasPrivate()) {
            X509RsaPrivateKey key = new X509RsaPrivateKey();
            key.setModulus(this.getModulus());
            key.setPublicExponent(this.getPublicExponent());
            key.setPrivateExponent(this.getPrivateExponent());
            key.setPrime1(this.getPrime1());
            key.setPrime2(this.getPrime2());
            key.setExponent1(this.getExponent1());
            key.setExponent2(this.getExponent2());
            key.setCoefficient(this.getCoefficient());
            return key.toAsn1().getBytes();
        }
        X509RsaPublicKey key2 = new X509RsaPublicKey();
        key2.setModulus(this.getModulus());
        key2.setExponent(this.getPublicExponent());
        return key2.toAsn1().getBytes();
    }

    public byte[] getCoefficient() {
        return this._coefficient;
    }

    public byte[] getExponent1() {
        return this._exponent1;
    }

    public byte[] getExponent2() {
        return this._exponent2;
    }

    public byte[] getModulus() {
        return this._modulus;
    }

    public byte[] getPrime1() {
        return this._prime1;
    }

    public byte[] getPrime2() {
        return this._prime2;
    }

    public byte[] getPrivateExponent() {
        return this._privateExponent;
    }

    public byte[] getPublicExponent() {
        return this._publicExponent;
    }

    @Override
    public boolean hasPrivate() {
        return this.hasPublic() && this.getPrivateExponent() != null && this.getPrime1() != null && this.getPrime2() != null && this.getExponent1() != null && this.getExponent2() != null && this.getCoefficient() != null;
    }

    @Override
    public boolean hasPublic() {
        return this.getModulus() != null && this.getPublicExponent() != null;
    }

    public static RsaKey parseBuffer(DataBuffer buffer) {
        Asn1Sequence any = Global.tryCast(Asn1Any.parseBuffer(buffer), Asn1Sequence.class);
        if (any != null) {
            X509RsaPublicKey key3;
            if (ArrayExtensions.getLength(any.getValues()) >= 8) {
                X509RsaPrivateKey key = X509RsaPrivateKey.fromAsn1(any);
                if (key != null) {
                    RsaKey key2 = new RsaKey();
                    key2.setModulus(key.getModulus());
                    key2.setPublicExponent(key.getPublicExponent());
                    key2.setPrivateExponent(key.getPrivateExponent());
                    key2.setPrime1(key.getPrime1());
                    key2.setPrime2(key.getPrime2());
                    key2.setExponent1(key.getExponent1());
                    key2.setExponent2(key.getExponent2());
                    key2.setCoefficient(key.getCoefficient());
                    return key2;
                }
            } else if (ArrayExtensions.getLength(any.getValues()) >= 2 && (key3 = X509RsaPublicKey.fromAsn1(any)) != null) {
                RsaKey key4 = new RsaKey();
                key4.setModulus(key3.getModulus());
                key4.setPublicExponent(key3.getExponent());
                return key4;
            }
        }
        return null;
    }

    public static RsaKey parseBytes(byte[] bytes) {
        return RsaKey.parseBuffer(DataBuffer.wrap(bytes));
    }

    public void setCoefficient(byte[] value) {
        this._coefficient = value;
    }

    public void setExponent1(byte[] value) {
        this._exponent1 = value;
    }

    public void setExponent2(byte[] value) {
        this._exponent2 = value;
    }

    public void setModulus(byte[] value) {
        this._modulus = value;
    }

    public void setPrime1(byte[] value) {
        this._prime1 = value;
    }

    public void setPrime2(byte[] value) {
        this._prime2 = value;
    }

    public void setPrivateExponent(byte[] value) {
        this._privateExponent = value;
    }

    public void setPublicExponent(byte[] value) {
        this._publicExponent = value;
    }
}

