/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.HashContextBase;
import fm.icelink.HashType;
import java.security.MessageDigest;

public class HashContext
extends HashContextBase {
    private MessageDigest _digest;

    public HashContext(HashType type) {
        super(type);
        try {
            String algorithmName;
            switch (type) {
                case Md5: {
                    algorithmName = "MD5";
                    break;
                }
                case Sha1: {
                    algorithmName = "SHA-1";
                    break;
                }
                case Sha256: {
                    algorithmName = "SHA-256";
                    break;
                }
                default: {
                    throw new Exception("Unrecognized hash type.");
                }
            }
            this._digest = MessageDigest.getInstance(algorithmName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected DataBuffer doCompute(DataBuffer input) {
        this._digest.update(input.getData(), input.getIndex(), input.getLength());
        return DataBuffer.wrap(this._digest.digest());
    }

    @Override
    protected void doDestroy() {
    }
}

