/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.FeedbackControlFrame;
import fm.icelink.FirEntry;
import fm.icelink.MediaControlFrame;
import fm.icelink.PayloadSpecificControlFrame;
import fm.icelink.Utility;

public class FirControlFrame
extends PayloadSpecificControlFrame {
    private FirEntry[] __entries;

    public FirControlFrame(int sequenceNumber) {
        this(new FirEntry(sequenceNumber));
    }

    public FirControlFrame(DataBuffer buffer) {
        super(FirControlFrame.getRegisteredFeedbackMessageType(), buffer);
        int num = super.getFeedbackControlInformation().getLength() / FirEntry.getFixedPayloadLength();
        this.setEntries(new FirEntry[num]);
        int offset = MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength();
        for (int i = 0; i < num; ++i) {
            this.getEntries()[i] = new FirEntry(buffer.subset(offset, FirEntry.getFixedPayloadLength()));
            offset += FirEntry.getFixedPayloadLength();
        }
    }

    public FirControlFrame(FirEntry entry) {
        FirEntry[] firEntryArray;
        if (entry == null) {
            firEntryArray = null;
        } else {
            FirEntry[] firEntryArray2 = new FirEntry[1];
            firEntryArray = firEntryArray2;
            firEntryArray2[0] = entry;
        }
        this(firEntryArray);
    }

    public FirControlFrame(FirEntry[] entries) {
        super(FirControlFrame.getRegisteredFeedbackMessageType(), DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength() + ArrayExtensions.getLength(entries) * FirEntry.getFixedPayloadLength()));
        this.setEntries(new FirEntry[ArrayExtensions.getLength(entries)]);
        int offset = 0;
        int length = 0;
        for (int i = 0; i < ArrayExtensions.getLength(entries); ++i) {
            length = entries[i].getDataBuffer().getLength();
            this.getEntries()[i] = new FirEntry(super.getFeedbackControlInformation().subset(offset, length));
            this.getEntries()[i].getDataBuffer().write(entries[i].getDataBuffer(), 0);
            offset += length;
        }
    }

    public FirEntry[] getEntries() {
        return this.__entries != null ? this.__entries : new FirEntry[]{};
    }

    public FirEntry getEntry() {
        return Utility.firstOrDefault(this.getEntries());
    }

    public static int getRegisteredFeedbackMessageType() {
        return 4;
    }

    public void setEntries(FirEntry[] value) {
        if (value == null) {
            value = new FirEntry[]{};
        }
        this.__entries = value;
    }

    public void setEntry(FirEntry value) {
        FirEntry[] firEntryArray;
        if (value == null) {
            firEntryArray = null;
        } else {
            FirEntry[] firEntryArray2 = new FirEntry[1];
            firEntryArray = firEntryArray2;
            firEntryArray2[0] = value;
        }
        this.setEntries(firEntryArray);
    }
}

