/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFormatCollection;
import fm.icelink.AudioFrame;
import fm.icelink.AudioTrack;
import fm.icelink.BandwidthAdaptationPolicy;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioInput;
import fm.icelink.IAudioInputCollection;
import fm.icelink.IAudioOutput;
import fm.icelink.IAudioOutputCollection;
import fm.icelink.IAudioStream;
import fm.icelink.IElement;
import fm.icelink.IInput;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaOutput;
import fm.icelink.IMediaStream;
import fm.icelink.IOutput;
import fm.icelink.IStream;
import fm.icelink.IntegerHolder;
import fm.icelink.JitterConfig;
import fm.icelink.LocalMedia;
import fm.icelink.MathAssistant;
import fm.icelink.MediaHeaderExtensionPolicy;
import fm.icelink.MediaStream;
import fm.icelink.NackPolicy;
import fm.icelink.ParseAssistant;
import fm.icelink.RedFecPolicy;
import fm.icelink.RemoteMedia;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.rtp.MapAttribute;

public class AudioStream
extends MediaStream<IAudioOutput, IAudioOutputCollection, IAudioInput, IAudioInputCollection, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat, AudioFormatCollection>
implements IAudioStream,
IMediaStream,
IStream,
IAudioInput,
IMediaInput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IInput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioOutput,
IMediaOutput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IOutput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioElement,
IMediaElement,
IElement {
    private double __gain;
    private double __volume;
    private AudioTrack _localTrack;
    private AudioTrack _remoteTrack;

    public AudioStream(IAudioOutput input, IAudioInput output) {
        IAudioInput[] iAudioInputArray;
        IAudioOutput[] iAudioOutputArray;
        if (input == null) {
            iAudioOutputArray = null;
        } else {
            IAudioOutput[] iAudioOutputArray2 = new IAudioOutput[1];
            iAudioOutputArray = iAudioOutputArray2;
            iAudioOutputArray2[0] = input;
        }
        if (output == null) {
            iAudioInputArray = null;
        } else {
            IAudioInput[] iAudioInputArray2 = new IAudioInput[1];
            iAudioInputArray = iAudioInputArray2;
            iAudioInputArray2[0] = output;
        }
        this(iAudioOutputArray, iAudioInputArray);
    }

    public AudioStream(AudioTrack localTrack) {
        this(localTrack, null);
    }

    public AudioStream(AudioTrack localTrack, AudioTrack remoteTrack) {
        this(localTrack == null ? null : (IAudioOutput[])localTrack.getOutputs(), remoteTrack == null ? null : (IAudioInput[])remoteTrack.getInputs());
        this.setLocalTrack(localTrack);
        this.setRemoteTrack(remoteTrack);
    }

    public AudioStream(IAudioInput[] outputs) {
        this(null, outputs);
    }

    public AudioStream(IAudioInput output) {
        IAudioInput[] iAudioInputArray;
        if (output == null) {
            iAudioInputArray = null;
        } else {
            IAudioInput[] iAudioInputArray2 = new IAudioInput[1];
            iAudioInputArray = iAudioInputArray2;
            iAudioInputArray2[0] = output;
        }
        this(iAudioInputArray);
    }

    public AudioStream(IAudioOutput input) {
        IAudioOutput[] iAudioOutputArray;
        if (input == null) {
            iAudioOutputArray = null;
        } else {
            IAudioOutput[] iAudioOutputArray2 = new IAudioOutput[1];
            iAudioOutputArray = iAudioOutputArray2;
            iAudioOutputArray2[0] = input;
        }
        this(iAudioOutputArray);
    }

    public AudioStream() {
        this(new IAudioOutput[0]);
    }

    public AudioStream(LocalMedia localMedia) {
        this(localMedia, null);
    }

    public AudioStream(IAudioOutput[] inputs, IAudioInput[] outputs) {
        super(StreamType.Audio, new JitterConfig());
        this.__gain = 1.0;
        this.__volume = 1.0;
        if (inputs == null && outputs == null) {
            throw new RuntimeException(new Exception("Cannot initialize audio stream if no inputs and no outputs are provided."));
        }
        super.setRedFecPolicy(RedFecPolicy.Disabled);
        super.setNackPolicy(NackPolicy.Disabled);
        if (inputs != null) {
            super.addInputs((IMediaOutput[])inputs);
        }
        if (outputs != null) {
            super.addOutputs((IMediaInput[])outputs);
        }
        super.setAbsoluteSenderTimePolicy(MediaHeaderExtensionPolicy.Disabled);
    }

    public AudioStream(IAudioOutput[] inputs) {
        this(inputs, null);
    }

    public AudioStream(RemoteMedia remoteMedia) {
        this(null, remoteMedia);
    }

    public AudioStream(LocalMedia localMedia, RemoteMedia remoteMedia) {
        this(localMedia == null ? null : (AudioTrack)localMedia.getAudioTrack(), remoteMedia == null ? null : (AudioTrack)remoteMedia.getAudioTrack());
        super.setLocalMedia(localMedia);
        super.setRemoteMedia(remoteMedia);
    }

    @Override
    protected AudioFormat createFormat(MapAttribute attribute) {
        return this.createFormat(attribute.getFormatName(), attribute.getClockRate(), attribute.getFormatParameters(), attribute.getPayloadType());
    }

    @Override
    protected AudioFormat createFormat(String name, int clockRate, String parameters, int payloadType) {
        int intResult = 1;
        IntegerHolder _var0 = new IntegerHolder(intResult);
        boolean _var1 = ParseAssistant.tryParseIntegerValue(parameters, _var0);
        intResult = _var0.getValue();
        if (!StringExtensions.isNullOrEmpty(parameters) && !_var1) {
            return null;
        }
        AudioFormat format = new AudioFormat(name, clockRate, intResult);
        format.setRegisteredPayloadType(payloadType);
        format.setIsPacketized(true);
        return format;
    }

    @Override
    protected IAudioInputCollection createInputCollection(IAudioOutput output) {
        return new IAudioInputCollection(output);
    }

    @Override
    protected AudioFormatCollection createMediaFormatCollection() {
        return new AudioFormatCollection();
    }

    @Override
    protected IAudioOutputCollection createOutputCollection(IAudioInput input) {
        return new IAudioOutputCollection(input);
    }

    @Override
    public AudioConfig getConfig() {
        return this.getOutputConfig();
    }

    @Override
    public double getGain() {
        return this.__gain;
    }

    public AudioConfig getInputConfig() {
        AudioFormat inputFormat = (AudioFormat)super.getInputFormat();
        if (inputFormat != null) {
            return inputFormat.getConfig();
        }
        return null;
    }

    public AudioTrack getLocalTrack() {
        return this._localTrack;
    }

    public AudioConfig getOutputConfig() {
        AudioFormat outputFormat = (AudioFormat)super.getOutputFormat();
        if (outputFormat != null) {
            return outputFormat.getConfig();
        }
        return null;
    }

    public AudioTrack getRemoteTrack() {
        return this._remoteTrack;
    }

    @Override
    public double getVolume() {
        return this.__volume;
    }

    @Override
    protected void processBandwidthAdapatationPolicyChange(BandwidthAdaptationPolicy policy) {
        super.processBandwidthAdapatationPolicyChange(policy);
    }

    @Override
    public void setGain(double value) {
        this.__gain = MathAssistant.max(value, 0.0);
    }

    private void setLocalTrack(AudioTrack value) {
        this._localTrack = value;
    }

    private void setRemoteTrack(AudioTrack value) {
        this._remoteTrack = value;
    }

    @Override
    public void setVolume(double value) {
        this.__volume = MathAssistant.min(MathAssistant.max(value, 0.0), 1.0);
    }
}

