/*
 * Decompiled with CFR 0.152.
 */
package com.mctech.library.keyboard.visibilitymonitor;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.OnLifecycleEvent;
import com.mctech.library.keyboard.visibilitymonitor.KeyboardChange;
import com.mctech.library.keyboard.visibilitymonitor.KeyboardObservableSettings;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002BB\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001b\u001a\u00020\u000fH\u0007J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0014H\u0002J\b\u0010\"\u001a\u00020\u000fH\u0002J\b\u0010#\u001a\u00020\u000fH\u0002J\b\u0010$\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/mctech/library/keyboard/visibilitymonitor/KeyboardVisibilityMonitor;", "Landroid/widget/PopupWindow;", "Landroidx/lifecycle/LifecycleObserver;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "keyboardObservableSettings", "Lcom/mctech/library/keyboard/visibilitymonitor/KeyboardObservableSettings;", "onChangeCallback", "Lkotlin/Function1;", "Lcom/mctech/library/keyboard/visibilitymonitor/KeyboardChange;", "Lkotlin/ParameterName;", "name", "change", "", "(Landroidx/lifecycle/LifecycleOwner;Landroidx/appcompat/app/AppCompatActivity;Lcom/mctech/library/keyboard/visibilitymonitor/KeyboardObservableSettings;Lkotlin/jvm/functions/Function1;)V", "activityMainContainer", "Landroid/view/View;", "countTimesNotified", "", "lastChange", "onGlobalLayoutListener", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "popupView", "shouldConsiderActionBarSize", "", "close", "getStatusBarHeight", "context", "Landroid/content/Context;", "handleOnGlobalLayout", "notifyKeyboardHeightChanged", "height", "registerKeyboardChanges", "removeLayoutChanges", "showPopup", "library_release"})
public final class KeyboardVisibilityMonitor
extends PopupWindow
implements LifecycleObserver {
    private final View activityMainContainer;
    private final View popupView;
    private int countTimesNotified;
    private KeyboardChange lastChange;
    private boolean shouldConsiderActionBarSize;
    private final ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
    private final AppCompatActivity activity;
    private final KeyboardObservableSettings keyboardObservableSettings;
    private final Function1<KeyboardChange, Unit> onChangeCallback;

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void close() {
        this.removeLayoutChanges();
        this.dismiss();
    }

    private final void handleOnGlobalLayout() {
        int keyboardHeight;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = this.activity.getWindowManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)windowManager, (String)"activity.windowManager");
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        Rect rect = new Rect();
        View view = this.popupView;
        if (view != null) {
            view.getWindowVisibleDisplayFrame(rect);
        }
        int n = keyboardHeight = rect.bottom > displayMetrics.heightPixels || rect.bottom == displayMetrics.heightPixels ? 0 : displayMetrics.heightPixels - rect.bottom + this.getStatusBarHeight((Context)this.activity);
        if (keyboardHeight == 0) {
            this.shouldConsiderActionBarSize = rect.bottom > displayMetrics.heightPixels;
        }
        switch (keyboardHeight) {
            case 0: {
                this.notifyKeyboardHeightChanged(0);
                break;
            }
            default: {
                this.notifyKeyboardHeightChanged(keyboardHeight);
            }
        }
    }

    private final int getStatusBarHeight(Context context) {
        if (!this.shouldConsiderActionBarSize) {
            return 0;
        }
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void notifyKeyboardHeightChanged(int height) {
        var2_2 = this.keyboardObservableSettings;
        var3_3 = false;
        var4_4 = false;
        synchronized (var2_2) {
            block5: {
                $i$a$-synchronized-KeyboardVisibilityMonitor$notifyKeyboardHeightChanged$1 = false;
                v0 = this;
                ++v0.countTimesNotified;
                if (v0.countTimesNotified <= 2 && !this.keyboardObservableSettings.getNotifyWhenScreenHasOpenedAtFirstTime()) break block5;
                newState = new KeyboardChange(height > 0, height > 0 ? height : 0);
                v1 = this.lastChange;
                if (v1 == null) ** GOTO lbl-1000
                var7_9 = v1;
                var8_10 = false;
                var9_11 = false;
                it = var7_9;
                $i$a$-takeIf-KeyboardVisibilityMonitor$notifyKeyboardHeightChanged$1$1 = false;
                v1 = it.isOpened() == newState.isOpened() != false ? var7_9 : null;
                if (v1 == null) ** GOTO lbl-1000
                var7_9 = v1;
                var8_10 = false;
                var9_11 = false;
                it = var7_9;
                $i$a$-takeIf-KeyboardVisibilityMonitor$notifyKeyboardHeightChanged$1$2 = false;
                v1 = this.keyboardObservableSettings.getNotifyOnlyWhenStateChange() != false ? var7_9 : null;
                if (v1 != null) {
                    var7_9 = v1;
                    var8_10 = false;
                    var9_11 = false;
                    it = var7_9;
                    $i$a$-let-KeyboardVisibilityMonitor$notifyKeyboardHeightChanged$1$3 = false;
                } else lbl-1000:
                // 3 sources

                {
                    var7_9 = newState;
                    var12_14 = this.onChangeCallback;
                    var8_10 = false;
                    var9_11 = false;
                    $this$apply = var7_9;
                    $i$a$-apply-KeyboardVisibilityMonitor$notifyKeyboardHeightChanged$1$4 = false;
                    this.lastChange = $this$apply;
                    var13_15 = var7_9;
                    var12_14.invoke((Object)var13_15);
                }
            }
            var4_5 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void showPopup() {
        Boolean bl = this.isShowing();
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (bl) {
            boolean bl4 = false;
            if (this.isShowing()) {
                return;
            }
            if (this.activityMainContainer.getWindowToken() == null) {
                return;
            }
            this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.showAtLocation(this.activityMainContainer, 0, 0, 0);
            this.registerKeyboardChanges();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void registerKeyboardChanges() {
        block0: {
            this.removeLayoutChanges();
            View view = this.popupView;
            if (view == null || (view = view.getViewTreeObserver()) == null) break block0;
            view.addOnGlobalLayoutListener(this.onGlobalLayoutListener);
        }
    }

    private final void removeLayoutChanges() {
        block1: {
            block0: {
                if (Build.VERSION.SDK_INT < 16) break block0;
                View view = this.popupView;
                if (view == null || (view = view.getViewTreeObserver()) == null) break block1;
                view.removeOnGlobalLayoutListener(this.onGlobalLayoutListener);
                break block1;
            }
            View view = this.popupView;
            if (view == null || (view = view.getViewTreeObserver()) == null) break block1;
            view.removeGlobalOnLayoutListener(this.onGlobalLayoutListener);
        }
    }

    public KeyboardVisibilityMonitor(@NotNull LifecycleOwner lifecycleOwner, @NotNull AppCompatActivity activity, @NotNull KeyboardObservableSettings keyboardObservableSettings, @NotNull Function1<? super KeyboardChange, Unit> onChangeCallback) {
        Intrinsics.checkParameterIsNotNull((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)keyboardObservableSettings, (String)"keyboardObservableSettings");
        Intrinsics.checkParameterIsNotNull(onChangeCallback, (String)"onChangeCallback");
        super((Context)activity);
        this.activity = activity;
        this.keyboardObservableSettings = keyboardObservableSettings;
        this.onChangeCallback = onChangeCallback;
        this.onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ KeyboardVisibilityMonitor this$0;

            public final void onGlobalLayout() {
                KeyboardVisibilityMonitor.access$handleOnGlobalLayout(this.this$0);
            }
            {
                this.this$0 = keyboardVisibilityMonitor;
            }
        };
        FrameLayout frameLayout = new FrameLayout((Context)this.activity);
        KeyboardVisibilityMonitor keyboardVisibilityMonitor = this;
        boolean bl = false;
        boolean bl2 = false;
        FrameLayout $this$apply = frameLayout;
        boolean bl3 = false;
        $this$apply.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        FrameLayout frameLayout2 = frameLayout;
        keyboardVisibilityMonitor.popupView = (View)frameLayout2;
        this.setContentView(this.popupView);
        this.setSoftInputMode(21);
        this.setInputMethodMode(1);
        this.setWidth(0);
        this.setHeight(-1);
        View view = this.activity.findViewById(0x1020002);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"activity.findViewById(android.R.id.content)");
        this.activityMainContainer = view;
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this);
        LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)lifecycleOwner).launchWhenResumed((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            Object L$0;
            int label;
            final /* synthetic */ KeyboardVisibilityMonitor this$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$launchWhenResumed = this.p$;
lbl6:
                        // 3 sources

                        while (!this.this$0.isShowing() && CoroutineScopeKt.isActive((CoroutineScope)$this$launchWhenResumed)) {
                            KeyboardVisibilityMonitor.access$showPopup(this.this$0);
                            this.L$0 = $this$launchWhenResumed;
                            this.label = 1;
                            v0 = DelayKt.delay((long)100L, (Continuation)this);
                            if (v0 != var3_2) continue;
                            return var3_2;
                        }
                        break;
                    }
                    case 1: {
                        $this$launchWhenResumed = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = keyboardVisibilityMonitor;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public /* synthetic */ KeyboardVisibilityMonitor(LifecycleOwner lifecycleOwner, AppCompatActivity appCompatActivity, KeyboardObservableSettings keyboardObservableSettings, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            keyboardObservableSettings = new KeyboardObservableSettings(false, false, 3, null);
        }
        this(lifecycleOwner, appCompatActivity, keyboardObservableSettings, (Function1<? super KeyboardChange, Unit>)function1);
    }

    public static final /* synthetic */ void access$handleOnGlobalLayout(KeyboardVisibilityMonitor $this) {
        $this.handleOnGlobalLayout();
    }

    public static final /* synthetic */ void access$showPopup(KeyboardVisibilityMonitor $this) {
        $this.showPopup();
    }
}

