/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log.log4j;

import com.mchange.v2.log.FallbackMLog;
import com.mchange.v2.log.LogUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.NullMLogger;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class Log4jMLog
extends MLog {
    static final String CHECK_CLASS = "org.apache.log4j.Logger";
    MLogger global = null;

    public Log4jMLog() throws ClassNotFoundException {
        Class.forName(CHECK_CLASS);
    }

    @Override
    public MLogger getMLogger(String name) {
        Logger lg = Logger.getLogger((String)name);
        if (lg == null) {
            this.fallbackWarn(" with name '" + name + "'");
            return NullMLogger.instance();
        }
        return new Log4jMLogger(lg);
    }

    @Override
    public MLogger getMLogger(Class cl) {
        Logger lg = Logger.getLogger((Class)cl);
        if (lg == null) {
            this.fallbackWarn(" for class '" + cl.getName() + "'");
            return NullMLogger.instance();
        }
        return new Log4jMLogger(lg);
    }

    @Override
    public MLogger getMLogger() {
        Logger lg = Logger.getRootLogger();
        if (lg == null) {
            this.fallbackWarn(" (root logger)");
            return NullMLogger.instance();
        }
        return new Log4jMLogger(lg);
    }

    private void fallbackWarn(String subst) {
        FallbackMLog.getLogger().warning("Could not create or find log4j Logger" + subst + ". " + "Using NullMLogger. All messages sent to this" + "logger will be silently ignored. You might want to fix this.");
    }

    private static String formatMessage(String rbname, String msg, Object[] params) {
        String check;
        if (msg == null) {
            if (params == null) {
                return "";
            }
            return LogUtils.createParamsList(params);
        }
        ResourceBundle rb = ResourceBundle.getBundle(rbname);
        if (rb != null && (check = rb.getString(msg)) != null) {
            msg = check;
        }
        return params == null ? msg : MessageFormat.format(msg, params);
    }

    private static final class Log4jMLogger
    implements MLogger {
        static final String FQCN = Log4jMLogger.class.getName();
        MLevel myLevel = null;
        final Logger logger;

        Log4jMLogger(Logger logger) {
            this.logger = logger;
        }

        private static MLevel guessMLevel(Level lvl) {
            if (lvl == null) {
                return null;
            }
            if (lvl == Level.ALL) {
                return MLevel.ALL;
            }
            if (lvl == Level.DEBUG) {
                return MLevel.FINEST;
            }
            if (lvl == Level.ERROR) {
                return MLevel.SEVERE;
            }
            if (lvl == Level.FATAL) {
                return MLevel.SEVERE;
            }
            if (lvl == Level.INFO) {
                return MLevel.INFO;
            }
            if (lvl == Level.OFF) {
                return MLevel.OFF;
            }
            if (lvl == Level.WARN) {
                return MLevel.WARNING;
            }
            throw new IllegalArgumentException("Unknown level: " + lvl);
        }

        private static Level level(MLevel lvl) {
            if (lvl == null) {
                return null;
            }
            if (lvl == MLevel.ALL) {
                return Level.ALL;
            }
            if (lvl == MLevel.CONFIG) {
                return Level.DEBUG;
            }
            if (lvl == MLevel.FINE) {
                return Level.DEBUG;
            }
            if (lvl == MLevel.FINER) {
                return Level.DEBUG;
            }
            if (lvl == MLevel.FINEST) {
                return Level.DEBUG;
            }
            if (lvl == MLevel.INFO) {
                return Level.INFO;
            }
            if (lvl == MLevel.INFO) {
                return Level.OFF;
            }
            if (lvl == MLevel.SEVERE) {
                return Level.ERROR;
            }
            if (lvl == MLevel.WARNING) {
                return Level.WARN;
            }
            throw new IllegalArgumentException("Unknown MLevel: " + lvl);
        }

        private static String createMessage(String srcClass, String srcMeth, String msg) {
            StringBuffer sb = new StringBuffer(511);
            sb.append("[class: ");
            sb.append(srcClass);
            sb.append("; method: ");
            sb.append(srcMeth);
            if (!srcMeth.endsWith(")")) {
                sb.append("()");
            }
            sb.append("] ");
            sb.append(msg);
            return sb.toString();
        }

        private static String createMessage(String srcMeth, String msg) {
            StringBuffer sb = new StringBuffer(511);
            sb.append("[method: ");
            sb.append(srcMeth);
            if (!srcMeth.endsWith(")")) {
                sb.append("()");
            }
            sb.append("] ");
            sb.append(msg);
            return sb.toString();
        }

        @Override
        public ResourceBundle getResourceBundle() {
            return null;
        }

        @Override
        public String getResourceBundleName() {
            return null;
        }

        @Override
        public void setFilter(Object java14Filter) throws SecurityException {
            this.warning("setFilter() not supported by MLogger " + this.getClass().getName());
        }

        @Override
        public Object getFilter() {
            return null;
        }

        private void log(Level lvl, Object msg, Throwable t) {
            this.logger.log(FQCN, (Priority)lvl, msg, t);
        }

        @Override
        public void log(MLevel l, String msg) {
            this.log(Log4jMLogger.level(l), (Object)msg, null);
        }

        @Override
        public void log(MLevel l, String msg, Object param) {
            this.log(Log4jMLogger.level(l), msg != null ? MessageFormat.format(msg, param) : null, null);
        }

        @Override
        public void log(MLevel l, String msg, Object[] params) {
            this.log(Log4jMLogger.level(l), (Object)(msg != null ? MessageFormat.format(msg, params) : null), null);
        }

        @Override
        public void log(MLevel l, String msg, Throwable t) {
            this.log(Log4jMLogger.level(l), (Object)msg, t);
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg) {
            this.log(Log4jMLogger.level(l), (Object)Log4jMLogger.createMessage(srcClass, srcMeth, msg), null);
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object param) {
            this.log(Log4jMLogger.level(l), (Object)Log4jMLogger.createMessage(srcClass, srcMeth, msg != null ? MessageFormat.format(msg, param) : null), null);
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object[] params) {
            this.log(Log4jMLogger.level(l), (Object)Log4jMLogger.createMessage(srcClass, srcMeth, msg != null ? MessageFormat.format(msg, params) : null), null);
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Throwable t) {
            this.log(Log4jMLogger.level(l), (Object)Log4jMLogger.createMessage(srcClass, srcMeth, msg), t);
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg) {
            this.log(Log4jMLogger.level(l), (Object)Log4jMLogger.createMessage(srcClass, srcMeth, Log4jMLog.formatMessage(rb, msg, null)), null);
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object param) {
            this.log(Log4jMLogger.level(l), (Object)Log4jMLogger.createMessage(srcClass, srcMeth, Log4jMLog.formatMessage(rb, msg, new Object[]{param})), null);
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object[] params) {
            this.log(Log4jMLogger.level(l), (Object)Log4jMLogger.createMessage(srcClass, srcMeth, Log4jMLog.formatMessage(rb, msg, params)), null);
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Throwable t) {
            this.log(Log4jMLogger.level(l), (Object)Log4jMLogger.createMessage(srcClass, srcMeth, Log4jMLog.formatMessage(rb, msg, null)), t);
        }

        @Override
        public void entering(String srcClass, String srcMeth) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(srcClass, srcMeth, "entering method."), null);
        }

        @Override
        public void entering(String srcClass, String srcMeth, Object param) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(srcClass, srcMeth, "entering method... param: " + param.toString()), null);
        }

        @Override
        public void entering(String srcClass, String srcMeth, Object[] params) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(srcClass, srcMeth, "entering method... " + LogUtils.createParamsList(params)), null);
        }

        @Override
        public void exiting(String srcClass, String srcMeth) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(srcClass, srcMeth, "exiting method."), null);
        }

        @Override
        public void exiting(String srcClass, String srcMeth, Object result) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(srcClass, srcMeth, "exiting method... result: " + result.toString()), null);
        }

        @Override
        public void throwing(String srcClass, String srcMeth, Throwable t) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(srcClass, srcMeth, "throwing exception... "), t);
        }

        @Override
        public void severe(String msg) {
            this.log(Level.ERROR, (Object)msg, null);
        }

        @Override
        public void warning(String msg) {
            this.log(Level.WARN, (Object)msg, null);
        }

        @Override
        public void info(String msg) {
            this.log(Level.INFO, (Object)msg, null);
        }

        @Override
        public void config(String msg) {
            this.log(Level.DEBUG, (Object)msg, null);
        }

        @Override
        public void fine(String msg) {
            this.log(Level.DEBUG, (Object)msg, null);
        }

        @Override
        public void finer(String msg) {
            this.log(Level.DEBUG, (Object)msg, null);
        }

        @Override
        public void finest(String msg) {
            this.log(Level.DEBUG, (Object)msg, null);
        }

        @Override
        public synchronized void setLevel(MLevel l) throws SecurityException {
            this.logger.setLevel(Log4jMLogger.level(l));
            this.myLevel = l;
        }

        @Override
        public synchronized MLevel getLevel() {
            if (this.myLevel == null) {
                this.myLevel = Log4jMLogger.guessMLevel(this.logger.getLevel());
            }
            return this.myLevel;
        }

        @Override
        public boolean isLoggable(MLevel l) {
            return this.logger.isEnabledFor((Priority)Log4jMLogger.level(l));
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public void addHandler(Object h) throws SecurityException {
            if (!(h instanceof Appender)) {
                throw new IllegalArgumentException("The 'handler' " + h + " is not compatible with MLogger " + this);
            }
            this.logger.addAppender((Appender)h);
        }

        @Override
        public void removeHandler(Object h) throws SecurityException {
            if (!(h instanceof Appender)) {
                throw new IllegalArgumentException("The 'handler' " + h + " is not compatible with MLogger " + this);
            }
            this.logger.removeAppender((Appender)h);
        }

        @Override
        public Object[] getHandlers() {
            LinkedList tmp = new LinkedList();
            Enumeration e = this.logger.getAllAppenders();
            while (e.hasMoreElements()) {
                tmp.add(e.nextElement());
            }
            return tmp.toArray();
        }

        @Override
        public void setUseParentHandlers(boolean uph) {
            this.logger.setAdditivity(uph);
        }

        @Override
        public boolean getUseParentHandlers() {
            return this.logger.getAdditivity();
        }
    }
}

