/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log.jdk14logging;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogConfig;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.DoubleWeakHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Jdk14MLog
extends MLog {
    static final String SUPPRESS_STACK_WALK_KEY = "com.mchange.v2.log.jdk14logging.suppressStackWalk";
    private static String[] UNKNOWN_ARRAY = new String[]{"UNKNOWN_CLASS", "UNKNOWN_METHOD"};
    private static final String CHECK_CLASS = "java.util.logging.Logger";
    private final Map namedLoggerMap = new DoubleWeakHashMap();
    private static final boolean suppress_stack_walk;
    MLogger global = null;

    public Jdk14MLog() throws ClassNotFoundException {
        Class.forName(CHECK_CLASS);
    }

    @Override
    public synchronized MLogger getMLogger(String name) {
        MLogger out = (MLogger)this.namedLoggerMap.get(name = name.intern());
        if (out == null) {
            Logger lg = Logger.getLogger(name);
            out = new Jdk14MLogger(lg);
            this.namedLoggerMap.put(name, out);
        }
        return out;
    }

    @Override
    public synchronized MLogger getMLogger(Class cl) {
        return Jdk14MLog.getLogger(cl.getName());
    }

    @Override
    public synchronized MLogger getMLogger() {
        if (this.global == null) {
            this.global = new Jdk14MLogger(LogManager.getLogManager().getLogger("global"));
        }
        return this.global;
    }

    private static String[] findCallingClassAndMethod() {
        for (StackTraceElement check : new Throwable().getStackTrace()) {
            String cn = check.getClassName();
            if (cn == null || cn.startsWith("com.mchange.v2.log.jdk14logging") || cn.startsWith("com.mchange.sc.v1.log")) continue;
            return new String[]{check.getClassName(), check.getMethodName()};
        }
        return UNKNOWN_ARRAY;
    }

    static {
        String suppressVal = MLogConfig.getProperty(SUPPRESS_STACK_WALK_KEY);
        if (suppressVal == null || (suppressVal = suppressVal.trim()).length() == 0) {
            suppress_stack_walk = false;
        } else if (suppressVal.equalsIgnoreCase("true")) {
            suppress_stack_walk = true;
        } else if (suppressVal.equalsIgnoreCase("false")) {
            suppress_stack_walk = false;
        } else {
            System.err.println("Bad value for com.mchange.v2.log.jdk14logging.suppressStackWalk: '" + suppressVal + "'; defaulting to 'false'.");
            suppress_stack_walk = false;
        }
    }

    private static final class Jdk14MLogger
    implements MLogger {
        final Logger logger;
        final String name;
        final ClassAndMethodFinder cmFinder;

        Jdk14MLogger(Logger logger) {
            this.logger = logger;
            this.name = logger.getName();
            this.cmFinder = suppress_stack_walk ? new ClassAndMethodFinder(){
                String[] fakedClassAndMethod;
                {
                    this.fakedClassAndMethod = new String[]{Jdk14MLogger.this.name, ""};
                }

                @Override
                public String[] find() {
                    return this.fakedClassAndMethod;
                }
            } : new ClassAndMethodFinder(){

                @Override
                public String[] find() {
                    return Jdk14MLog.findCallingClassAndMethod();
                }
            };
        }

        private static Level level(MLevel lvl) {
            return (Level)lvl.asJdk14Level();
        }

        @Override
        public ResourceBundle getResourceBundle() {
            return this.logger.getResourceBundle();
        }

        @Override
        public String getResourceBundleName() {
            return this.logger.getResourceBundleName();
        }

        @Override
        public void setFilter(Object java14Filter) throws SecurityException {
            if (!(java14Filter instanceof Filter)) {
                throw new IllegalArgumentException("MLogger.setFilter( ... ) requires a java.util.logging.Filter. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.setFilter((Filter)java14Filter);
        }

        @Override
        public Object getFilter() {
            return this.logger.getFilter();
        }

        @Override
        public void log(MLevel l, String msg) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Jdk14MLogger.level(l), sa[0], sa[1], msg);
        }

        @Override
        public void log(MLevel l, String msg, Object param) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Jdk14MLogger.level(l), sa[0], sa[1], msg, param);
        }

        @Override
        public void log(MLevel l, String msg, Object[] params) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Jdk14MLogger.level(l), sa[0], sa[1], msg, params);
        }

        @Override
        public void log(MLevel l, String msg, Throwable t) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Jdk14MLogger.level(l), sa[0], sa[1], msg, t);
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = this.cmFinder.find();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l), srcClass, srcMeth, msg);
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object param) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = this.cmFinder.find();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l), srcClass, srcMeth, msg, param);
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object[] params) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = this.cmFinder.find();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l), srcClass, srcMeth, msg, params);
        }

        @Override
        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Throwable t) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = this.cmFinder.find();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l), srcClass, srcMeth, msg, t);
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = this.cmFinder.find();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l), srcClass, srcMeth, rb, msg);
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object param) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = this.cmFinder.find();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l), srcClass, srcMeth, rb, msg, param);
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object[] params) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = this.cmFinder.find();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l), srcClass, srcMeth, rb, msg, params);
        }

        @Override
        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Throwable t) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = this.cmFinder.find();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l), srcClass, srcMeth, rb, msg, t);
        }

        @Override
        public void entering(String srcClass, String srcMeth) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(srcClass, srcMeth);
        }

        @Override
        public void entering(String srcClass, String srcMeth, Object param) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(srcClass, srcMeth, param);
        }

        @Override
        public void entering(String srcClass, String srcMeth, Object[] params) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(srcClass, srcMeth, params);
        }

        @Override
        public void exiting(String srcClass, String srcMeth) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.exiting(srcClass, srcMeth);
        }

        @Override
        public void exiting(String srcClass, String srcMeth, Object result) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.exiting(srcClass, srcMeth, result);
        }

        @Override
        public void throwing(String srcClass, String srcMeth, Throwable t) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.throwing(srcClass, srcMeth, t);
        }

        @Override
        public void severe(String msg) {
            if (!this.logger.isLoggable(Level.SEVERE)) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Level.SEVERE, sa[0], sa[1], msg);
        }

        @Override
        public void warning(String msg) {
            if (!this.logger.isLoggable(Level.WARNING)) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Level.WARNING, sa[0], sa[1], msg);
        }

        @Override
        public void info(String msg) {
            if (!this.logger.isLoggable(Level.INFO)) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Level.INFO, sa[0], sa[1], msg);
        }

        @Override
        public void config(String msg) {
            if (!this.logger.isLoggable(Level.CONFIG)) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Level.CONFIG, sa[0], sa[1], msg);
        }

        @Override
        public void fine(String msg) {
            if (!this.logger.isLoggable(Level.FINE)) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Level.FINE, sa[0], sa[1], msg);
        }

        @Override
        public void finer(String msg) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Level.FINER, sa[0], sa[1], msg);
        }

        @Override
        public void finest(String msg) {
            if (!this.logger.isLoggable(Level.FINEST)) {
                return;
            }
            String[] sa = this.cmFinder.find();
            this.logger.logp(Level.FINEST, sa[0], sa[1], msg);
        }

        @Override
        public void setLevel(MLevel l) throws SecurityException {
            this.logger.setLevel(Jdk14MLogger.level(l));
        }

        @Override
        public MLevel getLevel() {
            return MLevel.fromIntValue(this.logger.getLevel().intValue());
        }

        @Override
        public boolean isLoggable(MLevel l) {
            return this.logger.isLoggable(Jdk14MLogger.level(l));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void addHandler(Object h) throws SecurityException {
            if (!(h instanceof Handler)) {
                throw new IllegalArgumentException("MLogger.addHandler( ... ) requires a java.util.logging.Handler. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.addHandler((Handler)h);
        }

        @Override
        public void removeHandler(Object h) throws SecurityException {
            if (!(h instanceof Handler)) {
                throw new IllegalArgumentException("MLogger.removeHandler( ... ) requires a java.util.logging.Handler. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.removeHandler((Handler)h);
        }

        @Override
        public Object[] getHandlers() {
            return this.logger.getHandlers();
        }

        @Override
        public void setUseParentHandlers(boolean uph) {
            this.logger.setUseParentHandlers(uph);
        }

        @Override
        public boolean getUseParentHandlers() {
            return this.logger.getUseParentHandlers();
        }

        static interface ClassAndMethodFinder {
            public String[] find();
        }
    }
}

