/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.beans.swing;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.beans.swing.HostBindingInterface;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;

class PropertyComponentBindingUtility {
    static final Object[] EMPTY_ARGS = new Object[0];
    HostBindingInterface hbi;
    Object bean;
    PropertyDescriptor pd = null;
    EventSetDescriptor propChangeEsd = null;
    Method addMethod = null;
    Method removeMethod = null;
    Method propGetter = null;
    Method propSetter = null;
    PropertyEditor propEditor = null;
    Object nullReplacement = null;

    PropertyComponentBindingUtility(final HostBindingInterface hbi, Object bean, final String propName, boolean requirePropEditor) throws IntrospectionException {
        this.hbi = hbi;
        this.bean = bean;
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        for (PropertyDescriptor checkPd : beanInfo.getPropertyDescriptors()) {
            if (!propName.equals(checkPd.getName())) continue;
            this.pd = checkPd;
            break;
        }
        if (this.pd == null) {
            throw new IntrospectionException("Cannot find property on bean Object with name '" + propName + "'.");
        }
        for (EventSetDescriptor checkEsd : beanInfo.getEventSetDescriptors()) {
            if (!"propertyChange".equals(checkEsd.getName())) continue;
            this.propChangeEsd = checkEsd;
            break;
        }
        if (this.propChangeEsd == null) {
            throw new IntrospectionException("Cannot find PropertyChangeEvent on bean Object with name '" + propName + "'.");
        }
        this.propEditor = BeansUtils.findPropertyEditor(this.pd);
        if (requirePropEditor && this.propEditor == null) {
            throw new IntrospectionException("Could not find an appropriate PropertyEditor for property: " + propName);
        }
        this.propGetter = this.pd.getReadMethod();
        this.propSetter = this.pd.getWriteMethod();
        if (this.propGetter == null || this.propSetter == null) {
            throw new IntrospectionException("The specified property '" + propName + "' must be both readdable and writable, but it is not!");
        }
        Class<?> propType = this.pd.getPropertyType();
        if (propType.isPrimitive()) {
            if (propType == Boolean.TYPE) {
                this.nullReplacement = Boolean.FALSE;
            }
            if (propType == Byte.TYPE) {
                this.nullReplacement = new Byte(0);
            } else if (propType == Character.TYPE) {
                this.nullReplacement = new Character('\u0000');
            } else if (propType == Short.TYPE) {
                this.nullReplacement = new Short(0);
            } else if (propType == Integer.TYPE) {
                this.nullReplacement = new Integer(0);
            } else if (propType == Long.TYPE) {
                this.nullReplacement = new Long(0L);
            } else if (propType == Float.TYPE) {
                this.nullReplacement = new Float(0.0f);
            } else if (propType == Double.TYPE) {
                this.nullReplacement = new Double(0.0);
            } else {
                throw new InternalError("What kind of primitive is " + propType.getName() + "???");
            }
        }
        this.addMethod = this.propChangeEsd.getAddListenerMethod();
        this.removeMethod = this.propChangeEsd.getAddListenerMethod();
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String chkPropName = evt.getPropertyName();
                if (chkPropName.equals(propName)) {
                    hbi.syncToValue(PropertyComponentBindingUtility.this.propEditor, evt.getNewValue());
                }
            }
        };
        try {
            this.addMethod.invoke(bean, pcl);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IntrospectionException("The introspected PropertyChangeEvent adding method failed with an Exception.");
        }
        hbi.addUserModificationListeners();
    }

    public void userModification() {
        Object oldValue = null;
        try {
            oldValue = this.propGetter.invoke(this.bean, EMPTY_ARGS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Object newValue = this.hbi.fetchUserModification(this.propEditor, oldValue);
            if (newValue == null) {
                newValue = this.nullReplacement;
            }
            this.propSetter.invoke(this.bean, newValue);
        }
        catch (Exception e) {
            if (!(e instanceof PropertyVetoException)) {
                e.printStackTrace();
            }
            this.syncComponentToValue(true);
        }
    }

    public void resync() {
        this.syncComponentToValue(false);
    }

    private void syncComponentToValue(final boolean alert_error) {
        try {
            final Object reversionValue = this.propGetter.invoke(this.bean, EMPTY_ARGS);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    if (alert_error) {
                        PropertyComponentBindingUtility.this.hbi.alertErroneousInput();
                    }
                    PropertyComponentBindingUtility.this.hbi.syncToValue(PropertyComponentBindingUtility.this.propEditor, reversionValue);
                }
            };
            SwingUtilities.invokeLater(task);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

