/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.LongObjectMap;
import com.mchange.util.impl.LOHRecord;

public class LongObjectHash
implements LongObjectMap {
    LOHRecord[] records;
    float load_factor;
    long threshold;
    long size;

    public LongObjectHash(int init_capacity, float load_factor) {
        this.records = new LOHRecord[init_capacity];
        this.load_factor = load_factor;
        this.threshold = (long)(load_factor * (float)init_capacity);
    }

    public LongObjectHash() {
        this(101, 0.75f);
    }

    @Override
    public synchronized Object get(long num) {
        int index = (int)(num % (long)this.records.length);
        Object out = null;
        if (this.records[index] != null) {
            out = this.records[index].get(num);
        }
        return out;
    }

    @Override
    public synchronized void put(long num, Object obj) {
        boolean replaced;
        int index = (int)(num % (long)this.records.length);
        if (this.records[index] == null) {
            this.records[index] = new LOHRecord(index);
        }
        if (!(replaced = this.records[index].add(num, obj, true))) {
            ++this.size;
        }
        if (this.size > this.threshold) {
            this.rehash();
        }
    }

    @Override
    public synchronized boolean putNoReplace(long num, Object obj) {
        boolean needed_replace;
        int index = (int)(num % (long)this.records.length);
        if (this.records[index] == null) {
            this.records[index] = new LOHRecord(index);
        }
        if (needed_replace = this.records[index].add(num, obj, false)) {
            return false;
        }
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
        return true;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public synchronized boolean containsLong(long num) {
        int index = (int)(num % (long)this.records.length);
        return this.records[index] != null && this.records[index].findLong(num) != null;
    }

    @Override
    public synchronized Object remove(long num) {
        Object out;
        LOHRecord rec = this.records[(int)(num % (long)this.records.length)];
        Object object = out = rec == null ? null : rec.remove(num);
        if (out != null) {
            --this.size;
        }
        return out;
    }

    protected void rehash() {
        if ((long)this.records.length * 2L > Integer.MAX_VALUE) {
            throw new Error("Implementation of LongObjectHash allows a capacity of only 2147483647");
        }
        LOHRecord[] newRecords = new LOHRecord[this.records.length * 2];
        for (int i = 0; i < this.records.length; ++i) {
            if (this.records[i] == null) continue;
            newRecords[i] = this.records[i];
            newRecords[i * 2] = this.records[i].split(newRecords.length);
        }
        this.records = newRecords;
        this.threshold = (long)(this.load_factor * (float)this.records.length);
    }
}

