/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.io.impl;

import com.mchange.io.FileEnumeration;
import com.mchange.io.IOEnumeration;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;

public class DirectoryDescendingFileFinderImpl
implements IOEnumeration,
FileEnumeration {
    private static final Object dummy = new Object();
    Hashtable markedDirex = new Hashtable();
    Stack direx = new Stack();
    Stack files = new Stack();
    FilenameFilter filter;
    boolean canonical;

    public DirectoryDescendingFileFinderImpl(File root, FilenameFilter filter, boolean canonical) throws IOException {
        if (!root.isDirectory()) {
            throw new IllegalArgumentException(root.getName() + " is not a directory.");
        }
        this.filter = filter;
        this.canonical = canonical;
        this.blossomDirectory(root);
        while (this.files.empty() && !this.direx.empty()) {
            this.blossomDirectory((File)this.direx.pop());
        }
    }

    public DirectoryDescendingFileFinderImpl(File root) throws IOException {
        this(root, null, false);
    }

    @Override
    public boolean hasMoreFiles() {
        return !this.files.empty();
    }

    @Override
    public File nextFile() throws IOException {
        if (this.files.empty()) {
            throw new NoSuchElementException();
        }
        File out = (File)this.files.pop();
        while (this.files.empty() && !this.direx.empty()) {
            this.blossomDirectory((File)this.direx.pop());
        }
        return out;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreFiles();
    }

    @Override
    public Object nextElement() throws IOException {
        return this.nextFile();
    }

    private void blossomDirectory(File dir) throws IOException {
        String canonicalPath = dir.getCanonicalPath();
        String[] listing = this.filter == null ? dir.list() : dir.list(this.filter);
        int i = listing.length;
        while (--i >= 0) {
            if (this.filter != null && !this.filter.accept(dir, listing[i])) continue;
            String name = (this.canonical ? canonicalPath : dir.getPath()) + File.separator + listing[i];
            File file = new File(name);
            if (file.isFile()) {
                this.files.push(file);
                continue;
            }
            if (this.markedDirex.containsKey(file.getCanonicalPath())) continue;
            this.direx.push(file);
        }
        this.markedDirex.put(canonicalPath, dummy);
    }

    public static void main(String[] argv) {
        try {
            File root = new File(argv[0]);
            DirectoryDescendingFileFinderImpl files = new DirectoryDescendingFileFinderImpl(root);
            while (files.hasMoreFiles()) {
                System.out.println(files.nextFile().getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

