/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.lang;

import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class StringUtils {
    static final Pattern COMMA_SEP_TRIM_REGEX;
    static final Pattern COMMA_SEP_NO_TRIM_REGEX;
    public static final String[] EMPTY_STRING_ARRAY;

    public static String normalString(String s) {
        return StringUtils.nonEmptyTrimmedOrNull(s);
    }

    public static boolean nonEmptyString(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean nonWhitespaceString(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static String nonEmptyOrNull(String s) {
        return StringUtils.nonEmptyString(s) ? s : null;
    }

    public static String nonNullOrBlank(String s) {
        return s != null ? s : "";
    }

    public static String nonEmptyTrimmedOrNull(String s) {
        String out = s;
        if (out != null) {
            out = (out = out.trim()).length() > 0 ? out : null;
        }
        return out;
    }

    public static byte[] getUTF8Bytes(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new InternalError("UTF8 is an unsupported encoding?!?");
        }
    }

    public static String[] splitCommaSeparated(String commaSep, boolean trim) {
        Pattern pattern = trim ? COMMA_SEP_TRIM_REGEX : COMMA_SEP_NO_TRIM_REGEX;
        return pattern.split(commaSep);
    }

    static {
        try {
            COMMA_SEP_TRIM_REGEX = Pattern.compile("\\s*\\,\\s*");
            COMMA_SEP_NO_TRIM_REGEX = Pattern.compile("\\,");
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            throw new InternalError(e.toString());
        }
        EMPTY_STRING_ARRAY = new String[0];
    }
}

