/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.lang.ByteUtils;
import com.mchange.v1.identicator.Identicator;
import com.mchange.v1.identicator.IdentityHashCodeIdenticator;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.AbstractNewProxyConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.encounter.EncounterCounter;
import com.mchange.v2.encounter.EncounterUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.jdk14logging.ForwardingLogger;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.sql.SqlUtils;
import com.mchange.v2.uid.UidUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

public final class C3P0ImplUtils {
    private static final boolean CONDITIONAL_LONG_TOKENS = false;
    static final MLogger logger = MLog.getLogger(C3P0ImplUtils.class);
    public static final DbAuth NULL_AUTH = new DbAuth(null, null);
    public static final Object[] NOARGS = new Object[0];
    public static final Logger PARENT_LOGGER = new ForwardingLogger(MLog.getLogger((String)"com.mchange.v2.c3p0"), null);
    private static final EncounterCounter ID_TOKEN_COUNTER = C3P0ImplUtils.createEncounterCounter();
    public static final String VMID_PROPKEY = "com.mchange.v2.c3p0.VMID";
    private static final String VMID_PFX;
    private static final String HASM_HEADER = "HexAsciiSerializedMap";

    private static EncounterCounter createEncounterCounter() {
        return EncounterUtils.syncWrap((EncounterCounter)EncounterUtils.createWeak((Identicator)IdentityHashCodeIdenticator.INSTANCE));
    }

    public static String allocateIdentityToken(Object object) {
        long l;
        if (object == null) {
            return null;
        }
        String string = Integer.toString(System.identityHashCode(object), 16);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(VMID_PFX);
        if (ID_TOKEN_COUNTER != null && (l = ID_TOKEN_COUNTER.encounter((Object)string)) > 0L) {
            stringBuffer.append(string);
            stringBuffer.append('#');
            stringBuffer.append(l);
        } else {
            stringBuffer.append(string);
        }
        String string2 = stringBuffer.toString().intern();
        return string2;
    }

    public static DbAuth findAuth(Object object) throws SQLException {
        if (object == null) {
            return NULL_AUTH;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                Method method;
                Class<?> clazz = propertyDescriptor.getPropertyType();
                String string5 = propertyDescriptor.getName();
                if (clazz != String.class || (method = propertyDescriptor.getReadMethod()) == null) continue;
                Object object2 = method.invoke(object, NOARGS);
                String string6 = (String)object2;
                if ("user".equals(string5)) {
                    string = string6;
                    continue;
                }
                if ("password".equals(string5)) {
                    string2 = string6;
                    continue;
                }
                if ("overrideDefaultUser".equals(string5)) {
                    string3 = string6;
                    continue;
                }
                if (!"overrideDefaultPassword".equals(string5)) continue;
                string4 = string6;
            }
            if (string3 != null) {
                return new DbAuth(string3, string4);
            }
            if (string != null) {
                return new DbAuth(string, string2);
            }
            return NULL_AUTH;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "An exception occurred while trying to extract the default authentification info from a bean.", (Throwable)exception);
            }
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    static void resetTxnState(Connection connection, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        if (!bl && !connection.getAutoCommit()) {
            if (!bl2 && !bl3) {
                connection.rollback();
            }
            connection.setAutoCommit(true);
        }
    }

    public static boolean supportsMethod(Object object, String string, Class[] classArray) {
        try {
            return object.getClass().getMethod(string, classArray) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (SecurityException securityException) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "We were denied access in a check of whether " + object + " supports method " + string + ". Prob means external clients have no access, returning false.", (Throwable)securityException);
            }
            return false;
        }
    }

    public static String createUserOverridesAsString(Map map) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HASM_HEADER);
        stringBuffer.append('[');
        stringBuffer.append(ByteUtils.toHexAscii((byte[])SerializableUtils.toByteArray((Object)map)));
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static Map parseUserOverridesAsString(String string) throws IOException, ClassNotFoundException {
        if (string != null) {
            String string2 = string.substring(HASM_HEADER.length() + 1, string.length() - 1);
            byte[] byArray = ByteUtils.fromHexAscii((String)string2);
            return Collections.unmodifiableMap((Map)SerializableUtils.fromByteArray((byte[])byArray));
        }
        return Collections.EMPTY_MAP;
    }

    public static void runWithContextClassLoaderAndPrivileges(String string, final boolean bl, final Runnable runnable) {
        block7: {
            try {
                class ContextClassLoaderPoolsInitThread
                extends Thread {
                    ContextClassLoaderPoolsInitThread(ClassLoader classLoader) {
                        this.setContextClassLoader(classLoader);
                    }

                    @Override
                    public void run() {
                        C3P0ImplUtils.maybePrivilegedRun(bl, runnable);
                    }
                }
                if ("library".equalsIgnoreCase(string)) {
                    ContextClassLoaderPoolsInitThread contextClassLoaderPoolsInitThread = new ContextClassLoaderPoolsInitThread(C3P0ImplUtils.class.getClassLoader());
                    contextClassLoaderPoolsInitThread.start();
                    contextClassLoaderPoolsInitThread.join();
                } else if ("none".equalsIgnoreCase(string)) {
                    ContextClassLoaderPoolsInitThread contextClassLoaderPoolsInitThread = new ContextClassLoaderPoolsInitThread(null);
                    contextClassLoaderPoolsInitThread.start();
                    contextClassLoaderPoolsInitThread.join();
                } else {
                    if (logger.isLoggable(MLevel.WARNING) && !"caller".equalsIgnoreCase(string)) {
                        logger.log(MLevel.WARNING, "Unknown contextClassLoaderSource: " + string + " -- should be 'caller', 'library', or 'none'. Using default value 'caller'.");
                    }
                    C3P0ImplUtils.maybePrivilegedRun(bl, runnable);
                }
            }
            catch (InterruptedException interruptedException) {
                if (!logger.isLoggable(MLevel.SEVERE)) break block7;
                logger.log(MLevel.SEVERE, "Unexpected interruption while trying to run task with contextClassLoaderSource '" + string + "' and privilege_spawned_threads '" + bl + "'.", (Throwable)interruptedException);
            }
        }
    }

    private static void maybePrivilegedRun(boolean bl, final Runnable runnable) {
        if (bl) {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    runnable.run();
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
        } else {
            runnable.run();
        }
    }

    public static void assertCompileTimePresenceOfJdbc4_Jdk17Api(AbstractNewProxyConnection abstractNewProxyConnection) throws SQLException {
        abstractNewProxyConnection.getNetworkTimeout();
    }

    private C3P0ImplUtils() {
    }

    static {
        String string = C3P0Config.getPropsFileConfigProperty(VMID_PROPKEY);
        VMID_PFX = string == null || (string = string.trim()).equals("") || string.equals("AUTO") ? UidUtils.VM_ID + '|' : (string.equals("NONE") ? "" : string + "|");
    }
}

